/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.felix.gogo.shell.History;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;

public class Console
implements Runnable {
    private final CommandSession session;
    private final InputStream in;
    private final PrintStream out;
    private final History history;
    private volatile boolean quit;

    public Console(CommandSession session, History history) {
        this.session = session;
        this.in = session.getKeyboard();
        this.out = session.getConsole();
        this.history = history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            try {
                CharSequence line;
                while (!Thread.currentThread().isInterrupted() && !this.quit && (line = this.getLine(this.getPrompt())) != null) {
                    try {
                        if (line.charAt(0) == '!' || line.charAt(0) == '^') {
                            line = this.history.evaluate(line);
                            System.out.println(line);
                        }
                        Object result = this.session.execute(line);
                        this.session.put("_", result);
                        if (result == null || Boolean.FALSE.equals(this.session.get(".Gogo.format"))) continue;
                        this.out.println(this.session.format(result, 0));
                    }
                    catch (Throwable e) {
                        String SESSION_CLOSED = "session is closed";
                        if (e instanceof IllegalStateException && "session is closed".equals(e.getMessage())) {
                            this.out.println("gosh: " + e);
                            this.quit = true;
                        }
                        if (this.quit) continue;
                        this.session.put("exception", (Object)e);
                        Object loc = this.session.get(".location");
                        if (null == loc || !loc.toString().contains(":")) {
                            loc = "gogo";
                        }
                        this.out.println(loc + ": " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    }
                    finally {
                        this.history.append(line);
                    }
                }
            }
            catch (Exception e) {
                if (this.quit) break block11;
                e.printStackTrace();
            }
        }
    }

    private String getPrompt() {
        Object prompt = this.session.get("prompt");
        if (prompt instanceof Function) {
            try {
                prompt = ((Function)prompt).execute(this.session, null);
            }
            catch (Exception e) {
                this.out.println(prompt + ": " + e.getClass().getSimpleName() + ": " + e.getMessage());
                prompt = null;
            }
        }
        if (prompt == null) {
            prompt = "g! ";
        }
        return prompt.toString();
    }

    private CharSequence getLine(String prompt) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.out.print(prompt);
        block8: while (!this.quit) {
            this.out.flush();
            int c = 0;
            try {
                c = this.in.read();
            }
            catch (IOException e) {
                if ("Stream closed".equals(e.getMessage())) {
                    this.quit = true;
                }
                throw e;
            }
            switch (c) {
                case -1: 
                case 4: {
                    this.quit = true;
                    continue block8;
                }
                case 13: {
                    continue block8;
                }
                case 10: {
                    if (sb.length() > 0) {
                        return sb;
                    }
                    this.out.print(prompt);
                    continue block8;
                }
                case 8: {
                    if (sb.length() <= 0) continue block8;
                    this.out.print("\b \b");
                    sb.deleteCharAt(sb.length() - 1);
                    continue block8;
                }
            }
            sb.append((char)c);
        }
        return null;
    }
}

