/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLSemanticErrorAnnotation;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLProblemAnnotation;
import org.jkiss.dbeaver.ui.editors.sql.util.AbstractSQLEditorTextHover;
import org.jkiss.dbeaver.ui.editors.sql.util.AnnotationsInformationView;

public class SQLAnnotationHover
extends AbstractSQLEditorTextHover
implements ITextHover,
IAnnotationHover,
ITextHoverExtension,
ITextHoverExtension2,
IAnnotationHoverExtension {
    private static final Log log = Log.getLog(SQLAnnotationHover.class);
    private SQLEditorBase editor;

    public SQLAnnotationHover(SQLEditorBase editor) {
        this.setEditor((IEditorPart)editor);
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        try {
            int linePosition = sourceViewer.getDocument().getLineOffset(lineNumber);
            int lineLength = sourceViewer.getDocument().getLineLength(lineNumber);
            StringBuilder sb = new StringBuilder();
            Iterator ai = sourceViewer.getAnnotationModel().getAnnotationIterator();
            while (ai.hasNext()) {
                Position annoPosition;
                Annotation anno = (Annotation)ai.next();
                if (!this.isSupportedAnnotation(anno) || (annoPosition = sourceViewer.getAnnotationModel().getPosition(anno)) == null || !annoPosition.overlapsWith(linePosition, lineLength)) continue;
                sb.append(anno.getText()).append("; ");
            }
            return sb.isEmpty() ? null : sb.toString();
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return null;
        }
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object hoverInfo2 = this.getHoverInfo2(textViewer, hoverRegion);
        return hoverInfo2 == null ? null : hoverInfo2.toString();
    }

    @Nullable
    public Object getHoverInfo2(@NotNull ITextViewer textViewer, @NotNull IRegion hoverRegion) {
        return this.getAnnotationsHoverInfo(textViewer, hoverRegion, null, false);
    }

    @Nullable
    public AnnotationsInformationView.AnnotationsHoverInfo getAnnotationsHoverInfo(@NotNull ITextViewer textViewer, @NotNull IRegion hoverRegion, @Nullable Integer anchorLine, boolean adjustPosition) {
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        HashMap<String, AnnotationsInformationView.AnnotationsGroupInfo> linkGroupsByMessage = new HashMap<String, AnnotationsInformationView.AnnotationsGroupInfo>();
        IAnnotationModel annotationModel = ((ISourceViewer)textViewer).getAnnotationModel();
        Iterator ai = annotationModel.getAnnotationIterator();
        while (ai.hasNext()) {
            Position annoPosition;
            Annotation anno = (Annotation)ai.next();
            if (!this.isSupportedAnnotation(anno) || (annoPosition = annotationModel.getPosition(anno)) == null || !annoPosition.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength())) continue;
            linkGroupsByMessage.computeIfAbsent(anno.getText(), AnnotationsInformationView.AnnotationsGroupInfo::new).add(anno, annoPosition);
        }
        if (linkGroupsByMessage.isEmpty()) {
            return null;
        }
        List<AnnotationsInformationView.AnnotationsGroupInfo> annotationsGroups = linkGroupsByMessage.values().stream().sorted(Comparator.comparing(g -> g.getFirstPosition().getOffset())).toList();
        if (anchorLine == null) {
            Position lastAnnotationPos = annotationsGroups.stream().max(Comparator.comparing(g -> g.getLastPosition().getOffset() + g.getLastPosition().getLength())).get().getLastPosition();
            int lastAnnotationOffset = lastAnnotationPos.getOffset() + lastAnnotationPos.getLength();
            try {
                anchorLine = this.editor.getDocument().getLineOfOffset(lastAnnotationOffset);
            }
            catch (BadLocationException e) {
                log.debug((Object)("Error obtaining anchor line of annotation offset " + String.valueOf(lastAnnotationPos)), (Throwable)e);
                try {
                    anchorLine = this.editor.getDocument().getLineOfOffset(hoverRegion.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    log.debug((Object)("Error obtaining anchor line of hover region offset " + hoverRegion.getOffset()), (Throwable)e);
                    anchorLine = -1;
                }
            }
        }
        return new AnnotationsInformationView.AnnotationsHoverInfo(annotationsGroups, (IRegion)(adjustPosition ? hoverRegion : null), anchorLine);
    }

    @Override
    @Nullable
    public IRegion getHoverRegion(@NotNull ITextViewer textViewer, int offset) {
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        Interval hoverInterval = new Interval(offset, offset);
        Interval resultInterval = null;
        IAnnotationModel annotationModel = ((ISourceViewer)textViewer).getAnnotationModel();
        if (annotationModel != null) {
            Iterator ai = annotationModel.getAnnotationIterator();
            while (ai.hasNext()) {
                Interval annoInterval;
                Position annoPosition;
                Annotation anno = (Annotation)ai.next();
                if (!this.isSupportedAnnotation(anno) || (annoPosition = annotationModel.getPosition(anno)) == null || !(annoInterval = new Interval(annoPosition.getOffset(), annoPosition.getOffset() + annoPosition.getLength())).properlyContains(hoverInterval)) continue;
                Interval interval = resultInterval = resultInterval == null ? annoInterval : resultInterval.union(annoInterval);
            }
        }
        return resultInterval == null ? null : new Region(resultInterval.a, resultInterval.length());
    }

    public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleNumberOfLines) {
        try {
            Integer anchorLine = lineRange.getNumberOfLines() == 1 ? Integer.valueOf(lineRange.getStartLine()) : null;
            IRegion lineRegion = sourceViewer.getDocument().getLineInformation(lineRange.getStartLine());
            return this.getAnnotationsHoverInfo((ITextViewer)sourceViewer, lineRegion, anchorLine, false);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return null;
        }
    }

    public ILineRange getHoverLineRange(ISourceViewer viewer, int lineNumber) {
        return new LineRange(lineNumber, 1);
    }

    public boolean canHandleMouseCursor() {
        return true;
    }

    @Override
    public void setEditor(IEditorPart editor) {
        this.editor = (SQLEditorBase)editor;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return shell -> new LinkListInformationControl(shell);
    }

    private boolean isSupportedAnnotation(Annotation anno) {
        return anno instanceof SpellingAnnotation || anno instanceof SQLProblemAnnotation || anno instanceof SQLSemanticErrorAnnotation;
    }

    private class LinkListInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2 {
        @NotNull
        private final AnnotationsInformationView infoView;

        public LinkListInformationControl(Shell parentShell) {
            super(parentShell, false);
            this.setBackgroundColor(new Color(255, 128, 128));
            this.infoView = new AnnotationsInformationView(this, SQLAnnotationHover.this.editor);
            this.create();
        }

        public void setInformation(String information) {
        }

        public void setInput(@NotNull Object input) {
            this.infoView.setLinksInformation((AnnotationsInformationView.AnnotationsHoverInfo)input);
        }

        protected void createContent(@NotNull Composite parent) {
            this.infoView.createControl(parent);
        }

        public boolean hasContents() {
            return true;
        }

        @NotNull
        public Point computeSizeHint() {
            Rectangle bounds = this.getBounds();
            return new Point(bounds.width, bounds.height);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.infoView.show();
            }
            super.setVisible(visible);
        }
    }
}

