/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.AESInStream;
import com.tigervnc.rdr.AESOutStream;
import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.AuthFailureException;
import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.CSecurity;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CSecurityRSAAES
extends CSecurity {
    private static final int MinKeyLength = 1024;
    private static final int MaxKeyLength = 8192;
    private int secType;
    private int subtype;
    private int keySize;
    private boolean isAllEncrypted;
    private PrivateKey clientKey;
    private PublicKey clientPublicKey;
    private PublicKey serverKey;
    private int serverKeyLength;
    private byte[] serverKeyN;
    private byte[] serverKeyE;
    private int clientKeyLength;
    private byte[] clientKeyN;
    private byte[] clientKeyE;
    private byte[] serverRandom;
    private byte[] clientRandom;
    private AESInStream rais;
    private AESOutStream raos;
    private InStream rawis;
    private OutStream rawos;

    private static final byte[] bigIntToBytes(BigInteger bigInteger, int n) {
        int n2 = bigInteger.bitCount();
        byte[] byArray = bigInteger.toByteArray();
        int n3 = byArray.length < n ? byArray.length : n;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, byArray.length - n3, byArray2, n - n3, n3);
        return byArray2;
    }

    public CSecurityRSAAES(int n, int n2, boolean bl) {
        this.secType = n;
        this.keySize = n2;
        this.isAllEncrypted = bl;
    }

    @Override
    public boolean processMsg(CConnection cConnection) {
        this.readPubclicKey(cConnection);
        this.verifyServer();
        this.writePublicKey(cConnection);
        this.writeRandom(cConnection);
        this.readRandom(cConnection);
        this.setCipher(cConnection);
        this.writeHash(cConnection);
        this.readHash();
        this.readSubtype();
        this.writeCredentials();
        return true;
    }

    private void readPubclicKey(CConnection cConnection) {
        InStream inStream = cConnection.getInStream();
        this.serverKeyLength = inStream.readU32();
        if (this.serverKeyLength < 1024) {
            throw new AuthFailureException("server key is too short");
        }
        if (this.serverKeyLength > 8192) {
            throw new AuthFailureException("server key is too long");
        }
        int n = (this.serverKeyLength + 7) / 8;
        this.serverKeyN = new byte[n];
        this.serverKeyE = new byte[n];
        inStream.readBytes(ByteBuffer.wrap(this.serverKeyN), n);
        inStream.readBytes(ByteBuffer.wrap(this.serverKeyE), n);
        BigInteger bigInteger = new BigInteger(1, this.serverKeyN);
        BigInteger bigInteger2 = new BigInteger(1, this.serverKeyE);
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.serverKey = keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthFailureException("RSA algorithm is not supported");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new AuthFailureException("server key is invalid");
        }
    }

    private void verifyServer() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthFailureException("SHA-1 algorithm is not supported");
        }
        byte[] byArray = new byte[]{(byte)((this.serverKeyLength & 0xFF000000) >> 24), (byte)((this.serverKeyLength & 0xFF0000) >> 16), (byte)((this.serverKeyLength & 0xFF00) >> 8), (byte)(this.serverKeyLength & 0xFF)};
        messageDigest.update(byArray);
        messageDigest.update(this.serverKeyN);
        messageDigest.update(this.serverKeyE);
        byte[] byArray2 = messageDigest.digest();
        String string = "Server key fingerprint";
        String string2 = String.format("The server has provided the following identifying information:\nFingerprint: %02x-%02x-%02x-%02x-%02x-%02x-%02x-%02x\nPlease verify that the information is correct and press \"Yes\". Otherwise press \"No\"", byArray2[0], byArray2[1], byArray2[2], byArray2[3], byArray2[4], byArray2[5], byArray2[6], byArray2[7]);
        if (!msg.showMsgBox(0, string, string2)) {
            throw new AuthFailureException("server key mismatch");
        }
    }

    private void writePublicKey(CConnection cConnection) {
        KeyPairGenerator keyPairGenerator;
        OutStream outStream = cConnection.getOutStream();
        this.clientKeyLength = this.serverKeyLength;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthFailureException("RSA algorithm is not supported");
        }
        keyPairGenerator.initialize(this.clientKeyLength);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.clientKey = keyPair.getPrivate();
        this.clientPublicKey = keyPair.getPublic();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)this.clientPublicKey;
        BigInteger bigInteger = rSAPublicKey.getModulus();
        BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
        this.clientKeyN = CSecurityRSAAES.bigIntToBytes(bigInteger, (this.clientKeyLength + 7) / 8);
        this.clientKeyE = CSecurityRSAAES.bigIntToBytes(bigInteger2, (this.clientKeyLength + 7) / 8);
        if (this.clientKeyN == null || this.clientKeyN == null) {
            throw new AuthFailureException("failed to generate RSA keys");
        }
        outStream.writeU32(this.clientKeyLength);
        outStream.writeBytes(this.clientKeyN, 0, this.clientKeyN.length);
        outStream.writeBytes(this.clientKeyE, 0, this.clientKeyE.length);
        outStream.flush();
    }

    private void writeRandom(CConnection cConnection) {
        byte[] byArray;
        OutStream outStream = cConnection.getOutStream();
        SecureRandom secureRandom = new SecureRandom();
        this.clientRandom = new byte[this.keySize / 8];
        secureRandom.nextBytes(this.clientRandom);
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, this.serverKey);
            byArray = cipher.doFinal(this.clientRandom);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new AuthFailureException("RSA algorithm is not supported");
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new AuthFailureException("failed to encrypt random");
        }
        outStream.writeU16(byArray.length);
        outStream.writeBytes(byArray, 0, byArray.length);
        outStream.flush();
    }

    private void readRandom(CConnection cConnection) {
        InStream inStream = cConnection.getInStream();
        int n = inStream.readU16();
        if (n != this.clientKeyN.length) {
            throw new AuthFailureException("client key length doesn't match");
        }
        byte[] byArray = new byte[n];
        inStream.readBytes(ByteBuffer.wrap(byArray), n);
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, this.clientKey);
            this.serverRandom = cipher.doFinal(byArray);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new AuthFailureException("RSA algorithm is not supported");
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            System.out.println(generalSecurityException.getMessage());
            throw new AuthFailureException("failed to decrypt server random");
        }
        if (this.serverRandom.length != this.keySize / 8) {
            throw new AuthFailureException("server random length doesn't match");
        }
    }

    private void setCipher(CConnection cConnection) {
        MessageDigest messageDigest;
        this.rawis = cConnection.getInStream();
        this.rawos = cConnection.getOutStream();
        try {
            messageDigest = MessageDigest.getInstance(this.keySize == 128 ? "SHA-1" : "SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthFailureException("hash algorithm is not supported");
        }
        messageDigest.update(this.clientRandom);
        messageDigest.update(this.serverRandom);
        byte[] byArray = Arrays.copyOfRange(messageDigest.digest(), 0, this.keySize / 8);
        this.rais = new AESInStream(this.rawis, byArray);
        messageDigest.reset();
        messageDigest.update(this.serverRandom);
        messageDigest.update(this.clientRandom);
        byArray = Arrays.copyOfRange(messageDigest.digest(), 0, this.keySize / 8);
        this.raos = new AESOutStream(this.rawos, byArray);
        if (this.isAllEncrypted) {
            cConnection.setStreams(this.rais, this.raos);
        }
    }

    private void writeHash(CConnection cConnection) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(this.keySize == 128 ? "SHA-1" : "SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthFailureException("hash algorithm is not supported");
        }
        int n = this.serverKeyLength;
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        n = this.clientKeyLength;
        byte[] byArray2 = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        messageDigest.update(byArray2);
        messageDigest.update(this.clientKeyN);
        messageDigest.update(this.clientKeyE);
        messageDigest.update(byArray);
        messageDigest.update(this.serverKeyN);
        messageDigest.update(this.serverKeyE);
        byte[] byArray3 = messageDigest.digest();
        this.raos.writeBytes(byArray3, 0, byArray3.length);
        this.raos.flush();
    }

    void readHash() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(this.keySize == 128 ? "SHA-1" : "SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthFailureException("hash algorithm is not supported");
        }
        int n = this.serverKeyLength;
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        n = this.clientKeyLength;
        byte[] byArray2 = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        messageDigest.update(byArray);
        messageDigest.update(this.serverKeyN);
        messageDigest.update(this.serverKeyE);
        messageDigest.update(byArray2);
        messageDigest.update(this.clientKeyN);
        messageDigest.update(this.clientKeyE);
        byte[] byArray3 = messageDigest.digest();
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray3.length);
        this.rais.readBytes(byteBuffer, byArray3.length);
        if (!Arrays.equals(byteBuffer.array(), byArray3)) {
            throw new AuthFailureException("hash doesn't match");
        }
    }

    private void readSubtype() {
        this.subtype = this.rais.readU8();
        if (this.subtype != 1 && this.subtype != 2) {
            throw new AuthFailureException("unknown RSA-AES subtype");
        }
    }

    private void writeCredentials() {
        byte[] byArray;
        byte[] byArray2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        CSecurity.upg.getUserPasswd(this.secType == 129, this.subtype == 1 ? stringBuffer : null, stringBuffer2);
        if (stringBuffer.length() > 255) {
            throw new AuthFailureException("username is too long");
        }
        try {
            byArray2 = stringBuffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthFailureException("UTF-8 is not supported");
        }
        this.raos.writeU8(byArray2.length);
        if (byArray2.length != 0) {
            this.raos.writeBytes(byArray2, 0, byArray2.length);
        }
        if (stringBuffer2.length() > 255) {
            throw new AuthFailureException("password is too long");
        }
        try {
            byArray = stringBuffer2.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthFailureException("UTF-8 is not supported");
        }
        this.raos.writeU8(byArray.length);
        if (byArray.length != 0) {
            this.raos.writeBytes(byArray, 0, byArray.length);
        }
        this.raos.flush();
    }

    @Override
    public int getType() {
        return this.secType;
    }

    @Override
    public String description() {
        return "RSA-ASE security types";
    }
}

