/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class HealthResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, HealthResponse> {
    @Nullable
    private final String message;
    @Nullable
    private final String mode;
    @Nonnull
    private final Map<String, JsonData> settings;
    @Nullable
    private final String status;
    public static final JsonpDeserializer<HealthResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HealthResponse::setupHealthResponseDeserializer);

    private HealthResponse(Builder builder) {
        this.message = builder.message;
        this.mode = builder.mode;
        this.settings = ApiTypeHelper.unmodifiable(builder.settings);
        this.status = builder.status;
    }

    public static HealthResponse of(Function<Builder, ObjectBuilder<HealthResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String message() {
        return this.message;
    }

    @Nullable
    public final String mode() {
        return this.mode;
    }

    @Nonnull
    public final Map<String, JsonData> settings() {
        return this.settings;
    }

    @Nullable
    public final String status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.message != null) {
            generator.writeKey("message");
            generator.write(this.message);
        }
        if (this.mode != null) {
            generator.writeKey("mode");
            generator.write(this.mode);
        }
        if (ApiTypeHelper.isDefined(this.settings)) {
            generator.writeKey("settings");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.settings.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.status != null) {
            generator.writeKey("status");
            generator.write(this.status);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupHealthResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::message, JsonpDeserializer.stringDeserializer(), "message");
        op.add(Builder::mode, JsonpDeserializer.stringDeserializer(), "mode");
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.message);
        result = 31 * result + Objects.hashCode(this.mode);
        result = 31 * result + Objects.hashCode(this.settings);
        result = 31 * result + Objects.hashCode(this.status);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthResponse other = (HealthResponse)o;
        return Objects.equals(this.message, other.message) && Objects.equals(this.mode, other.mode) && Objects.equals(this.settings, other.settings) && Objects.equals(this.status, other.status);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, HealthResponse> {
        @Nullable
        private String message;
        @Nullable
        private String mode;
        @Nullable
        private Map<String, JsonData> settings;
        @Nullable
        private String status;

        public Builder() {
        }

        private Builder(HealthResponse o) {
            this.message = o.message;
            this.mode = o.mode;
            this.settings = Builder._mapCopy(o.settings);
            this.status = o.status;
        }

        private Builder(Builder o) {
            this.message = o.message;
            this.mode = o.mode;
            this.settings = Builder._mapCopy(o.settings);
            this.status = o.status;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder message(@Nullable String value) {
            this.message = value;
            return this;
        }

        @Nonnull
        public final Builder mode(@Nullable String value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public final Builder settings(Map<String, JsonData> map) {
            this.settings = Builder._mapPutAll(this.settings, map);
            return this;
        }

        @Nonnull
        public final Builder settings(String key, JsonData value) {
            this.settings = Builder._mapPut(this.settings, key, value);
            return this;
        }

        @Nonnull
        public final Builder status(@Nullable String value) {
            this.status = value;
            return this;
        }

        @Override
        @Nonnull
        public HealthResponse build() {
            this._checkSingleUse();
            return new HealthResponse(this);
        }
    }
}

