/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Credential
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Credential> {
    @Nullable
    private final String accessKey;
    @Nonnull
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String secretKey;
    @Nullable
    private final String sessionToken;
    public static final JsonpDeserializer<Credential> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Credential::setupCredentialDeserializer);

    private Credential(Builder builder) {
        this.accessKey = builder.accessKey;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.secretKey = builder.secretKey;
        this.sessionToken = builder.sessionToken;
    }

    public static Credential of(Function<Builder, ObjectBuilder<Credential>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String accessKey() {
        return this.accessKey;
    }

    @Nonnull
    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final String secretKey() {
        return this.secretKey;
    }

    @Nullable
    public final String sessionToken() {
        return this.sessionToken;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        if (this.accessKey != null) {
            generator.writeKey("access_key");
            generator.write(this.accessKey);
        }
        if (this.secretKey != null) {
            generator.writeKey("secret_key");
            generator.write(this.secretKey);
        }
        if (this.sessionToken != null) {
            generator.writeKey("session_token");
            generator.write(this.sessionToken);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCredentialDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessKey, JsonpDeserializer.stringDeserializer(), "access_key");
        op.add(Builder::secretKey, JsonpDeserializer.stringDeserializer(), "secret_key");
        op.add(Builder::sessionToken, JsonpDeserializer.stringDeserializer(), "session_token");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).metadata == null) {
                ((Builder)builder).metadata = new HashMap();
            }
            ((Builder)builder).metadata.put(name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.accessKey);
        result = 31 * result + Objects.hashCode(this.metadata);
        result = 31 * result + Objects.hashCode(this.secretKey);
        result = 31 * result + Objects.hashCode(this.sessionToken);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credential other = (Credential)o;
        return Objects.equals(this.accessKey, other.accessKey) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.secretKey, other.secretKey) && Objects.equals(this.sessionToken, other.sessionToken);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Credential> {
        @Nullable
        private String accessKey;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String secretKey;
        @Nullable
        private String sessionToken;

        public Builder() {
        }

        private Builder(Credential o) {
            this.accessKey = o.accessKey;
            this.metadata = Builder._mapCopy(o.metadata);
            this.secretKey = o.secretKey;
            this.sessionToken = o.sessionToken;
        }

        private Builder(Builder o) {
            this.accessKey = o.accessKey;
            this.metadata = Builder._mapCopy(o.metadata);
            this.secretKey = o.secretKey;
            this.sessionToken = o.sessionToken;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder accessKey(@Nullable String value) {
            this.accessKey = value;
            return this;
        }

        @Nonnull
        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        @Nonnull
        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Nonnull
        public final Builder secretKey(@Nullable String value) {
            this.secretKey = value;
            return this;
        }

        @Nonnull
        public final Builder sessionToken(@Nullable String value) {
            this.sessionToken = value;
            return this;
        }

        @Override
        @Nonnull
        public Credential build() {
            this._checkSingleUse();
            return new Credential(this);
        }
    }
}

