function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import classNames from 'classnames';
import PropTypes from "prop-types";
import React, { Component } from 'react';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiBreadcrumbs } from '../breadcrumbs';
import { EuiButton, EuiButtonIcon } from '../button';
import { EuiI18n } from '../i18n';
import { EuiIcon } from '../icon';
import { EuiPortal } from '../portal';

/**
 * Extends EuiButton excluding `size`. Requires `label` as the `children`.
 */

/**
 * Creates a `button` visually styles as a tab.
 * Requires `label` as the `children`.
 * `onClick` must be provided to handle the content swapping.
 */

/**
 * Extends EuiBreadcrumbs
 */

/**
 * Simple div controlling color and size text output.
 * Requires `label` as the `children`.
 */

/**
 * Custom props specific to the icon control type
 */

/**
 * Icon can extend EuiIcon
 * Had to omit `onClick` as it's a valid prop of SVGElement
 * Also omits `type` and `id` as these are also specific to icon control
 */

/**
 * Icon can extend EuiButtonIcon
 * Also omits `iconType` and `id` as these are also specific to icon control
 */

export var EuiControlBar = /*#__PURE__*/function (_Component) {
  _inherits(EuiControlBar, _Component);
  var _super = _createSuper(EuiControlBar);
  function EuiControlBar() {
    var _this;
    _classCallCheck(this, EuiControlBar);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "bar", null);
    _defineProperty(_assertThisInitialized(_this), "state", {
      selectedTab: ''
    });
    return _this;
  }
  _createClass(EuiControlBar, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.position === 'fixed') {
        var height = this.bar ? this.bar.clientHeight : -1;
        document.body.style.paddingBottom = "".concat(height, "px");
        if (this.props.bodyClassName) {
          document.body.classList.add(this.props.bodyClassName);
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.body.style.paddingBottom = '';
      if (this.props.bodyClassName) {
        document.body.classList.remove(this.props.bodyClassName);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        showContent = _this$props.showContent,
        controls = _this$props.controls,
        size = _this$props.size,
        leftOffset = _this$props.leftOffset,
        rightOffset = _this$props.rightOffset,
        maxHeight = _this$props.maxHeight,
        showOnMobile = _this$props.showOnMobile,
        style = _this$props.style,
        position = _this$props.position,
        bodyClassName = _this$props.bodyClassName,
        landmarkHeading = _this$props.landmarkHeading,
        rest = _objectWithoutProperties(_this$props, ["children", "className", "showContent", "controls", "size", "leftOffset", "rightOffset", "maxHeight", "showOnMobile", "style", "position", "bodyClassName", "landmarkHeading"]);
      var styles = _objectSpread(_objectSpread({}, style), {}, {
        left: leftOffset,
        right: rightOffset,
        maxHeight: maxHeight
      });
      var classes = classNames('euiControlBar', className, {
        'euiControlBar-isOpen': showContent,
        'euiControlBar--large': size === 'l',
        'euiControlBar--medium': size === 'm',
        'euiControlBar--small': size === 's',
        'euiControlBar--fixed': position === 'fixed',
        'euiControlBar--absolute': position === 'absolute',
        'euiControlBar--relative': position === 'relative',
        'euiControlBar--showOnMobile': showOnMobile
      });
      var handleTabClick = function handleTabClick(control, e) {
        _this2.setState({
          selectedTab: control.id
        }, function () {
          control.onClick(e);
        });
      };
      var controlItem = function controlItem(control, index) {
        switch (control.controlType) {
          case 'button':
            {
              var controlType = control.controlType,
                id = control.id,
                _control$color = control.color,
                color = _control$color === void 0 ? 'ghost' : _control$color,
                label = control.label,
                _className = control.className,
                _rest = _objectWithoutProperties(control, ["controlType", "id", "color", "label", "className"]);
              return /*#__PURE__*/React.createElement(EuiButton, _extends({
                key: id + index,
                className: classNames('euiControlBar__button', _className),
                color: color
              }, _rest, {
                size: "s"
              }), label);
            }
          case 'icon':
            {
              var _controlType = control.controlType,
                _id = control.id,
                iconType = control.iconType,
                _className2 = control.className,
                _control$color2 = control.color,
                _color = _control$color2 === void 0 ? 'ghost' : _control$color2,
                onClick = control.onClick,
                href = control.href,
                _rest2 = _objectWithoutProperties(control, ["controlType", "id", "iconType", "className", "color", "onClick", "href"]);
              return onClick || href ? /*#__PURE__*/React.createElement(EuiButtonIcon, _extends({
                key: _id + index,
                className: classNames('euiControlBar__buttonIcon', _className2),
                onClick: onClick,
                href: href,
                color: _color
              }, _rest2, {
                iconType: iconType
              })) : /*#__PURE__*/React.createElement(EuiIcon, _extends({
                key: _id + index,
                className: classNames('euiControlBar__icon', _className2),
                type: iconType,
                color: _color
              }, _rest2));
            }
          case 'divider':
            return /*#__PURE__*/React.createElement("div", {
              key: control.controlType + index,
              className: "euiControlBar__divider"
            });
          case 'spacer':
            return /*#__PURE__*/React.createElement("div", {
              key: control.controlType + index,
              className: "euiControlBar__spacer"
            });
          case 'text':
            {
              var _controlType2 = control.controlType,
                _id2 = control.id,
                text = control.text,
                _className3 = control.className,
                _rest3 = _objectWithoutProperties(control, ["controlType", "id", "text", "className"]);
              return /*#__PURE__*/React.createElement("div", _extends({
                key: _id2,
                className: classNames('euiControlBar__text', _className3)
              }, _rest3), text);
            }
          case 'tab':
            {
              var _controlType3 = control.controlType,
                _id3 = control.id,
                _label = control.label,
                _onClick = control.onClick,
                _className4 = control.className,
                _rest4 = _objectWithoutProperties(control, ["controlType", "id", "label", "onClick", "className"]);
              var tabClasses = classNames('euiControlBar__tab', {
                'euiControlBar__tab--active': showContent && _id3 === _this2.state.selectedTab
              }, _className4);
              return /*#__PURE__*/React.createElement("button", _extends({
                key: _id3 + index,
                className: tabClasses,
                onClick: function onClick(event) {
                  return handleTabClick(control, event);
                }
              }, _rest4), _label);
            }
          case 'breadcrumbs':
            {
              var _controlType4 = control.controlType,
                _id4 = control.id,
                _rest5 = _objectWithoutProperties(control, ["controlType", "id"]);
              return /*#__PURE__*/React.createElement(EuiBreadcrumbs, _extends({
                className: "euiControlBar__breadcrumbs",
                key: control.id
              }, _rest5));
            }
        }
      };
      var controlBar = /*#__PURE__*/React.createElement(EuiI18n, {
        token: "euiControlBar.screenReaderHeading",
        default: "Page level controls"
      }, function (screenReaderHeading) {
        return (
          /*#__PURE__*/
          // Though it would be better to use aria-labelledby than aria-label and not repeat the same string twice
          // A bug in voiceover won't list some landmarks in the rotor without an aria-label
          React.createElement("section", _extends({
            className: classes,
            "aria-label": landmarkHeading ? landmarkHeading : screenReaderHeading
          }, rest, {
            style: styles
          }), /*#__PURE__*/React.createElement(EuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("h2", null, landmarkHeading ? landmarkHeading : screenReaderHeading)), /*#__PURE__*/React.createElement("div", {
            className: "euiControlBar__controls",
            ref: function ref(node) {
              _this2.bar = node;
            }
          }, controls.map(function (control, index) {
            return controlItem(control, index);
          })), _this2.props.showContent ? /*#__PURE__*/React.createElement("div", {
            className: "euiControlBar__content"
          }, children) : null)
        );
      });
      return position === 'fixed' ? /*#__PURE__*/React.createElement(EuiPortal, null, controlBar, /*#__PURE__*/React.createElement(EuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("p", {
        "aria-live": "assertive"
      }, landmarkHeading ? /*#__PURE__*/React.createElement(EuiI18n, {
        token: "euiControlBar.customScreenReaderAnnouncement",
        default: "There is a new region landmark called {landmarkHeading} with page level controls at the end of the document.",
        values: {
          landmarkHeading: landmarkHeading
        }
      }) : /*#__PURE__*/React.createElement(EuiI18n, {
        token: "euiControlBar.screenReaderAnnouncement",
        default: "There is a new region landmark with page level controls at the end of the document."
      })))) : controlBar;
    }
  }]);
  return EuiControlBar;
}(Component);
_defineProperty(EuiControlBar, "defaultProps", {
  leftOffset: 0,
  rightOffset: 0,
  position: 'fixed',
  size: 'l',
  showContent: false,
  showOnMobile: false
});
EuiControlBar.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  /**
       * Show or hide the content area containing the `children`
       */
  showContent: PropTypes.bool,
  /**
       * An array of controls, actions, and layout spacers to display.
       * Accepts `'button' | 'tab' | 'breadcrumbs' | 'text' | 'icon' | 'spacer' | 'divider'`
       */
  controls: PropTypes.arrayOf(PropTypes.shape({
    href: PropTypes.string,
    onClick: PropTypes.func,
    id: PropTypes.string,
    label: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.node]),
    buttonRef: PropTypes.any,
    controlType: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.oneOf(["button"]).isRequired, PropTypes.oneOfType([PropTypes.oneOf(["breadcrumbs"]).isRequired, PropTypes.oneOf(["tab"]).isRequired]).isRequired]).isRequired, PropTypes.oneOf(["text"]).isRequired]).isRequired, PropTypes.oneOf(["icon"]).isRequired]).isRequired, PropTypes.oneOf(["divider"]).isRequired]).isRequired, PropTypes.oneOf(["spacer"]).isRequired]).isRequired,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    /**
       * Hides extra (above the max) breadcrumbs under a collapsed item as the window gets smaller.
       * Pass a custom #EuiBreadcrumbResponsiveMaxCount object to change the number of breadcrumbs to show at the particular breakpoints.
       * Omitting or passing a `0` value will show all breadcrumbs.
       *
       * Pass `false` to turn this behavior off.
       *
       * Default: `{ xs: 1, s: 2, m: 4 }`
       */
    responsive: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.any.isRequired]),
    /**
       * Forces all breadcrumbs to single line and
       * truncates each breadcrumb to a particular width,
       * except for the last item
       */
    truncate: PropTypes.bool,
    /**
       * Collapses the inner items past the maximum set here
       * into a single ellipses item
       */
    max: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.oneOf([null])]),
    /**
       * The array of individual #EuiBreadcrumb items
       */
    breadcrumbs: PropTypes.arrayOf(PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      /**
         * Visible label of the breadcrumb
         */
      text: PropTypes.node.isRequired,
      href: PropTypes.string,
      onClick: PropTypes.func,
      /**
         * Force a max-width on the breadcrumb text
         */
      truncate: PropTypes.bool
    }).isRequired),
    text: PropTypes.node,
    iconType: PropTypes.string
  }).isRequired).isRequired,
  /**
       * The default height of the content area.
       */
  size: PropTypes.oneOf(["s", "m", "l"]),
  /**
       * Customize the max height.
       * Best when used with `size=l` as this will ensure the actual height equals the max height set.
       */
  maxHeight: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
       * Set the offset from the left side of the screen.
       */
  leftOffset: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
       * Set the offset from the left side of the screen.
       */
  rightOffset: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
       * The control bar is hidden on mobile by default. Use the `showOnMobile` prop to force it's display on mobile screens.
       * You'll need to ensure that the content you place into the bar renders as expected on mobile.
       */
  showOnMobile: PropTypes.bool,
  /**
       * By default EuiControlBar will live in a portal, fixed position to the browser window.
       * Change the position of the bar to live inside a container and be positioned against its parent.
       */
  position: PropTypes.oneOf(["fixed", "relative", "absolute"]),
  /**
       * Optional class applied to the body used when `position = fixed`
       */
  bodyClassName: PropTypes.string,
  /**
       * Customize the screen reader heading that helps users find this control. Default is "Page level controls".
       */
  landmarkHeading: PropTypes.string
};