
#ifndef KSERVICE_EXPORT_H
#define KSERVICE_EXPORT_H

#ifdef KSERVICE_STATIC_DEFINE
#  define KSERVICE_EXPORT
#  define KSERVICE_NO_EXPORT
#else
#  ifndef KSERVICE_EXPORT
#    ifdef KF5Service_EXPORTS
        /* We are building this library */
#      define KSERVICE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KSERVICE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KSERVICE_NO_EXPORT
#    define KSERVICE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KSERVICE_DECL_DEPRECATED
#  define KSERVICE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KSERVICE_DECL_DEPRECATED_EXPORT
#  define KSERVICE_DECL_DEPRECATED_EXPORT KSERVICE_EXPORT KSERVICE_DECL_DEPRECATED
#endif

#ifndef KSERVICE_DECL_DEPRECATED_NO_EXPORT
#  define KSERVICE_DECL_DEPRECATED_NO_EXPORT KSERVICE_NO_EXPORT KSERVICE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KSERVICE_NO_DEPRECATED
#    define KSERVICE_NO_DEPRECATED
#  endif
#endif

#define KSERVICE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KSERVICE_NO_DEPRECATED) && !defined(KSERVICE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KSERVICE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KSERVICE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KSERVICE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KSERVICE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KSERVICE_NO_DEPRECATED_WARNINGS) && !defined(KSERVICE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KSERVICE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KSERVICE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KSERVICE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KSERVICE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KSERVICE_NO_DEPRECATED)
#  undef KSERVICE_DEPRECATED
#  define KSERVICE_DEPRECATED_EXPORT KSERVICE_EXPORT
#  define KSERVICE_DEPRECATED_NO_EXPORT KSERVICE_NO_EXPORT
#elif defined(KSERVICE_NO_DEPRECATED_WARNINGS)
#  define KSERVICE_DEPRECATED
#  define KSERVICE_DEPRECATED_EXPORT KSERVICE_EXPORT
#  define KSERVICE_DEPRECATED_NO_EXPORT KSERVICE_NO_EXPORT
#else
#  define KSERVICE_DEPRECATED KSERVICE_DECL_DEPRECATED
#  define KSERVICE_DEPRECATED_EXPORT KSERVICE_DECL_DEPRECATED_EXPORT
#  define KSERVICE_DEPRECATED_NO_EXPORT KSERVICE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KSERVICE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KSERVICE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KSERVICE_NO_DEPRECATED
#  define KSERVICE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x57400
#endif
#ifdef KSERVICE_NO_DEPRECATED_WARNINGS
#  define KSERVICE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KSERVICE_DEPRECATED_WARNINGS_SINCE
#  ifdef KSERVICE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KSERVICE_DEPRECATED_WARNINGS_SINCE KSERVICE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KSERVICE_DEPRECATED_WARNINGS_SINCE 0x57400
#  endif
#endif

#ifndef KSERVICE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KSERVICE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KSERVICE_DEPRECATED
#  define KSERVICE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KSERVICE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KSERVICE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KSERVICE_DEPRECATED_VERSION_5_0(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_0(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x50f00
#  define KSERVICE_DEPRECATED_VERSION_5_15(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_15(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x53d00
#  define KSERVICE_DEPRECATED_VERSION_5_61(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_61(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x53f00
#  define KSERVICE_DEPRECATED_VERSION_5_63(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_63(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x54200
#  define KSERVICE_DEPRECATED_VERSION_5_66(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_66(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x54300
#  define KSERVICE_DEPRECATED_VERSION_5_67(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_67(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x54600
#  define KSERVICE_DEPRECATED_VERSION_5_70(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_70(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x54700
#  define KSERVICE_DEPRECATED_VERSION_5_71(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_71(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x54f00
#  define KSERVICE_DEPRECATED_VERSION_5_79(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_79(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x55000
#  define KSERVICE_DEPRECATED_VERSION_5_80(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_80(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x55100
#  define KSERVICE_DEPRECATED_VERSION_5_81(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_81(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x55200
#  define KSERVICE_DEPRECATED_VERSION_5_82(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_82(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x55300
#  define KSERVICE_DEPRECATED_VERSION_5_83(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_83(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x55600
#  define KSERVICE_DEPRECATED_VERSION_5_86(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_86(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x55700
#  define KSERVICE_DEPRECATED_VERSION_5_87(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_87(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x55800
#  define KSERVICE_DEPRECATED_VERSION_5_88(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_88(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x55900
#  define KSERVICE_DEPRECATED_VERSION_5_89(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_89(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x55a00
#  define KSERVICE_DEPRECATED_VERSION_5_90(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_90(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x56600
#  define KSERVICE_DEPRECATED_VERSION_5_102(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_102(text)
#endif

#if KSERVICE_DEPRECATED_WARNINGS_SINCE >= 0x56800
#  define KSERVICE_DEPRECATED_VERSION_5_104(text) KSERVICE_DECL_DEPRECATED_TEXT(text)
#else
#  define KSERVICE_DEPRECATED_VERSION_5_104(text)
#endif
#define KSERVICE_DEPRECATED_VERSION_5(minor, text)      KSERVICE_DEPRECATED_VERSION_5_##minor(text)
#define KSERVICE_DEPRECATED_VERSION(major, minor, text) KSERVICE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KSERVICE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KSERVICE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KSERVICE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KSERVICE_DEPRECATED_VERSION(major, minor, text)
#  define KSERVICE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KSERVICE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KSERVICE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KSERVICE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KSERVICE_EXPORT_H */
