/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.named.ResultMemento;
import org.hibernate.query.results.ResultSetMapping;

public class NamedResultSetMappingMementoImpl
implements NamedResultSetMappingMemento {
    private final String name;
    private final List<ResultMemento> resultMementos;

    public NamedResultSetMappingMementoImpl(String name, List<ResultMemento> resultMementos) {
        this.name = name;
        this.resultMementos = resultMementos;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<ResultMemento> getResultMementos() {
        return Collections.unmodifiableList(this.resultMementos);
    }

    @Override
    public void resolve(ResultSetMapping resultSetMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        this.resultMementos.forEach(memento -> resultSetMapping.addResultBuilder(memento.resolve(querySpaceConsumer, context)));
    }
}

