/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.SignatureBuilder;
import io.quarkus.gizmo.Type;
import java.util.ArrayList;
import java.util.List;

class ClassSignatureBuilderImpl
implements SignatureBuilder.ClassSignatureBuilder {
    List<Type.TypeVariable> typeParameters = new ArrayList<Type.TypeVariable>();
    Type superClass = Type.ClassType.OBJECT;
    List<Type> superInterfaces = new ArrayList<Type>();

    ClassSignatureBuilderImpl() {
    }

    @Override
    public String build() {
        StringBuilder signature = new StringBuilder();
        if (!this.typeParameters.isEmpty()) {
            signature.append('<');
            for (Type.TypeVariable typeParameter : this.typeParameters) {
                typeParameter.appendTypeParameterToSignature(signature);
            }
            signature.append('>');
        }
        this.superClass.appendToSignature(signature);
        if (!this.superInterfaces.isEmpty()) {
            for (Type superInterface : this.superInterfaces) {
                superInterface.appendToSignature(signature);
            }
        }
        return signature.toString();
    }

    @Override
    public SignatureBuilder.ClassSignatureBuilder addTypeParameter(Type.TypeVariable typeParameter) {
        this.typeParameters.add(typeParameter);
        return this;
    }

    @Override
    public SignatureBuilder.ClassSignatureBuilder setSuperClass(Type.ClassType superClass) {
        this.superClass = superClass;
        return this;
    }

    @Override
    public SignatureBuilder.ClassSignatureBuilder setSuperClass(Type.ParameterizedType superClass) {
        if (this.containsWildcard(superClass)) {
            throw new IllegalArgumentException("An extended class type may not specify a wildcard");
        }
        this.superClass = superClass;
        return this;
    }

    @Override
    public SignatureBuilder.ClassSignatureBuilder addInterface(Type.ClassType interfaceType) {
        this.superInterfaces.add(interfaceType);
        return this;
    }

    @Override
    public SignatureBuilder.ClassSignatureBuilder addInterface(Type.ParameterizedType interfaceType) {
        if (this.containsWildcard(interfaceType)) {
            throw new IllegalArgumentException("An implemented interface type may not specify a wildcard");
        }
        this.superInterfaces.add(interfaceType);
        return this;
    }

    private boolean containsWildcard(Type type) {
        if (type.isWildcard()) {
            return true;
        }
        if (type.isParameterizedType()) {
            for (Type typeArgument : type.asParameterizedType().getTypeArguments()) {
                if (!this.containsWildcard(typeArgument)) continue;
                return true;
            }
        }
        return false;
    }
}

