/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SelfRenderingWindowFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmWindowFunction;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class SelfRenderingSqmWindowFunction<T>
extends SelfRenderingSqmFunction<T>
implements SqmWindowFunction<T> {
    private final SqmPredicate filter;
    private final Boolean respectNulls;
    private final Boolean fromFirst;

    public SelfRenderingSqmWindowFunction(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, Boolean respectNulls, Boolean fromFirst, ReturnableType<T> impliedResultType, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
        this.filter = filter;
        this.respectNulls = respectNulls;
        this.fromFirst = fromFirst;
    }

    @Override
    public SelfRenderingSqmWindowFunction<T> copy(SqmCopyContext context) {
        SelfRenderingSqmWindowFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
        for (SqmTypedNode<?> argument : this.getArguments()) {
            arguments.add(argument.copy(context));
        }
        SelfRenderingSqmWindowFunction expression = context.registerCopy(this, new SelfRenderingSqmWindowFunction(this.getFunctionDescriptor(), this.getFunctionRenderer(), arguments, this.filter == null ? null : this.filter.copy(context), this.respectNulls, this.fromFirst, this.getImpliedResultType(), this.getArgumentsValidator(), this.getReturnTypeResolver(), this.nodeBuilder(), this.getFunctionName()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
        ReturnableType<?> resultType = this.resolveResultType(walker);
        List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
        ArgumentsValidator argumentsValidator = this.getArgumentsValidator();
        if (argumentsValidator != null) {
            argumentsValidator.validateSqlTypes(arguments, this.getFunctionName());
        }
        return new SelfRenderingWindowFunctionSqlAstExpression(this.getFunctionName(), this.getFunctionRenderer(), arguments, this.filter == null ? null : walker.visitNestedTopLevelPredicate(this.filter), this.respectNulls, this.fromFirst, resultType, this.getMappingModelExpressible(walker, resultType, arguments));
    }

    @Override
    public SqmPredicate getFilter() {
        return this.filter;
    }

    @Override
    public Boolean getRespectNulls() {
        return this.respectNulls;
    }

    @Override
    public Boolean getFromFirst() {
        return this.fromFirst;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        List<SqmTypedNode<?>> arguments = this.getArguments();
        hql.append(this.getFunctionName());
        hql.append('(');
        int i = 1;
        if (!arguments.isEmpty() && arguments.get(0) instanceof SqmDistinct) {
            arguments.get(0).appendHqlString(hql, context);
            if (arguments.size() > 1) {
                hql.append(' ');
                arguments.get(1).appendHqlString(hql, context);
                i = 2;
            }
        }
        while (i < arguments.size()) {
            hql.append(", ");
            arguments.get(i).appendHqlString(hql, context);
            ++i;
        }
        hql.append(')');
        if (this.fromFirst != null) {
            if (this.fromFirst.booleanValue()) {
                hql.append(" from first");
            } else {
                hql.append(" from last");
            }
        }
        if (this.respectNulls != null) {
            if (this.respectNulls.booleanValue()) {
                hql.append(" respect nulls");
            } else {
                hql.append(" ignore nulls");
            }
        }
        if (this.filter != null) {
            hql.append(" filter (where ");
            this.filter.appendHqlString(hql, context);
            hql.append(')');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelfRenderingSqmWindowFunction that = (SelfRenderingSqmWindowFunction)o;
        return Objects.equals(this.filter, that.filter) && Objects.equals(this.respectNulls, that.respectNulls) && Objects.equals(this.fromFirst, that.fromFirst);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + Objects.hashCode(this.respectNulls);
        result = 31 * result + Objects.hashCode(this.fromFirst);
        return result;
    }
}

