/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.query;

import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.EntityResult;
import jakarta.persistence.FieldResult;
import jakarta.persistence.LockModeType;
import jakarta.persistence.SqlResultSetMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.boot.query.BootQueryLogging;
import org.hibernate.boot.query.FetchDescriptor;
import org.hibernate.boot.query.NamedResultSetMappingDescriptor;
import org.hibernate.boot.query.ResultDescriptor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.internal.FetchMementoBasicStandard;
import org.hibernate.query.internal.FetchMementoEntityStandard;
import org.hibernate.query.internal.ModelPartResultMementoBasicImpl;
import org.hibernate.query.internal.NamedResultSetMappingMementoImpl;
import org.hibernate.query.internal.ResultMementoBasicStandard;
import org.hibernate.query.internal.ResultMementoEntityJpa;
import org.hibernate.query.internal.ResultMementoInstantiationStandard;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.FetchMemento;
import org.hibernate.query.named.FetchMementoBasic;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.named.ResultMemento;
import org.hibernate.query.named.ResultMementoInstantiation;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.type.descriptor.java.JavaType;

public class SqlResultSetMappingDescriptor
implements NamedResultSetMappingDescriptor {
    private final String mappingName;
    private final List<ResultDescriptor> resultDescriptors;

    public static SqlResultSetMappingDescriptor from(SqlResultSetMapping mappingAnnotation, String name) {
        EntityResult[] entityResults = mappingAnnotation.entities();
        ConstructorResult[] constructorResults = mappingAnnotation.classes();
        ColumnResult[] columnResults = mappingAnnotation.columns();
        ArrayList<ResultDescriptor> resultDescriptors = CollectionHelper.arrayList(entityResults.length + columnResults.length + columnResults.length);
        for (EntityResult entityResult : entityResults) {
            resultDescriptors.add(new EntityResultDescriptor(entityResult));
        }
        for (EntityResult entityResult : constructorResults) {
            resultDescriptors.add(new ConstructorResultDescriptor((ConstructorResult)entityResult, mappingAnnotation));
        }
        for (EntityResult entityResult : columnResults) {
            resultDescriptors.add(new JpaColumnResultDescriptor((ColumnResult)entityResult, mappingAnnotation));
        }
        return new SqlResultSetMappingDescriptor(name, resultDescriptors);
    }

    public static SqlResultSetMappingDescriptor from(SqlResultSetMapping mappingAnnotation) {
        return SqlResultSetMappingDescriptor.from(mappingAnnotation, mappingAnnotation.name());
    }

    private SqlResultSetMappingDescriptor(String mappingName, List<ResultDescriptor> resultDescriptors) {
        this.mappingName = mappingName;
        this.resultDescriptors = resultDescriptors;
    }

    @Override
    public String getRegistrationName() {
        return this.mappingName;
    }

    @Override
    public NamedResultSetMappingMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
        ArrayList<ResultMemento> resultMementos = CollectionHelper.arrayList(this.resultDescriptors.size());
        this.resultDescriptors.forEach(resultDescriptor -> resultMementos.add(resultDescriptor.resolve(resolutionContext)));
        return new NamedResultSetMappingMementoImpl(this.mappingName, resultMementos);
    }

    public static class EntityResultDescriptor
    implements ResultDescriptor {
        private final NavigablePath navigablePath;
        private final String entityName;
        private final String discriminatorColumn;
        private final LockModeType lockMode;
        private final Map<String, AttributeFetchDescriptor> explicitFetchMappings;

        public EntityResultDescriptor(EntityResult entityResult) {
            this.entityName = entityResult.entityClass().getName();
            this.navigablePath = new NavigablePath(this.entityName);
            this.discriminatorColumn = entityResult.discriminatorColumn();
            this.lockMode = entityResult.lockMode();
            this.explicitFetchMappings = EntityResultDescriptor.extractFetchMappings(this.navigablePath, entityResult);
        }

        private static Map<String, AttributeFetchDescriptor> extractFetchMappings(NavigablePath navigablePath, EntityResult entityResult) {
            FieldResult[] fields = entityResult.fields();
            HashMap<String, AttributeFetchDescriptor> explicitFetchMappings = CollectionHelper.mapOfSize(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                FieldResult fieldResult = fields[i];
                String fieldName = fieldResult.name();
                AttributeFetchDescriptor existing = (AttributeFetchDescriptor)explicitFetchMappings.get(fieldName);
                if (existing != null) {
                    existing.addColumn(fieldResult);
                    continue;
                }
                explicitFetchMappings.put(fieldName, AttributeFetchDescriptor.from(navigablePath, navigablePath.getFullPath(), fieldResult));
            }
            return explicitFetchMappings;
        }

        @Override
        public ResultMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
            EntityPersister entityDescriptor = resolutionContext.getMappingMetamodel().getEntityDescriptor(this.entityName);
            FetchMementoBasic discriminatorMemento = EntityResultDescriptor.resolveDiscriminatorMemento(entityDescriptor, this.discriminatorColumn, this.navigablePath);
            HashMap<String, FetchMemento> fetchMementos = new HashMap<String, FetchMemento>();
            this.explicitFetchMappings.forEach((relativePath, fetchDescriptor) -> fetchMementos.put((String)relativePath, fetchDescriptor.resolve(resolutionContext)));
            return new ResultMementoEntityJpa(entityDescriptor, this.lockMode == LockModeType.OPTIMISTIC ? LockMode.NONE : LockMode.fromJpaLockMode(this.lockMode), discriminatorMemento, fetchMementos);
        }

        private static FetchMementoBasic resolveDiscriminatorMemento(EntityMappingType entityMapping, String discriminatorColumn, NavigablePath entityPath) {
            EntityDiscriminatorMapping discriminatorMapping = entityMapping.getDiscriminatorMapping();
            if (discriminatorMapping == null || discriminatorColumn == null || !entityMapping.hasSubclasses()) {
                return null;
            }
            return new FetchMementoBasicStandard(entityPath.append("{discriminator}"), discriminatorMapping, discriminatorColumn);
        }
    }

    private static class ConstructorResultDescriptor
    implements ResultDescriptor {
        private final String mappingName;
        private final Class<?> targetJavaType;
        private final List<ArgumentDescriptor> argumentResultDescriptors;

        public ConstructorResultDescriptor(ConstructorResult constructorResult, SqlResultSetMapping mappingAnnotation) {
            this.mappingName = mappingAnnotation.name();
            this.targetJavaType = constructorResult.targetClass();
            this.argumentResultDescriptors = ConstructorResultDescriptor.interpretArguments(constructorResult, mappingAnnotation);
        }

        private static List<ArgumentDescriptor> interpretArguments(ConstructorResult constructorResult, SqlResultSetMapping mappingAnnotation) {
            Object[] columnResults = constructorResult.columns();
            if (ArrayHelper.isEmpty(columnResults)) {
                throw new IllegalArgumentException("ConstructorResult did not define any ColumnResults");
            }
            ArrayList<ArgumentDescriptor> argumentResultDescriptors = CollectionHelper.arrayList(columnResults.length);
            for (Object columnResult : columnResults) {
                JpaColumnResultDescriptor argumentResultDescriptor = new JpaColumnResultDescriptor((ColumnResult)columnResult, mappingAnnotation);
                argumentResultDescriptors.add(new ArgumentDescriptor(argumentResultDescriptor));
            }
            return argumentResultDescriptors;
        }

        @Override
        public ResultMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
            BootQueryLogging.BOOT_QUERY_LOGGER.tracef("Generating InstantiationResultMappingMemento for JPA ConstructorResult(%s) for ResultSet mapping `%s`", (Object)this.targetJavaType.getName(), (Object)this.mappingName);
            ArrayList<ResultMementoInstantiation.ArgumentMemento> argumentResultMementos = new ArrayList<ResultMementoInstantiation.ArgumentMemento>(this.argumentResultDescriptors.size());
            this.argumentResultDescriptors.forEach(mapping -> argumentResultMementos.add(mapping.resolve(resolutionContext)));
            JavaType targetJtd = resolutionContext.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(this.targetJavaType);
            return new ResultMementoInstantiationStandard(targetJtd, argumentResultMementos);
        }

        private static class ArgumentDescriptor {
            private final JpaColumnResultDescriptor argumentResultDescriptor;

            private ArgumentDescriptor(JpaColumnResultDescriptor argumentResultDescriptor) {
                this.argumentResultDescriptor = argumentResultDescriptor;
            }

            ResultMementoInstantiation.ArgumentMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
                return new ResultMementoInstantiation.ArgumentMemento(this.argumentResultDescriptor.resolve(resolutionContext));
            }
        }
    }

    private static class JpaColumnResultDescriptor
    implements ResultDescriptor {
        private final ColumnResult columnResult;
        private final String mappingName;

        public JpaColumnResultDescriptor(ColumnResult columnResult, SqlResultSetMapping mappingAnnotation) {
            this.columnResult = columnResult;
            this.mappingName = mappingAnnotation.name();
        }

        @Override
        public ResultMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
            BootQueryLogging.BOOT_QUERY_LOGGER.tracef("Generating ScalarResultMappingMemento for JPA ColumnResult(%s) for ResultSet mapping `%s`", (Object)this.columnResult.name(), (Object)this.mappingName);
            return new ResultMementoBasicStandard(this.columnResult, resolutionContext);
        }
    }

    private static class AttributeFetchDescriptor
    implements FetchDescriptor {
        private final NavigablePath navigablePath;
        private final String entityName;
        private final String propertyPath;
        private final String[] propertyPathParts;
        private final List<String> columnNames;

        private static AttributeFetchDescriptor from(NavigablePath entityPath, String entityName, FieldResult fieldResult) {
            return new AttributeFetchDescriptor(entityPath, entityName, fieldResult.name(), fieldResult.column());
        }

        private AttributeFetchDescriptor(NavigablePath entityPath, String entityName, String propertyPath, String columnName) {
            this.entityName = entityName;
            this.propertyPath = propertyPath;
            this.propertyPathParts = StringHelper.split(".", propertyPath);
            this.navigablePath = entityPath;
            this.columnNames = new ArrayList<String>();
            this.columnNames.add(columnName);
        }

        private void addColumn(FieldResult fieldResult) {
            if (!this.propertyPath.equals(fieldResult.name())) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed FieldResult [%s, %s] does not match AttributeFetchMapping [%s]", fieldResult.name(), fieldResult.column(), this.propertyPath));
            }
            this.columnNames.add(fieldResult.column());
        }

        @Override
        public ResultMemento asResultMemento(NavigablePath path, ResultSetMappingResolutionContext resolutionContext) {
            BasicValuedModelPart basicPart;
            EntityPersister entityMapping = resolutionContext.getMappingMetamodel().getEntityDescriptor(this.entityName);
            ModelPart subPart = entityMapping.findSubPart(this.propertyPath, null);
            BasicValuedModelPart basicValuedModelPart = basicPart = subPart != null ? subPart.asBasicValuedModelPart() : null;
            if (basicPart != null) {
                assert (this.columnNames.size() == 1);
                return new ModelPartResultMementoBasicImpl(path, basicPart, this.columnNames.get(0));
            }
            throw new UnsupportedOperationException("Only support for basic-valued model-parts have been implemented : " + this.propertyPath + " [" + String.valueOf(subPart) + "]");
        }

        @Override
        public FetchMemento resolve(ResultSetMappingResolutionContext resolutionContext) {
            EntityPersister entityMapping = resolutionContext.getMappingMetamodel().getEntityDescriptor(this.entityName);
            ModelPart subPart = entityMapping.findSubPart(this.propertyPathParts[0], null);
            NavigablePath parentNavigablePath = !subPart.getNavigableRole().getParent().equals(entityMapping.getNavigableRole()) && subPart.getNavigableRole().getParent().getLocalName().equals("{id}") ? new EntityIdentifierNavigablePath(this.navigablePath, null) : this.navigablePath;
            NavigablePath navigablePath = subPart.isEntityIdentifierMapping() ? new EntityIdentifierNavigablePath(parentNavigablePath, this.propertyPathParts[0]) : parentNavigablePath.append(this.propertyPathParts[0]);
            for (int i = 1; i < this.propertyPathParts.length; ++i) {
                if (!(subPart instanceof ModelPartContainer)) {
                    throw new MappingException(String.format(Locale.ROOT, "Non-terminal property path did not reference FetchableContainer - %s ", navigablePath));
                }
                navigablePath = navigablePath.append(this.propertyPathParts[i]);
                subPart = ((ModelPartContainer)subPart).findSubPart(this.propertyPathParts[i], null);
            }
            return this.getFetchMemento(navigablePath, subPart);
        }

        private FetchMemento getFetchMemento(NavigablePath navigablePath, ModelPart subPart) {
            BasicValuedModelPart basicPart = subPart.asBasicValuedModelPart();
            if (basicPart != null) {
                assert (this.columnNames.size() == 1);
                return new FetchMementoBasicStandard(navigablePath, basicPart, this.columnNames.get(0));
            }
            if (subPart instanceof EntityValuedFetchable) {
                EntityValuedFetchable entityValuedFetchable = (EntityValuedFetchable)subPart;
                return new FetchMementoEntityStandard(navigablePath, entityValuedFetchable, this.columnNames);
            }
            if (subPart instanceof EmbeddedAttributeMapping) {
                EmbeddedAttributeMapping embeddedAttributeMapping = (EmbeddedAttributeMapping)subPart;
                ModelPart subPart1 = embeddedAttributeMapping.findSubPart(this.propertyPath.substring(this.propertyPath.indexOf(46) + 1), null);
                return this.getFetchMemento(navigablePath, subPart1);
            }
            throw new UnsupportedOperationException("Only support for basic-valued, entity-valued and embedded model-parts have been implemented : " + this.propertyPath + " [" + String.valueOf(subPart) + "]");
        }
    }
}

