/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.conflicts.KotlinMembersNameConflictsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KtResolvableCollisionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeAlias;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J,\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0016H\u0016J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\f\u0010\u001b\u001a\u00020\u0005*\u00020\u0019H\u0002J<\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u0014\u0010 \u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J5\u0010!\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010&J&\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0005H\u0016\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinClassifierProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "isToSearchInComments", "psiElement", "setToSearchInComments", "", "enabled", "isToSearchForTextOccurrences", "setToSearchForTextOccurrences", "substituteElementToRename", "editor", "Lcom/intellij/openapi/editor/Editor;", "prepareRenaming", "newName", "", "allRenames", "", "processFoundReferences", "", "Lcom/intellij/psi/PsiReference;", "references", "isCompanionObjectClassReference", "findCollisions", "result", "", "Lcom/intellij/usageView/UsageInfo;", "getClassOrObject", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "findReferences", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nRenameKotlinClassifierProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameKotlinClassifierProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinClassifierProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,136:1\n1869#2,2:137\n774#2:139\n865#2,2:140\n774#2:148\n865#2,2:149\n37#3:142\n36#3,3:143\n13472#4,2:146\n*S KotlinDebug\n*F\n+ 1 RenameKotlinClassifierProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinClassifierProcessor\n*L\n50#1:137,2\n69#1:139\n69#1:140,2\n47#1:148\n47#1:149,2\n121#1:142\n121#1:143,3\n123#1:146,2\n*E\n"})
public final class RenameKotlinClassifierProcessor
extends RenameKotlinPsiProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtClassOrObject || element instanceof KtLightClass || element instanceof KtConstructor || element instanceof KtTypeAlias;
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRENAME_SEARCH_IN_COMMENTS_FOR_CLASS();
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KotlinCommonRefactoringSettings.Companion.getInstance().setRENAME_SEARCH_IN_COMMENTS_FOR_CLASS(enabled);
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRENAME_SEARCH_FOR_TEXT_FOR_CLASS();
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KotlinCommonRefactoringSettings.Companion.getInstance().setRENAME_SEARCH_FOR_TEXT_FOR_CLASS(enabled);
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getClassOrObject(element);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        super.prepareRenaming(element, newName, allRenames);
        PsiElement psiElement = this.getClassOrObject(element);
        KtClassOrObject ktClassOrObject = psiElement instanceof KtClassOrObject ? (KtClassOrObject)psiElement : null;
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List topLevelClassifiers = (List)ActionUtil.underModalProgress((Project)project, (String)KotlinBundle.message((String)"progress.title.searching.for.expected.actual", (Object[])new Object[0]), () -> RenameKotlinClassifierProcessor.prepareRenaming$lambda$1(classOrObject));
        Intrinsics.checkNotNull((Object)topLevelClassifiers);
        Iterable $this$forEach$iv = topLevelClassifiers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String nameWithoutExtensions;
            KtFile file;
            KtDeclaration it = (KtDeclaration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getContainingKtFile(), (String)"getContainingKtFile(...)");
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile.getNameWithoutExtension(), (String)"getNameWithoutExtension(...)");
            if (!Intrinsics.areEqual((Object)nameWithoutExtensions, (Object)it.getName())) continue;
            String newFileName = newName + "." + virtualFile.getExtension();
            allRenames.put((PsiElement)file, newFileName);
            RenamePsiElementProcessor.forElement((PsiElement)((PsiElement)file)).prepareRenaming((PsiElement)file, newFileName, allRenames);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiReference> processFoundReferences(PsiElement element, Collection<? extends PsiReference> references) {
        if (element instanceof KtObjectDeclaration && ((KtObjectDeclaration)element).isCompanion()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = references;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiReference it = (PsiReference)element$iv$iv;
                boolean bl = false;
                if (!(!this.isCompanionObjectClassReference(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return references;
    }

    private final boolean isCompanionObjectClassReference(PsiReference $this$isCompanionObjectClassReference) {
        return this.getRenameRefactoringSupport().isCompanionObjectClassReference($this$isCompanionObjectClassReference);
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)element);
        KtNamedDeclaration ktNamedDeclaration = psiNamedElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiNamedElement : null;
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration = ktNamedDeclaration;
        SmartList collisions = new SmartList();
        KotlinMembersNameConflictsKt.checkRedeclarationConflicts(declaration, newName, (List)collisions);
        this.getRenameRefactoringSupport().checkUsagesRetargeting(declaration, newName, result2, (List)collisions);
        CollectionsKt.addAll((Collection)result2, (Iterable)((Iterable)collisions));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PsiElement getClassOrObject(PsiElement element) {
        PsiElement psiElement;
        PsiElement psiElement2 = element;
        if (psiElement2 instanceof KtLightClass) {
            if (this.getRenameRefactoringSupport().isLightClassForRegularKotlinClass((KtLightClass)element)) {
                psiElement = (PsiElement)((KtLightClass)element).getKotlinOrigin();
                return psiElement;
            } else {
                if (!(element instanceof KtLightClassForFacade)) throw new AssertionError((Object)("Should not be suggested to rename element of type " + element.getClass() + " " + element));
                psiElement = element;
            }
            return psiElement;
        } else if (psiElement2 instanceof KtConstructor) {
            psiElement = (PsiElement)((KtConstructor)element).getContainingClassOrObject();
            return psiElement;
        } else {
            if (!(psiElement2 instanceof KtClassOrObject)) {
                if (!(psiElement2 instanceof KtTypeAlias)) return null;
            }
            psiElement = element;
        }
        return psiElement;
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        ArrayList simpleUsages = new ArrayList(usages2.length);
        SmartList ambiguousImportUsages = new SmartList();
        SmartList simpleImportUsages = new SmartList();
        int n = usages2.length;
        block5: for (int j = 0; j < n; ++j) {
            UsageInfo usage = usages2[j];
            switch (WhenMappings.$EnumSwitchMapping$0[this.importState(usage).ordinal()]) {
                case 1: {
                    ((Collection)ambiguousImportUsages).add(usage);
                    continue block5;
                }
                case 2: {
                    ((Collection)simpleImportUsages).add(usage);
                    continue block5;
                }
                case 3: {
                    ((Collection)simpleUsages).add(usage);
                    continue block5;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.setAmbiguousImportUsages(element, (List)ambiguousImportUsages);
        List usagesToRename = simpleImportUsages.isEmpty() ? (List)simpleUsages : CollectionsKt.plus((Collection)((Collection)simpleImportUsages), (Iterable)simpleUsages);
        Collection $this$toTypedArray$iv = usagesToRename;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        super.renameElement(element, newName, thisCollection$iv.toArray(new UsageInfo[0]), listener2);
        UsageInfo[] $this$forEach$iv = usages2;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int j = 0; j < n2; ++j) {
            UsageInfo element$iv;
            UsageInfo it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            KtResolvableCollisionUsageInfo ktResolvableCollisionUsageInfo = it instanceof KtResolvableCollisionUsageInfo ? (KtResolvableCollisionUsageInfo)it : null;
            if (ktResolvableCollisionUsageInfo == null) continue;
            ktResolvableCollisionUsageInfo.apply();
        }
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Collection<PsiReference> references = super.findReferences(element, searchScope, searchInCommentsAndStrings);
        return this.processFoundReferences(element, references);
    }

    /*
     * WARNING - void declaration
     */
    private static final List prepareRenaming$lambda$1(KtClassOrObject $classOrObject) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ExpectActualUtils.INSTANCE.withExpectedActuals((KtDeclaration)$classOrObject);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtDeclaration it = (KtDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(it.getParent() instanceof KtFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RenameKotlinPsiProcessor.ImportState.values().length];
            try {
                nArray[RenameKotlinPsiProcessor.ImportState.AMBIGUOUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenameKotlinPsiProcessor.ImportState.SIMPLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenameKotlinPsiProcessor.ImportState.NOT_IMPORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

