/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.ApplicabilityRange;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ConvertNaNEqualityInspectionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001d\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0003*\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertNaNEqualityInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertNaNEqualityInspection$Context;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "element", "context", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "isApplicableByPsi", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Context", "kotlin.code-insight.inspections.k2"})
public final class ConvertNaNEqualityInspection
extends KotlinApplicableInspectionBase.Simple<KtBinaryExpression, Context> {
    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.binaryExpressionVisitor(arg_0 -> ConvertNaNEqualityInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtBinaryExpression element, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return KotlinBundle.message((String)"equality.check.with.nan.should.be.replaced.with.isnan", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ApplicabilityRange.INSTANCE.self((PsiElement)element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableByPsi(@NotNull KtBinaryExpression element) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IElementType iElementType = element.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType operationToken = iElementType;
        if (!Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.EQEQ)) {
            if (!Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.EXCLEQ)) return false;
        }
        if ((object = element.getLeft()) != null && (object = object.getText()) != null) {
            if (StringsKt.endsWith$default((String)object, (String)"NaN", (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        KtExpression ktExpression = element.getRight();
        Object object2 = ktExpression;
        if (ktExpression == null) return false;
        String string = object2.getText();
        object2 = string;
        if (string == null) return false;
        if (!StringsKt.endsWith$default((String)object2, (String)"NaN", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtBinaryExpression element) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression2 = element.getLeft();
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression left = ktExpression2;
        KtExpression ktExpression3 = element.getRight();
        if (ktExpression3 == null) {
            return null;
        }
        KtExpression right = ktExpression3;
        if (ConvertNaNEqualityInspectionKt.access$isNaNExpression($this$prepareContext, left)) {
            ktExpression = right;
        } else if (ConvertNaNEqualityInspectionKt.access$isNaNExpression($this$prepareContext, right)) {
            ktExpression = left;
        } else {
            return null;
        }
        KtExpression otherExpression = ktExpression;
        return new Context(otherExpression);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtBinaryExpression> createQuickFix(@NotNull KtBinaryExpression element, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new KotlinModCommandQuickFix<KtBinaryExpression>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
            }

            public String getFamilyName() {
                return KotlinBundle.message((String)"convert.na.n.equality.quick.fix.text", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtBinaryExpression element, ModPsiUpdater updater2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                IElementType iElementType = element.getOperationToken();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
                    bl = true;
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
                    bl = false;
                } else {
                    return;
                }
                boolean inverted = bl;
                String pattern2 = inverted ? "!$0.isNaN()" : "$0.isNaN()";
                Object[] objectArray = new Object[]{this.$context.getOtherExpression()};
                element.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)pattern2, (Object[])objectArray, (boolean)false, (int)4, null));
            }
        };
    }

    private static final Unit buildVisitor$lambda$0(ConvertNaNEqualityInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtBinaryExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertNaNEqualityInspection$Context;", "", "otherExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getOtherExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.code-insight.inspections.k2"})
    public static final class Context {
        @NotNull
        private final KtExpression otherExpression;

        public Context(@NotNull KtExpression otherExpression) {
            Intrinsics.checkNotNullParameter((Object)otherExpression, (String)"otherExpression");
            this.otherExpression = otherExpression;
        }

        @NotNull
        public final KtExpression getOtherExpression() {
            return this.otherExpression;
        }

        @NotNull
        public final KtExpression component1() {
            return this.otherExpression;
        }

        @NotNull
        public final Context copy(@NotNull KtExpression otherExpression) {
            Intrinsics.checkNotNullParameter((Object)otherExpression, (String)"otherExpression");
            return new Context(otherExpression);
        }

        public static /* synthetic */ Context copy$default(Context context, KtExpression ktExpression, int n, Object object) {
            if ((n & 1) != 0) {
                ktExpression = context.otherExpression;
            }
            return context.copy(ktExpression);
        }

        @NotNull
        public String toString() {
            return "Context(otherExpression=" + this.otherExpression + ")";
        }

        public int hashCode() {
            return this.otherExpression.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            return Intrinsics.areEqual((Object)this.otherExpression, (Object)context.otherExpression);
        }
    }
}

