/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.lookups.factories;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.analysis.RootPrefixUtils;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategy;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategyKt;
import org.jetbrains.kotlin.idea.completion.lookups.KotlinCallableLookupObject;
import org.jetbrains.kotlin.idea.completion.lookups.QuotedNamesAwareInsertionHandler;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/factories/CallableIdentifierInsertionHandler;", "Lorg/jetbrains/kotlin/idea/completion/lookups/QuotedNamesAwareInsertionHandler;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "kotlin.completion.impl.k2"})
public class CallableIdentifierInsertionHandler
extends QuotedNamesAwareInsertionHandler {
    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiFile psiFile = context.getFile();
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return;
        }
        KtFile targetFile = ktFile2;
        Object object = item.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.completion.lookups.KotlinCallableLookupObject");
        KotlinCallableLookupObject lookupObject = (KotlinCallableLookupObject)object;
        super.handleInsert(context, item);
        ImportStrategy importStrategy = lookupObject.getOptions().getImportingStrategy();
        if (importStrategy instanceof ImportStrategy.AddImport) {
            ImportStrategyKt.addImportIfRequired(context, ((ImportStrategy.AddImport)importStrategy).getNameToImport());
        } else if (importStrategy instanceof ImportStrategy.InsertFqNameAndShorten) {
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)RenderingUtilsKt.render((FqName)RootPrefixUtils.withRootPrefixIfNeeded$default(((ImportStrategy.InsertFqNameAndShorten)importStrategy).getFqName(), null, 1, null)));
            context.commitDocument();
            ShortenUtilsKt.shortenReferencesInRange$default(targetFile, new TextRange(context.getStartOffset(), context.getTailOffset()), null, null, null, 28, null);
        } else if (!(importStrategy instanceof ImportStrategy.DoNothing)) {
            throw new NoWhenBranchMatchedException();
        }
    }
}

