/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.DelegatingFileSystemProvider;
import com.intellij.platform.core.nio.fs.MultiRoutingFileSystem;
import com.intellij.platform.core.nio.fs.MultiRoutingFsPath;
import com.intellij.platform.core.nio.fs.RoutingAwareFileSystemProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.nio.file.spi.FileTypeDetector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import sun.nio.fs.DefaultFileTypeDetector;

public final class MultiRoutingFileSystemProvider
extends DelegatingFileSystemProvider<MultiRoutingFileSystemProvider, MultiRoutingFileSystem> {
    static final boolean ourForceDefaultFs = Objects.equals(System.getProperty("idea.force.default.filesystem"), "true");
    @VisibleForTesting
    public final FileSystemProvider myLocalProvider;
    private final MultiRoutingFileSystem myFileSystem;
    volatile BiConsumer<String, Boolean> myPathSpy = (ignored, ignored2) -> {};
    private static final String KEY_MRFS = "MRFS";
    private static final String KEY_ROOT = "KEY_ROOT";
    private static final String KEY_PREFIX = "KEY_PREFIX";
    private static final String KEY_CASE_SENSITIVE = "KEY_CASE_SENSITIVE";
    private static final String KEY_FUNCTION = "KEY_FUNCTION";
    private static final Map<FileSystemProvider, Optional<Method>> ourCanHandleRoutingCache = Collections.synchronizedMap(new WeakHashMap());

    public static void computeBackend(@NotNull FileSystemProvider provider, @NotNull String root, boolean isPrefix, boolean caseSensitive, @NotNull @NotNull BiFunction<@NotNull FileSystemProvider, @Nullable FileSystem, @Nullable FileSystem> function) {
        if (provider == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(0);
        }
        if (root == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(1);
        }
        if (function == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(2);
        }
        if (provider.getClass().getName().equals(MultiRoutingFileSystemProvider.class.getName())) {
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            arguments.put(KEY_MRFS, Void.TYPE);
            arguments.put(KEY_ROOT, root);
            arguments.put(KEY_PREFIX, isPrefix);
            arguments.put(KEY_CASE_SENSITIVE, caseSensitive);
            arguments.put(KEY_FUNCTION, function);
            try {
                provider.newFileSystem(URI.create("file:/"), arguments);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            throw new IllegalArgumentException(String.format("%s is not an instance of %s", provider, MultiRoutingFileSystemProvider.class));
        }
    }

    public static void setPathSpy(@NotNull FileSystemProvider provider, @NotNull @NotNull BiConsumer<@NotNull String, @NotNull Boolean> pathSpy) {
        if (provider == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(3);
        }
        if (pathSpy == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(4);
        }
        if (provider.getClass().getName().equals(MultiRoutingFileSystemProvider.class.getName())) {
            try {
                provider.getClass().getMethod("setPathSpy", BiConsumer.class).invoke((Object)provider, pathSpy);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException(String.format("%s is not an instance of %s", provider, MultiRoutingFileSystemProvider.class));
        }
    }

    public void setPathSpy(@NotNull BiConsumer<String, Boolean> pathSpy) {
        if (pathSpy == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(5);
        }
        this.myPathSpy = pathSpy;
    }

    public MultiRoutingFileSystemProvider(FileSystemProvider localFSProvider) {
        this.myLocalProvider = localFSProvider;
        this.myFileSystem = new MultiRoutingFileSystem(this, this.myLocalProvider.getFileSystem(URI.create("file:///")));
    }

    @Override
    @NotNull
    protected MultiRoutingFileSystem wrapDelegateFileSystem(@NotNull FileSystem delegateFs) {
        if (delegateFs == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(6);
        }
        return new MultiRoutingFileSystem(this, delegateFs);
    }

    @Override
    @Nullable
    public MultiRoutingFileSystem newFileSystem(Path path, @Nullable Map<String, ?> env) {
        throw new UnsupportedOperationException(MultiRoutingFileSystemProvider.class.getName() + " doesn't open other files as filesystems");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @Nullable
    public MultiRoutingFileSystem newFileSystem(URI uri, @Nullable Map<String, ?> env) {
        if (env == null || !env.containsKey(KEY_MRFS)) {
            throw new UnsupportedOperationException(MultiRoutingFileSystem.class.getName() + " can be created only with `" + MultiRoutingFileSystemProvider.class.getName() + ".computeBackend()`. Otherwise, this file system provider behaves as a default file system provider and throws an error.");
        }
        String root = Objects.requireNonNull((String)env.get(KEY_ROOT));
        Boolean isPrefix = Objects.requireNonNull((Boolean)env.get(KEY_PREFIX));
        Boolean caseSensitive = Objects.requireNonNull((Boolean)env.get(KEY_CASE_SENSITIVE));
        @NotNull @Nullable @Nullable BiFunction function = Objects.requireNonNull((BiFunction)env.get(KEY_FUNCTION));
        this.myFileSystem.computeBackend(root, isPrefix, caseSensitive, function);
        return null;
    }

    @Override
    @NotNull
    public MultiRoutingFileSystem getFileSystem(@NotNull URI uri) {
        if (uri == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(7);
        }
        if (uri.equals(URI.create("file:///"))) {
            MultiRoutingFileSystem multiRoutingFileSystem = this.myFileSystem;
            if (multiRoutingFileSystem == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(8);
            }
            return multiRoutingFileSystem;
        }
        throw new UnsupportedOperationException(String.format("Unexpected URI: %s\nThis class is supposed to replace the local file system.", uri));
    }

    @Override
    @NotNull
    protected FileSystemProvider getDelegate(@Nullable Path path1, @Nullable Path path2) {
        String path2String;
        FileSystem backend2;
        FileSystemProvider provider2;
        if (ourForceDefaultFs) {
            FileSystemProvider fileSystemProvider = this.myLocalProvider;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(9);
            }
            return fileSystemProvider;
        }
        if (path1 == null) {
            if (path2 == null) {
                FileSystemProvider fileSystemProvider = this.myLocalProvider;
                if (fileSystemProvider == null) {
                    MultiRoutingFileSystemProvider.$$$reportNull$$$0(10);
                }
                return fileSystemProvider;
            }
            path1 = path2;
            path2 = null;
        }
        if (!path1.isAbsolute()) {
            path1 = path1.toAbsolutePath();
        }
        String path1String = path1.toString();
        FileSystem backend1 = this.myFileSystem.getBackend(path1String);
        FileSystemProvider provider1 = backend1.provider();
        if (path2 == null) {
            this.myPathSpy.accept(path1String, provider1 != this);
            FileSystemProvider fileSystemProvider = provider1;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(11);
            }
            return fileSystemProvider;
        }
        if (!path2.isAbsolute()) {
            path2 = path2.toAbsolutePath();
        }
        if (provider1.equals(provider2 = (backend2 = this.myFileSystem.getBackend(path2String = path2.toString())).provider())) {
            this.myPathSpy.accept(path1String, provider1 != this);
            FileSystemProvider fileSystemProvider = provider1;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(12);
            }
            return fileSystemProvider;
        }
        if (MultiRoutingFileSystemProvider.canHandleRouting(provider1, backend2.getPath(path2String, new String[0]))) {
            this.myPathSpy.accept(path1String, provider1 != this);
            FileSystemProvider fileSystemProvider = provider1;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(13);
            }
            return fileSystemProvider;
        }
        if (MultiRoutingFileSystemProvider.canHandleRouting(provider2, backend1.getPath(path1String, new String[0]))) {
            this.myPathSpy.accept(path2String, provider2 != this);
            FileSystemProvider fileSystemProvider = provider2;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(14);
            }
            return fileSystemProvider;
        }
        throw new IllegalArgumentException(String.format("Provider mismatch: %s != %s", provider1, provider2));
    }

    private static boolean canHandleRouting(FileSystemProvider provider, @NotNull Path path) {
        if (path == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(15);
        }
        if (provider instanceof RoutingAwareFileSystemProvider) {
            return ((RoutingAwareFileSystemProvider)((Object)provider)).canHandleRouting(path);
        }
        Method method = ourCanHandleRoutingCache.computeIfAbsent(provider, MultiRoutingFileSystemProvider::canHandleRoutingImpl).orElse(null);
        if (method == null) {
            return false;
        }
        try {
            return (Boolean)method.invoke((Object)provider, path);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<Method> canHandleRoutingImpl(FileSystemProvider provider) {
        Class<?> providerClass = provider.getClass();
        do {
            for (Class<?> iface : providerClass.getInterfaces()) {
                if (!iface.getName().equals(RoutingAwareFileSystemProvider.class.getName())) continue;
                try {
                    return Optional.of(iface.getMethod("canHandleRouting", new Class[0]));
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
        } while ((providerClass = providerClass.getSuperclass()) != null);
        return Optional.empty();
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    @VisibleForTesting
    @Nullable
    public Path wrapDelegatePath(@Nullable Path delegatePath) {
        if (delegatePath == null) {
            return null;
        }
        if (delegatePath instanceof MultiRoutingFsPath) {
            return delegatePath;
        }
        return new MultiRoutingFsPath(this.myFileSystem, delegatePath);
    }

    @NotNull
    private static FileTypeDetector getDefaultFileTypeDetector() {
        FileTypeDetector fileTypeDetector;
        try {
            fileTypeDetector = DefaultFileTypeDetector.create();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            return new FileTypeDetector(){

                @Override
                public String probeContentType(Path path) {
                    return null;
                }
            };
        }
        if (fileTypeDetector == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(16);
        }
        return fileTypeDetector;
    }

    @NotNull
    static FileTypeDetector getFileTypeDetector(FileSystemProvider multiRoutingFileSystemProvider) {
        FileTypeDetector fileTypeDetector;
        if (multiRoutingFileSystemProvider instanceof MultiRoutingFileSystemProvider) {
            MultiRoutingFileSystemProvider provider = (MultiRoutingFileSystemProvider)multiRoutingFileSystemProvider;
            try {
                fileTypeDetector = provider.getFileTypeDetectorInternal();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace(System.err);
                fileTypeDetector = MultiRoutingFileSystemProvider.getDefaultFileTypeDetector();
            }
        } else if (multiRoutingFileSystemProvider.getClass().getName().equals(MultiRoutingFileSystemProvider.class.getName())) {
            try {
                Method method = multiRoutingFileSystemProvider.getClass().getDeclaredMethod("getFileTypeDetectorInternal", new Class[0]);
                method.setAccessible(true);
                fileTypeDetector = (FileTypeDetector)method.invoke((Object)multiRoutingFileSystemProvider, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace(System.err);
                fileTypeDetector = MultiRoutingFileSystemProvider.getDefaultFileTypeDetector();
            }
        } else {
            fileTypeDetector = MultiRoutingFileSystemProvider.getDefaultFileTypeDetector();
        }
        FileTypeDetector fileTypeDetector2 = fileTypeDetector;
        if (fileTypeDetector2 == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(17);
        }
        return fileTypeDetector2;
    }

    private FileTypeDetector getFileTypeDetectorInternal() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        FileTypeDetector delegateDetector;
        Class<? extends FileSystemProvider> unixFileSystemProviderClass = this.getUnixFileSystemProviderClass();
        if (unixFileSystemProviderClass != null) {
            Method getFileTypeDetectorMethod = unixFileSystemProviderClass.getDeclaredMethod("getFileTypeDetector", new Class[0]);
            getFileTypeDetectorMethod.setAccessible(true);
            delegateDetector = (FileTypeDetector)getFileTypeDetectorMethod.invoke((Object)this.myLocalProvider, new Object[0]);
        } else {
            delegateDetector = MultiRoutingFileSystemProvider.getDefaultFileTypeDetector();
        }
        return new FileTypeDetector(){

            @Override
            public String probeContentType(Path path) throws IOException {
                return delegateDetector.probeContentType(MultiRoutingFileSystemProvider.this.toDelegatePath(path));
            }
        };
    }

    @Nullable
    private Class<? extends FileSystemProvider> getUnixFileSystemProviderClass() {
        Class<Object> unixFileSystemProviderClass = this.myLocalProvider.getClass();
        while (unixFileSystemProviderClass != null && !"sun.nio.fs.UnixFileSystemProvider".equals(unixFileSystemProviderClass.getName())) {
            Class<?> superclass = unixFileSystemProviderClass.getSuperclass();
            if (FileSystemProvider.class.isAssignableFrom(superclass)) {
                unixFileSystemProviderClass = superclass.asSubclass(FileSystemProvider.class);
                continue;
            }
            unixFileSystemProviderClass = null;
        }
        return unixFileSystemProviderClass;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public Path toDelegatePath(@Nullable Path path) {
        if (path instanceof MultiRoutingFsPath) {
            return ((MultiRoutingFsPath)path).getDelegate();
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 14, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathSpy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateFs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystemProvider";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystemProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileTypeDetector";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeBackend";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPathSpy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapDelegateFileSystem";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileSystem";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canHandleRouting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 14, 16, 17 -> new IllegalStateException(string);
        };
    }
}

