/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.model.Pointer;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.navigation.SymbolNavigationService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.GradleIcons;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradlePluginSymbol;", "Lcom/intellij/navigation/NavigatableSymbol;", "Lcom/intellij/find/usages/api/SearchTarget;", "filePath", "", "qualifiedName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "createPointer", "Lcom/intellij/model/Pointer;", "presentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "getNavigationTargets", "", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "findPluginFile", "Lcom/intellij/psi/PsiFile;", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getUsageHandler", "()Lcom/intellij/find/usages/api/UsageHandler;", "equals", "", "other", "", "hashCode", "", "intellij.gradle.java"})
@ApiStatus.Internal
public final class GradlePluginSymbol
implements NavigatableSymbol,
SearchTarget {
    @NotNull
    private final String filePath;
    @NotNull
    private final String qualifiedName;

    public GradlePluginSymbol(@NotNull String filePath, @NotNull String qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        this.filePath = filePath;
        this.qualifiedName = qualifiedName;
        if (!(!StringsKt.isBlank((CharSequence)this.filePath))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public Pointer<? extends GradlePluginSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    @NotNull
    public TargetPresentation presentation() {
        Object[] objectArray = new Object[]{this.qualifiedName};
        String string = GradleBundle.message((String)"gradle.plugin.0", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(string).icon(GradleIcons.Gradle).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public Collection<NavigationTarget> getNavigationTargets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = this.findPluginFile(project);
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile2 = psiFile;
        return CollectionsKt.listOf((Object)SymbolNavigationService.getInstance().psiFileNavigationTarget(psiFile2));
    }

    private final PsiFile findPluginFile(Project project) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(this.filePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return PsiManager.getInstance((Project)project).findFile(virtualFile2);
    }

    @NotNull
    public UsageHandler getUsageHandler() {
        UsageHandler usageHandler = UsageHandler.createEmptyUsageHandler((String)this.qualifiedName);
        Intrinsics.checkNotNullExpressionValue((Object)usageHandler, (String)"createEmptyUsageHandler(...)");
        return usageHandler;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.service.resolve.GradlePluginSymbol");
        GradlePluginSymbol cfr_ignored_0 = (GradlePluginSymbol)other;
        return Intrinsics.areEqual((Object)this.filePath, (Object)((GradlePluginSymbol)other).filePath);
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }
}

