/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.instructions;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.data.instructions.JumpInstructions;
import com.intellij.rt.coverage.data.instructions.LineInstructions;
import com.intellij.rt.coverage.data.instructions.SwitchInstructions;
import org.jetbrains.coverage.gnu.trove.TIntArrayList;

public class ClassInstructions {
    private static final LineInstructions[] EMPTY_LINES = new LineInstructions[0];
    private LineInstructions[] myLines;

    public ClassInstructions() {
        this.myLines = EMPTY_LINES;
    }

    /*
     * WARNING - void declaration
     */
    public ClassInstructions(LineInstructions[] lines) {
        void var1_1;
        this.myLines = var1_1;
    }

    public ClassInstructions(ClassData data, TIntArrayList instructions) {
        if (data.getLines() == null) {
            this.myLines = EMPTY_LINES;
            return;
        }
        int size = data.getLines().length;
        this.myLines = new LineInstructions[size];
        for (int line = 0; line < size; ++line) {
            SwitchData[] switches;
            LineInstructions lineInstructions;
            LineData lineData = data.getLineData(line);
            if (lineData == null) continue;
            this.myLines[line] = lineInstructions = new LineInstructions();
            lineInstructions.setInstructions(instructions.get(lineData.getId()));
            JumpData[] jumps = lineData.getJumps();
            if (jumps != null) {
                for (JumpData jumpData : jumps) {
                    JumpInstructions jumpInstructions = new JumpInstructions();
                    jumpInstructions.setInstructions(true, instructions.get(jumpData.getId(true)));
                    jumpInstructions.setInstructions(false, instructions.get(jumpData.getId(false)));
                    lineInstructions.addJump(jumpInstructions);
                }
            }
            if ((switches = lineData.getSwitches()) == null) continue;
            SwitchData[] switchDataArray = switches;
            int n = switches.length;
            for (int i = 0; i < n; ++i) {
                SwitchData switchData = switchDataArray[i];
                SwitchInstructions switchInstructions = new SwitchInstructions(switchData.getKeys().length);
                for (int i2 = -1; i2 < switchData.getKeys().length; ++i2) {
                    switchInstructions.setInstructions(i2, instructions.get(switchData.getId(i2)));
                }
                lineInstructions.addSwitch(switchInstructions);
            }
        }
    }

    public LineInstructions[] getlines() {
        return this.myLines;
    }

    public void merge(ClassInstructions other) {
        if (this.myLines.length < other.myLines.length) {
            LineInstructions[] old = this.myLines;
            this.myLines = new LineInstructions[other.myLines.length];
            System.arraycopy(old, 0, this.myLines, 0, old.length);
        }
        for (int i = 0; i < other.myLines.length; ++i) {
            if (other.myLines[i] == null) continue;
            if (this.myLines[i] == null) {
                this.myLines[i] = new LineInstructions();
            }
            this.myLines[i].merge(other.myLines[i]);
        }
    }
}

