/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.State;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nFqNamesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FqNamesUtil.kt\norg/jetbrains/kotlin/name/FqNamesUtilKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n538#2:87\n523#2,6:88\n1#3:94\n*S KotlinDebug\n*F\n+ 1 FqNamesUtil.kt\norg/jetbrains/kotlin/name/FqNamesUtilKt\n*L\n73#1:87\n73#1:88,6\n*E\n"})
public final class FqNamesUtilKt {
    public static final boolean isSubpackageOf(@NotNull FqName $this$isSubpackageOf, @NotNull FqName packageName) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubpackageOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return Intrinsics.areEqual((Object)$this$isSubpackageOf, (Object)packageName) ? true : (packageName.isRoot() ? true : FqNamesUtilKt.isSubpackageOf($this$isSubpackageOf.asString(), packageName.asString()));
    }

    public static final boolean isChildOf(@NotNull FqName $this$isChildOf, @NotNull FqName packageName) {
        Intrinsics.checkNotNullParameter((Object)$this$isChildOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return Intrinsics.areEqual((Object)FqNamesUtilKt.parentOrNull($this$isChildOf), (Object)packageName);
    }

    private static final boolean isSubpackageOf(String subpackageNameStr, String packageNameStr) {
        return StringsKt.startsWith$default((String)subpackageNameStr, (String)packageNameStr, (boolean)false, (int)2, null) && subpackageNameStr.charAt(packageNameStr.length()) == '.';
    }

    @NotNull
    public static final FqName tail(@NotNull FqName $this$tail, @NotNull FqName prefix) {
        FqName fqName;
        Intrinsics.checkNotNullParameter((Object)$this$tail, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (!FqNamesUtilKt.isSubpackageOf($this$tail, prefix) || prefix.isRoot()) {
            fqName = $this$tail;
        } else if (Intrinsics.areEqual((Object)$this$tail, (Object)prefix)) {
            fqName = FqName.ROOT;
        } else {
            String string = $this$tail.asString().substring(prefix.asString().length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fqName = new FqName(string);
        }
        return fqName;
    }

    @Nullable
    public static final FqName parentOrNull(@NotNull FqName $this$parentOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$parentOrNull, (String)"<this>");
        return $this$parentOrNull.isRoot() ? null : $this$parentOrNull.parent();
    }

    public static final boolean isValidJavaFqName(@Nullable String qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        State state = State.BEGINNING;
        block4: for (int i = 0; i < ((CharSequence)qualifiedName).length(); ++i) {
            char c = ((CharSequence)qualifiedName).charAt(i);
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierStart(c)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    continue block4;
                }
                case 3: {
                    if (c == '.') {
                        state = State.AFTER_DOT;
                        continue block4;
                    }
                    if (Character.isJavaIdentifierPart(c)) continue block4;
                    return false;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return state != State.AFTER_DOT;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <V> V findValueForMostSpecificFqname(@NotNull FqName $this$findValueForMostSpecificFqname, @NotNull Map<FqName, ? extends V> values) {
        Object v1;
        Map map;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findValueForMostSpecificFqname, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Map<FqName, ? extends V> $this$filter$iv = values;
        boolean $i$f$filter = false;
        Map<FqName, ? extends V> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            FqName fqName = (FqName)entry.getKey();
            if (!(Intrinsics.areEqual((Object)$this$findValueForMostSpecificFqname, (Object)fqName) || FqNamesUtilKt.isChildOf($this$findValueForMostSpecificFqname, fqName))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map it = map = destination$iv$iv;
        boolean bl = false;
        Map map3 = !it.isEmpty() ? map : null;
        if (map3 == null) {
            return null;
        }
        Map suitableItems = map3;
        Iterable iterable = suitableItems.entrySet();
        Iterator iterator3 = iterable.iterator();
        if (!iterator3.hasNext()) {
            v1 = null;
        } else {
            Object t = iterator3.next();
            if (!iterator3.hasNext()) {
                v1 = t;
            } else {
                Map.Entry entry = (Map.Entry)t;
                boolean bl2 = false;
                FqName fqName = (FqName)entry.getKey();
                int n = FqNamesUtilKt.tail(fqName, $this$findValueForMostSpecificFqname).asString().length();
                do {
                    Object t2 = iterator3.next();
                    Map.Entry entry2 = (Map.Entry)t2;
                    $i$a$-minByOrNull-FqNamesUtilKt$findValueForMostSpecificFqname$1 = false;
                    FqName fqName2 = (FqName)entry2.getKey();
                    int n2 = FqNamesUtilKt.tail(fqName2, $this$findValueForMostSpecificFqname).asString().length();
                    if (n <= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator3.hasNext());
                v1 = t;
            }
        }
        Map.Entry entry = v1;
        return (V)(entry != null ? entry.getValue() : null);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.BEGINNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.AFTER_DOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

