/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.linux;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.pcode.emu.DefaultPcodeThread;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.linux.AbstractEmuLinuxSyscallUseropLibrary;
import ghidra.pcode.emu.unix.EmuUnixFileSystem;
import ghidra.pcode.emu.unix.EmuUnixUser;
import ghidra.pcode.exec.AnnotatedPcodeUseropLibrary;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class EmuLinuxX86SyscallUseropLibrary<T>
extends AbstractEmuLinuxSyscallUseropLibrary<T> {
    protected final Register regEIP;
    protected final Register regEAX;
    protected FileDataTypeManager clib32;

    public EmuLinuxX86SyscallUseropLibrary(PcodeMachine<T> machine, EmuUnixFileSystem<T> fs, Program program) {
        this(machine, fs, program, EmuUnixUser.DEFAULT_USER);
    }

    public EmuLinuxX86SyscallUseropLibrary(PcodeMachine<T> machine, EmuUnixFileSystem<T> fs, Program program, EmuUnixUser user) {
        super(machine, fs, program, user);
        this.regEIP = machine.getLanguage().getRegister("EIP");
        this.regEAX = machine.getLanguage().getRegister("EAX");
    }

    @Override
    protected Collection<DataTypeManager> getAdditionalArchives() {
        try {
            ResourceFile file = Application.findDataFileInAnyModule((String)"typeinfo/generic/generic_clib.gdt");
            this.clib32 = FileDataTypeManager.openFileArchive((ResourceFile)file, (boolean)false);
            return List.of(this.clib32);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected void disposeAdditionalArchives() {
        this.clib32.close();
    }

    @Override
    public long readSyscallNumber(PcodeExecutorState<T> state, PcodeExecutorStatePiece.Reason reason) {
        return this.machine.getArithmetic().toLong(state.getVar(this.regEAX, reason), PcodeArithmetic.Purpose.OTHER);
    }

    @Override
    protected boolean returnErrno(PcodeExecutor<T> executor, int errno) {
        executor.getState().setVar(this.regEAX, executor.getArithmetic().fromConst((long)(-errno), this.regEAX.getMinimumByteSize()));
        return true;
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop
    public T swi(@AnnotatedPcodeUseropLibrary.OpExecutor PcodeExecutor<T> executor, @AnnotatedPcodeUseropLibrary.OpLibrary PcodeUseropLibrary<T> library, T number) {
        PcodeArithmetic arithmetic = executor.getArithmetic();
        long intNo = arithmetic.toLong(number, PcodeArithmetic.Purpose.OTHER);
        if (intNo == 128L) {
            Object next = executor.getState().getVar(this.regEIP, executor.getReason());
            DefaultPcodeThread.PcodeThreadExecutor te = (DefaultPcodeThread.PcodeThreadExecutor)executor;
            int pcSize = this.regEIP.getNumBytes();
            int iLen = te.getThread().getInstruction().getLength();
            next = arithmetic.binaryOp(19, pcSize, pcSize, next, pcSize, arithmetic.fromConst((long)iLen, pcSize));
            this.syscall(executor, library);
            return (T)next;
        }
        throw new PcodeExecutionException("Unknown interrupt: 0x" + Long.toString(intNo, 16));
    }
}

