/*
 * Decompiled with CFR 0.152.
 */
package ghidra.taint.gui.field;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegisterColumnFactory;
import ghidra.app.plugin.core.debug.gui.register.RegisterRow;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.Trace;
import ghidra.trace.model.property.TracePropertyMap;
import ghidra.trace.model.property.TracePropertyMapSpace;

public class TaintDebuggerRegisterColumnFactory
implements DebuggerRegisterColumnFactory {
    protected static final String PROP_NAME = "Taint";
    public static final String COL_NAME = "Taint";

    public DynamicTableColumn<RegisterRow, ?, ?> create() {
        return new AbstractDynamicTableColumn<RegisterRow, String, Void>(){

            public String getColumnName() {
                return "Taint";
            }

            public String getValue(RegisterRow rowObject, Settings settings, Void dataSource, ServiceProvider serviceProvider) throws IllegalArgumentException {
                DebuggerCoordinates current = rowObject.getCurrent();
                Trace trace = current.getTrace();
                if (trace == null) {
                    return "";
                }
                TracePropertyMap taintMap = current.getTrace().getAddressPropertyManager().getPropertyMap("Taint", String.class);
                if (taintMap == null) {
                    return "";
                }
                Register register = rowObject.getRegister();
                AddressSpace addressSpace = register.getAddressSpace();
                TracePropertyMapSpace taintSpace = addressSpace.isRegisterSpace() ? taintMap.getPropertyMapRegisterSpace(current.getThread(), current.getFrame(), false) : taintMap.getPropertyMapSpace(addressSpace, false);
                if (taintSpace == null) {
                    return "";
                }
                StringBuffer vec = new StringBuffer();
                int count = register.getNumBytes();
                Address start = register.getAddress();
                for (int i = 0; i < count; ++i) {
                    vec.append('[');
                    String taint = (String)taintSpace.get(current.getViewSnap(), start.addWrap((long)i));
                    vec.append(taint == null ? "" : taint);
                    vec.append(']');
                }
                return vec.toString();
            }
        };
    }
}

