/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBSection;
import SWIG.SBStream;
import SWIG.SBTarget;
import agent.lldb.model.iface2.LldbModelTargetModuleSection;
import agent.lldb.model.impl.LldbModelTargetModuleSectionContainerImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Section", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)})
public class LldbModelTargetModuleSectionImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetModuleSection {
    protected static final String OBJFILE_ATTRIBUTE_NAME = "_objfile";
    protected AddressRange range;

    protected static String keySection(SBSection section) {
        return PathUtils.makeKey((String)section.GetName());
    }

    public LldbModelTargetModuleSectionImpl(LldbModelTargetModuleSectionContainerImpl sections, SBSection section) {
        super(sections.getModel(), (TargetObject)sections, LldbModelTargetModuleSectionImpl.keySection(section), section, "Section");
        AddressSpace space = this.getModel().getAddressSpace("ram");
        Address min = space.getAddress(0L);
        SBTarget currentSession = this.getManager().getCurrentSession();
        long lval = section.GetLoadAddress(currentSession).longValue();
        if (lval != -1L) {
            min = space.getAddress(lval);
        }
        long sz = section.GetFileByteSize().longValue();
        Address max = min.add(sz);
        this.range = new AddressRangeImpl(min, max);
        if (this.range != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("_range", this.range), "Initialized");
        }
        this.changeAttributes(List.of(), List.of(), Map.of("_module", sections.getParent(), "_display", this.getDescription(0), "Address", min, "File Offset", section.GetFileOffset().toString(16), "Size", Long.toHexString(sz), "Permissions", section.GetPermissions()), "Initialized");
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBSection section = (SBSection)this.getModelObject();
        section.GetDescription(stream);
        return stream.GetData();
    }

    @Override
    public AddressRange getRange() {
        return this.range;
    }
}

