/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.iface1;

import agent.lldb.model.iface1.LldbModelSelectableObject;
import agent.lldb.model.iface2.LldbModelTargetObject;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface LldbModelTargetFocusScope
extends LldbModelTargetObject,
TargetFocusScope {
    public LldbModelSelectableObject getFocus();

    public boolean setFocus(LldbModelSelectableObject var1);

    default public CompletableFuture<Void> requestFocus(TargetObject obj) {
        return this.getModel().gateFuture(this.getManager().requestFocus(this, obj));
    }

    default public CompletableFuture<Void> doRequestFocus(TargetObject obj) {
        if (this.getManager().isWaiting()) {
            return AsyncUtils.nil();
        }
        this.getModel().assertMine(TargetObject.class, obj);
        if (obj.equals((Object)this.getFocus())) {
            return AsyncUtils.nil();
        }
        if (!PathUtils.isAncestor((List)this.getPath(), (List)obj.getPath())) {
            throw new DebuggerIllegalArgumentException("Can only focus a successor of the scope");
        }
        TargetObject cur = obj;
        while (cur != null) {
            if (cur instanceof LldbModelSelectableObject) {
                LldbModelSelectableObject sel = (LldbModelSelectableObject)cur;
                this.setFocus(sel);
                return AsyncUtils.nil();
            }
            if (cur instanceof LldbModelTargetObject) {
                LldbModelTargetObject def = (LldbModelTargetObject)cur;
                cur = def.getParent();
                continue;
            }
            throw new AssertionError();
        }
        return AsyncUtils.nil();
    }
}

