/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.TraceTimeManager;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.AbstractPeekableIterator;

public class TraceViewportSpanIterator
extends AbstractPeekableIterator<Lifespan> {
    private final TraceTimeManager timeManager;
    private final Lifespan.MutableLifeSet set = new Lifespan.DefaultLifeSet();
    private long snap;
    private boolean done = false;

    public TraceViewportSpanIterator(Trace trace, long snap) {
        this.timeManager = trace.getTimeManager();
        this.snap = snap;
    }

    protected TraceSnapshot locateMostRecentFork(long from) {
        TraceSnapshot prev;
        while (true) {
            if ((prev = this.timeManager.getMostRecentSnapshot(from)) == null) {
                return null;
            }
            TraceSchedule prevSched = prev.getSchedule();
            long prevKey = prev.getKey();
            if (prevSched == null) {
                if (prevKey == Long.MIN_VALUE) {
                    return null;
                }
                from = prevKey - 1L;
                continue;
            }
            long forkedSnap = prevSched.getSnap();
            if (forkedSnap != prevKey - 1L) break;
            --from;
        }
        return prev;
    }

    protected Lifespan seekNext() {
        long prevSnap;
        if (this.done) {
            return null;
        }
        long curSnap = this.snap;
        TraceSnapshot fork = this.locateMostRecentFork(this.snap);
        long l = prevSnap = fork == null ? Long.MIN_VALUE : fork.getKey();
        if (fork == null) {
            this.done = true;
        } else {
            if (this.set.contains(prevSnap)) {
                this.done = true;
                return null;
            }
            this.snap = fork.getSchedule().getSnap();
        }
        Lifespan range = Lifespan.span(prevSnap, curSnap);
        this.set.add(range);
        return range;
    }
}

