/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import db.Transaction;
import ghidra.framework.data.DomainObjectEventQueues;
import ghidra.framework.data.DomainObjectFileListener;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventQueueID;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.options.Options;
import ghidra.framework.store.LockException;
import ghidra.program.database.IntRangeMap;
import ghidra.program.database.ProgramOverlayAddressSpace;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceDirectChangeListener;
import ghidra.trace.database.DBTraceTimeViewport;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceDefinedUnitsView;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.program.DBTraceProgramViewBookmarkManager;
import ghidra.trace.database.program.DBTraceProgramViewChangeSet;
import ghidra.trace.database.program.DBTraceProgramViewEquateTable;
import ghidra.trace.database.program.DBTraceProgramViewFunctionManager;
import ghidra.trace.database.program.DBTraceProgramViewListing;
import ghidra.trace.database.program.DBTraceProgramViewMemory;
import ghidra.trace.database.program.DBTraceProgramViewProgramContext;
import ghidra.trace.database.program.DBTraceProgramViewPropertyMapManager;
import ghidra.trace.database.program.DBTraceProgramViewReferenceManager;
import ghidra.trace.database.program.DBTraceProgramViewRegisters;
import ghidra.trace.database.program.DBTraceProgramViewSymbolTable;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.TypedEventDispatcher;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.model.data.TraceBasedDataTypeManager;
import ghidra.trace.model.listing.TraceCodeSpace;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.listing.TraceInstruction;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.symbol.TraceSymbolWithLifespan;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.InvalidNameException;
import ghidra.util.PairingIteratorMerger;
import ghidra.util.UniversalID;
import ghidra.util.datastruct.WeakValueHashMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.lang3.tuple.Pair;

public class DBTraceProgramView
implements TraceProgramView {
    public static final int TIME_INTERVAL = 100;
    public static final int BUF_SIZE = 1000;
    protected final DBTrace trace;
    protected final LanguageID languageID;
    protected final Language language;
    protected final CompilerSpec compilerSpec;
    protected final DomainObjectEventQueues eventQueues;
    protected EventTranslator eventTranslator;
    protected final AddressSet allAddresses = new AddressSet();
    protected final DBTraceProgramViewBookmarkManager bookmarkManager;
    protected final DBTraceProgramViewEquateTable equateTable;
    protected final DBTraceProgramViewFunctionManager functionManager;
    protected final DBTraceProgramViewListing listing;
    protected final DBTraceProgramViewMemory memory;
    protected final DBTraceProgramViewProgramContext programContext;
    protected final DBTraceProgramViewPropertyMapManager propertyMapManager;
    protected final DBTraceProgramViewReferenceManager referenceManager;
    protected final DBTraceProgramViewSymbolTable symbolTable;
    protected final DBTraceProgramViewChangeSet changes;
    protected final Map<TraceThread, DBTraceProgramViewRegisters> regViewsByThread;
    protected long snap;
    protected final DBTraceTimeViewport viewport;
    protected final Runnable viewportChangeListener = this::viewportChanged;
    Long versionTag = 0L;
    protected TraceTimeViewport.Occlusion<TraceMemoryRegion> regionOcclusion = new TraceTimeViewport.RangeQueryOcclusion<TraceMemoryRegion>(){

        @Override
        public Iterable<? extends TraceMemoryRegion> query(AddressRange range, Lifespan span) {
            return DBTraceProgramView.this.trace.getMemoryManager().getRegionsIntersecting(Lifespan.at(span.lmax()), range);
        }

        @Override
        public AddressRange range(TraceMemoryRegion r) {
            return r.getRange();
        }
    };

    public DBTraceProgramView(DBTrace trace, long snap, CompilerSpec compilerSpec) {
        for (AddressSpace space : trace.getBaseAddressFactory().getPhysicalSpaces()) {
            if (space.getType() == 7) continue;
            this.allAddresses.add(space.getMinAddress(), space.getMaxAddress());
        }
        this.trace = trace;
        this.snap = snap;
        this.languageID = compilerSpec.getLanguage().getLanguageID();
        this.language = compilerSpec.getLanguage();
        this.compilerSpec = compilerSpec;
        this.viewport = trace.createTimeViewport();
        this.viewport.setSnap(snap);
        this.eventQueues = new DomainObjectEventQueues((DomainObject)this, 100, trace.getLock());
        this.regViewsByThread = new WeakValueHashMap();
        this.bookmarkManager = new DBTraceProgramViewBookmarkManager(this);
        this.equateTable = new DBTraceProgramViewEquateTable(this);
        this.functionManager = new DBTraceProgramViewFunctionManager(this);
        this.listing = new DBTraceProgramViewListing(this);
        this.memory = new DBTraceProgramViewMemory(this);
        this.programContext = new DBTraceProgramViewProgramContext(this);
        this.propertyMapManager = new DBTraceProgramViewPropertyMapManager(this);
        this.referenceManager = new DBTraceProgramViewReferenceManager(this);
        this.symbolTable = new DBTraceProgramViewSymbolTable(this);
        this.changes = new DBTraceProgramViewChangeSet();
    }

    protected void viewportChanged() {
        this.eventQueues.fireEvent(new DomainObjectChangeRecord(4));
    }

    protected void fireEventAllViews(DomainObjectChangeRecord ev) {
        this.eventQueues.fireEvent(ev);
        for (DBTraceProgramViewRegisters regView : this.regViewsByThread.values()) {
            regView.eventQueues.fireEvent(ev);
        }
    }

    protected void fireObjectRestored() {
        this.fireEventAllViews(new DomainObjectChangeRecord(4));
    }

    public String toString() {
        return String.format("<%s on %s at snap=%d>", this.getClass().getSimpleName(), this.trace, this.snap);
    }

    @Override
    public DBTrace getTrace() {
        return this.trace;
    }

    @Override
    public long getSnap() {
        return this.snap;
    }

    @Override
    public TraceTimeViewport getViewport() {
        return this.viewport;
    }

    @Override
    public Long getMaxSnap() {
        return this.trace.getTimeManager().getMaxSnap();
    }

    public DBTraceProgramViewListing getListing() {
        return this.listing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBTraceProgramViewRegisters getViewRegisters(TraceThread thread, boolean createIfAbsent) {
        Map<TraceThread, DBTraceProgramViewRegisters> map = this.regViewsByThread;
        synchronized (map) {
            DBTraceProgramViewRegisters regView = this.regViewsByThread.get(thread);
            if (regView != null) {
                return regView;
            }
            assert (this.trace.getThreadManager().getAllThreads().contains(thread));
            DBTraceCodeSpace codeSpace = this.trace.getCodeManager().getCodeRegisterSpace(thread, createIfAbsent);
            if (codeSpace == null) {
                return null;
            }
            DBTraceMemorySpace memorySpace = this.trace.getMemoryManager().getMemoryRegisterSpace(thread, createIfAbsent);
            if (memorySpace == null) {
                return null;
            }
            regView = new DBTraceProgramViewRegisters(this, codeSpace, memorySpace);
            this.regViewsByThread.put(thread, regView);
            return regView;
        }
    }

    public AddressMap getAddressMap() {
        return null;
    }

    public TraceBasedDataTypeManager getDataTypeManager() {
        return this.trace.getDataTypeManager();
    }

    public FunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public ProgramUserData getProgramUserData() {
        return null;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public ExternalManager getExternalManager() {
        throw new UnsupportedOperationException("Traces do not support externals");
    }

    public EquateTable getEquateTable() {
        return this.equateTable;
    }

    @Override
    public DBTraceProgramViewMemory getMemory() {
        return this.memory;
    }

    public ReferenceManager getReferenceManager() {
        return this.referenceManager;
    }

    public BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    public int getDefaultPointerSize() {
        return this.language.getDefaultDataSpace().getPointerSize();
    }

    public String getCompiler() {
        return "unknown";
    }

    public void setCompiler(String compiler) {
        throw new UnsupportedOperationException();
    }

    public CategoryPath getPreferredRootNamespaceCategoryPath() {
        return null;
    }

    public void setPreferredRootNamespaceCategoryPath(String categoryPath) {
        throw new UnsupportedOperationException();
    }

    public String getExecutablePath() {
        return this.trace.getExecutablePath();
    }

    public void setExecutablePath(String path) {
        this.trace.setExecutablePath(path);
    }

    public String getExecutableFormat() {
        return "Trace";
    }

    public void setExecutableFormat(String format) {
        throw new UnsupportedOperationException();
    }

    public String getExecutableMD5() {
        return null;
    }

    public void setExecutableMD5(String md5) {
        throw new UnsupportedOperationException();
    }

    public String getExecutableSHA256() {
        return null;
    }

    public void setExecutableSHA256(String sha256) {
        throw new UnsupportedOperationException();
    }

    public Date getCreationDate() {
        return this.trace.getCreationDate();
    }

    public RelocationTable getRelocationTable() {
        return null;
    }

    public Language getLanguage() {
        return this.language;
    }

    public CompilerSpec getCompilerSpec() {
        return this.compilerSpec;
    }

    public LanguageID getLanguageID() {
        return this.languageID;
    }

    public PropertyMapManager getUsrPropertyManager() {
        return this.propertyMapManager;
    }

    public ProgramContext getProgramContext() {
        return this.programContext;
    }

    public Address getMinAddress() {
        return this.language.getAddressFactory().getAddressSet().getMinAddress();
    }

    public Address getMaxAddress() {
        return this.language.getAddressFactory().getAddressSet().getMaxAddress();
    }

    public ProgramChangeSet getChanges() {
        return this.changes;
    }

    public ProgramOverlayAddressSpace createOverlaySpace(String overlaySpaceName, AddressSpace baseSpace) throws IllegalStateException, DuplicateNameException, InvalidNameException, LockException {
        throw new UnsupportedOperationException();
    }

    public void renameOverlaySpace(String oldOverlaySpaceName, String newName) throws NotFoundException, InvalidNameException, DuplicateNameException, LockException {
        throw new UnsupportedOperationException();
    }

    public boolean removeOverlaySpace(String overlaySpaceName) throws LockException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public AddressFactory getAddressFactory() {
        return this.trace.getBaseAddressFactory();
    }

    public Address[] parseAddress(String addrStr) {
        return this.language.getAddressFactory().getAllAddresses(addrStr);
    }

    public Address[] parseAddress(String addrStr, boolean caseSensitive) {
        return this.language.getAddressFactory().getAllAddresses(addrStr, caseSensitive);
    }

    public void invalidate() {
        throw new UnsupportedOperationException();
    }

    public Register getRegister(String name) {
        return this.language.getRegister(name);
    }

    public Register getRegister(Address addr) {
        return this.language.getRegister(addr, 0);
    }

    public Register[] getRegisters(Address addr) {
        return this.language.getRegisters(addr);
    }

    public Register getRegister(Address addr, int size) {
        return this.language.getRegister(addr, size);
    }

    public Register getRegister(Varnode varnode) {
        return this.language.getRegister(varnode.getAddress(), varnode.getSize());
    }

    public Address getImageBase() {
        return this.language.getDefaultSpace().getMinAddress();
    }

    public void setImageBase(Address base, boolean commit) throws AddressOverflowException, LockException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void restoreImageBase() {
        throw new UnsupportedOperationException();
    }

    public void setLanguage(Language language, CompilerSpecID compilerSpecID, boolean forceRedisassembly, TaskMonitor monitor) throws IllegalStateException, IncompatibleLanguageException, LockException {
        throw new UnsupportedOperationException();
    }

    public Namespace getGlobalNamespace() {
        return this.trace.getSymbolManager().getGlobalNamespace();
    }

    public AddressSetPropertyMap createAddressSetPropertyMap(String name) throws DuplicateNameException {
        return null;
    }

    public IntRangeMap createIntRangeMap(String name) throws DuplicateNameException {
        return null;
    }

    public AddressSetPropertyMap getAddressSetPropertyMap(String name) {
        return null;
    }

    public IntRangeMap getIntRangeMap(String name) {
        return null;
    }

    public void deleteAddressSetPropertyMap(String name) {
    }

    public void deleteIntRangeMap(String name) {
    }

    public long getUniqueProgramID() {
        return 0L;
    }

    public Transaction openTransaction(String description) throws IllegalStateException {
        return this.trace.openTransaction(description);
    }

    public int startTransaction(String description) {
        return this.trace.startTransaction(description);
    }

    public int startTransaction(String description, AbortedTransactionListener listener) {
        return this.trace.startTransaction(description, listener);
    }

    public void endTransaction(int transactionID, boolean commit) {
        this.trace.endTransaction(transactionID, commit);
    }

    public TransactionInfo getCurrentTransactionInfo() {
        return this.trace.getCurrentTransactionInfo();
    }

    public boolean hasTerminatedTransaction() {
        return this.trace.hasTerminatedTransaction();
    }

    public DomainObject[] getSynchronizedDomainObjects() {
        return this.trace.getSynchronizedDomainObjects();
    }

    public void addSynchronizedDomainObject(DomainObject domainObj) throws LockException {
        this.trace.addSynchronizedDomainObject(domainObj);
    }

    public void releaseSynchronizedDomainObject() throws LockException {
        this.trace.releaseSynchronizedDomainObject();
    }

    public boolean isChanged() {
        return this.trace.isChanged();
    }

    public void setTemporary(boolean state) {
        this.trace.setTemporary(state);
    }

    public boolean isTemporary() {
        return this.trace.isTemporary();
    }

    public boolean isChangeable() {
        return this.trace.isChangeable();
    }

    public boolean canSave() {
        return this.trace.canSave();
    }

    public void save(String comment, TaskMonitor monitor) throws IOException, CancelledException {
        this.trace.save(comment, monitor);
    }

    public void saveToPackedFile(File outputFile, TaskMonitor monitor) throws IOException, CancelledException {
        this.trace.saveToPackedFile(outputFile, monitor);
    }

    protected synchronized EventTranslator getEventTranslator() {
        if (this.eventTranslator == null) {
            this.eventTranslator = new EventTranslator();
            this.trace.addDirectChangeListener(this.eventTranslator);
        }
        return this.eventTranslator;
    }

    public void addListener(DomainObjectListener dol) {
        this.getEventTranslator();
        this.eventQueues.addListener(dol);
    }

    public void removeListener(DomainObjectListener dol) {
        this.eventQueues.removeListener(dol);
    }

    public void addCloseListener(DomainObjectClosedListener listener) {
        this.trace.addCloseListener(listener);
    }

    public void removeCloseListener(DomainObjectClosedListener listener) {
        this.trace.removeCloseListener(listener);
    }

    public void addDomainFileListener(DomainObjectFileListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeDomainFileListener(DomainObjectFileListener listener) {
        throw new UnsupportedOperationException();
    }

    public EventQueueID createPrivateEventQueue(DomainObjectListener listener, int maxDelay) {
        this.getEventTranslator();
        return this.eventQueues.createPrivateEventQueue(listener, maxDelay);
    }

    public boolean removePrivateEventQueue(EventQueueID id) {
        return this.eventQueues.removePrivateEventQueue(id);
    }

    public String getDescription() {
        return this.trace.getDescription() + " (at snap " + this.snap + ")";
    }

    public String getName() {
        return this.trace.getName() + " (snap " + this.snap + ")";
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Cannot use program view to set the trace name");
    }

    public DomainFile getDomainFile() {
        return this.trace.getDomainFile();
    }

    public boolean addConsumer(Object consumer) {
        return this.trace.addConsumer(consumer);
    }

    public ArrayList<Object> getConsumerList() {
        return this.trace.getConsumerList();
    }

    public boolean isUsedBy(Object consumer) {
        return this.trace.isUsedBy(consumer);
    }

    public void release(Object consumer) {
        this.trace.release(consumer);
    }

    public void setEventsEnabled(boolean enabled) {
        this.eventQueues.setEventsEnabled(enabled);
    }

    public boolean isSendingEvents() {
        return this.eventQueues.isSendingEvents();
    }

    public void flushEvents() {
        this.eventQueues.flushEvents();
    }

    public void flushPrivateEventQueue(EventQueueID id) {
        this.eventQueues.flushPrivateEventQueue(id);
    }

    public boolean canLock() {
        return this.trace.canLock();
    }

    public boolean isLocked() {
        return this.trace.isLocked();
    }

    public boolean lock(String reason) {
        return this.trace.lock(reason);
    }

    public void forceLock(boolean rollback, String reason) {
        this.trace.forceLock(rollback, reason);
    }

    public void unlock() {
        this.trace.unlock();
    }

    public List<String> getOptionsNames() {
        return this.trace.getOptionsNames();
    }

    public Options getOptions(String propertyListName) {
        return this.trace.getOptions(propertyListName);
    }

    public boolean isClosed() {
        return this.trace.isClosed();
    }

    public boolean hasExclusiveAccess() {
        return this.trace.hasExclusiveAccess();
    }

    public Map<String, String> getMetadata() {
        return this.trace.getMetadata();
    }

    public long getModificationNumber() {
        return this.trace.getModificationNumber();
    }

    public boolean canUndo() {
        return this.trace.canUndo();
    }

    public boolean canRedo() {
        return this.trace.canRedo();
    }

    public void clearUndo() {
        this.trace.clearUndo();
    }

    public void undo() throws IOException {
        this.trace.undo();
    }

    public void redo() throws IOException {
        this.trace.redo();
    }

    public String getUndoName() {
        return this.trace.getUndoName();
    }

    public String getRedoName() {
        return this.trace.getRedoName();
    }

    public List<String> getAllUndoNames() {
        return this.trace.getAllUndoNames();
    }

    public List<String> getAllRedoNames() {
        return this.trace.getAllRedoNames();
    }

    public void addTransactionListener(TransactionListener listener) {
        this.trace.addTransactionListener(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.trace.removeTransactionListener(listener);
    }

    public void updateMemoryAddRegionBlock(TraceMemoryRegion region) {
        if (!this.isRegionVisible(region)) {
            return;
        }
        this.memory.updateAddRegionBlock(region);
    }

    public void updateMemoryChangeRegionBlockName(TraceMemoryRegion region) {
        if (!this.isRegionVisible(region)) {
            return;
        }
        this.memory.updateChangeRegionBlockName(region);
    }

    public void updateMemoryChangeRegionBlockFlags(TraceMemoryRegion region, Lifespan lifespan) {
        if (!this.isRegionVisible(region, lifespan)) {
            return;
        }
        this.memory.updateChangeRegionBlockFlags(region);
    }

    public void updateMemoryChangeRegionBlockRange(TraceMemoryRegion region, AddressRange oldRange, AddressRange newRange) {
        if (!this.isRegionVisible(region)) {
            return;
        }
        this.memory.updateChangeRegionBlockRange(region, oldRange, newRange);
    }

    public void updateMemoryChangeRegionBlockLifespan(TraceMemoryRegion region, Lifespan oldLifespan, Lifespan newLifespan) {
        boolean inOld = this.isRegionVisible(region, oldLifespan);
        boolean inNew = this.isRegionVisible(region, newLifespan);
        if (inOld && !inNew) {
            this.memory.updateDeleteRegionBlock(region);
        }
        if (!inOld && inNew) {
            this.memory.updateAddRegionBlock(region);
        }
    }

    public void updateMemoryDeleteRegionBlock(TraceMemoryRegion region) {
        if (!this.isRegionVisible(region)) {
            return;
        }
        this.memory.updateAddRegionBlock(region);
    }

    public void updateMemoryAddSpaceBlock(AddressSpace space) {
        this.memory.updateAddSpaceBlock(space);
    }

    public void updateMemoryDeleteSpaceBlock(AddressSpace space) {
        this.memory.updateDeleteSpaceBlock(space);
    }

    public void updateMemoryRefreshBlocks() {
        this.memory.updateRefreshBlocks();
    }

    public void updateBytesChanged(AddressRange range) {
        this.memory.updateBytesChanged(range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DomainObjectEventQueues getEventQueues(TraceAddressSpace space) {
        DBTraceProgramViewRegisters viewRegisters;
        TraceThread thread;
        TraceThread traceThread = thread = space == null ? null : space.getThread();
        if (thread == null) {
            return this.eventQueues;
        }
        Map<TraceThread, DBTraceProgramViewRegisters> map = this.regViewsByThread;
        synchronized (map) {
            viewRegisters = this.regViewsByThread.get(thread);
        }
        return viewRegisters == null ? null : viewRegisters.eventQueues;
    }

    protected DomainObjectEventQueues isVisible(TraceAddressSpace space, TraceAddressSnapRange range) {
        return this.viewport.containsAnyUpper(range.getLifespan()) ? this.getEventQueues(space) : null;
    }

    protected boolean isBookmarkVisible(TraceBookmark bm, Lifespan lifespan) {
        return this.viewport.containsAnyUpper(lifespan);
    }

    protected DomainObjectEventQueues isBookmarkVisible(TraceAddressSpace space, TraceBookmark bm) {
        return this.isBookmarkVisible(bm, bm.getLifespan()) ? this.getEventQueues(space) : null;
    }

    protected boolean bytesDifferForSet(byte[] b1, byte[] b2, AddressSetView set) {
        Address min = set.getMinAddress();
        for (AddressRange rng : set) {
            int end;
            int beg = (int)rng.getMinAddress().subtract(min);
            if (Arrays.equals(b1, beg, end = beg + (int)rng.getLength(), b2, beg, end)) continue;
            return true;
        }
        return false;
    }

    protected TraceTimeViewport.Occlusion<TraceCodeUnit> getCodeOcclusion(final TraceAddressSpace space) {
        return new TraceTimeViewport.RangeQueryOcclusion<TraceCodeUnit>(){
            final DBTraceCodeSpace codeSpace;
            final DBTraceMemorySpace memSpace;
            final DBTraceDefinedUnitsView definedUnits;
            {
                this.codeSpace = (DBTraceCodeSpace)DBTraceProgramView.this.trace.getCodeManager().get(space, false);
                this.memSpace = (DBTraceMemorySpace)DBTraceProgramView.this.trace.getMemoryManager().get(space, false);
                this.definedUnits = this.codeSpace == null ? null : this.codeSpace.definedUnits();
            }

            @Override
            public boolean occluded(TraceCodeUnit cu, AddressRange range, Lifespan span) {
                byte[] cuBytes;
                if (cu == null) {
                    return TraceTimeViewport.RangeQueryOcclusion.super.occluded(cu, range, span);
                }
                AddressSetView known = this.memSpace.getAddressesWithState(span, s -> s == TraceMemoryState.KNOWN);
                if (!known.intersects(range.getMinAddress(), range.getMaxAddress())) {
                    return TraceTimeViewport.RangeQueryOcclusion.super.occluded(cu, range, span);
                }
                byte[] memBytes = new byte[cu.getLength()];
                this.memSpace.getBytes(span.lmax(), cu.getMinAddress(), ByteBuffer.wrap(memBytes));
                try {
                    cuBytes = cu.getBytes();
                }
                catch (MemoryAccessException e) {
                    throw new AssertionError((Object)e);
                }
                IntersectionAddressSetView intersectKnown = new IntersectionAddressSetView((AddressSetView)new AddressSet(range), known);
                if (DBTraceProgramView.this.bytesDifferForSet(memBytes, cuBytes, (AddressSetView)intersectKnown)) {
                    return true;
                }
                return TraceTimeViewport.RangeQueryOcclusion.super.occluded(cu, range, span);
            }

            @Override
            public Iterable<? extends TraceCodeUnit> query(AddressRange range, Lifespan span) {
                return this.definedUnits == null ? Collections.emptyList() : this.definedUnits.get(span.lmax(), range, true);
            }

            @Override
            public AddressRange range(TraceCodeUnit cu) {
                return cu.getRange();
            }
        };
    }

    protected <T extends TraceCodeUnit> T getTopCode(Address address, BiFunction<TraceCodeSpace, Long, T> codeFunc) {
        DBTraceCodeSpace codeSpace = this.trace.getCodeManager().getCodeSpace(address.getAddressSpace(), false);
        if (codeSpace == null) {
            return null;
        }
        return (T)this.viewport.getTop(s -> {
            TraceCodeUnit t = (TraceCodeUnit)codeFunc.apply(codeSpace, (Long)s);
            if (t != null && this.isCodeVisible(t, t.getLifespan())) {
                return t;
            }
            return null;
        });
    }

    protected boolean isCodeVisible(TraceCodeUnit cu, Lifespan lifespan) {
        return this.viewport.isCompletelyVisible(cu.getRange(), lifespan, cu, this.getCodeOcclusion(cu.getTraceSpace()));
    }

    protected boolean isCodeVisible(TraceAddressSpace space, TraceAddressSnapRange range) {
        return this.viewport.isCompletelyVisible(range.getRange(), range.getLifespan(), null, this.getCodeOcclusion(space));
    }

    protected DomainObjectEventQueues isCodeVisible(TraceAddressSpace space, TraceCodeUnit cu) {
        if (!this.isCodeVisible(cu, cu.getLifespan())) {
            return null;
        }
        return this.getEventQueues(space);
    }

    protected boolean isSymbolWithLifespanVisible(TraceSymbolWithLifespan symbol, Lifespan lifespan) {
        return this.viewport.containsAnyUpper(lifespan);
    }

    protected DomainObjectEventQueues isSymbolVisible(TraceAddressSpace space, TraceSymbol symbol) {
        DomainObjectEventQueues queues = this.getEventQueues(space);
        if (queues == null) {
            return null;
        }
        if (!(symbol instanceof TraceSymbolWithLifespan)) {
            return queues;
        }
        TraceSymbolWithLifespan symWl = (TraceSymbolWithLifespan)symbol;
        return this.isSymbolWithLifespanVisible(symWl, symWl.getLifespan()) ? queues : null;
    }

    protected DomainObjectEventQueues isBytesVisible(TraceAddressSpace space, TraceAddressSnapRange range) {
        DomainObjectEventQueues queues = this.getEventQueues(space);
        if (queues == null) {
            return null;
        }
        if (!this.viewport.containsAnyUpper(range.getLifespan())) {
            return null;
        }
        return queues;
    }

    protected boolean isRegionVisible(TraceMemoryRegion reg) {
        return this.isRegionVisible(reg, reg.getLifespan());
    }

    protected boolean isRegionVisible(TraceMemoryRegion reg, Lifespan lifespan) {
        return this.viewport.isCompletelyVisible(reg.getRange(), lifespan, reg, this.regionOcclusion);
    }

    protected class EventTranslator
    extends TypedEventDispatcher
    implements DBTraceDirectChangeListener {
        public EventTranslator() {
            this.listenForUntyped(1, this::eventPassthrough);
            this.listenForUntyped(2, this::eventPassthrough);
            this.listenForUntyped(3, this::eventPassthrough);
            this.listenForUntyped(4, this::objectRestored);
            this.listenForUntyped(6, this::eventPassthrough);
            this.listenForUntyped(8, this::eventPassthrough);
            this.listenFor(Trace.TraceBookmarkChangeType.TYPE_ADDED, this::bookmarkTypeAdded);
            this.listenFor(Trace.TraceBookmarkChangeType.ADDED, this::bookmarkAdded);
            this.listenFor(Trace.TraceBookmarkChangeType.CHANGED, this::bookmarkChanged);
            this.listenFor(Trace.TraceBookmarkChangeType.LIFESPAN_CHANGED, this::bookmarkLifespanChanged);
            this.listenFor(Trace.TraceBookmarkChangeType.DELETED, this::bookmarkDeleted);
            this.listenFor(Trace.TraceCategoryChangeType.ADDED, this::categoryAdded);
            this.listenFor(Trace.TraceCategoryChangeType.MOVED, this::categoryMoved);
            this.listenFor(Trace.TraceCategoryChangeType.RENAMED, this::categoryRenamed);
            this.listenFor(Trace.TraceCategoryChangeType.DELETED, this::categoryDeleted);
            this.listenFor(Trace.TraceCodeChangeType.ADDED, this::codeAdded);
            this.listenFor(Trace.TraceCodeChangeType.LIFESPAN_CHANGED, this::codeLifespanChanged);
            this.listenFor(Trace.TraceCodeChangeType.REMOVED, this::codeRemoved);
            this.listenFor(Trace.TraceCodeChangeType.FRAGMENT_CHANGED, this::codeFragmentChanged);
            this.listenFor(Trace.TraceCodeChangeType.DATA_TYPE_REPLACED, this::codeDataTypeReplaced);
            this.listenFor(Trace.TraceCodeChangeType.DATA_TYPE_SETTINGS_CHANGED, this::codeDataTypeSettingsChanged);
            this.listenFor(Trace.TraceCommentChangeType.EOL_CHANGED, this::commentEolChanged);
            this.listenFor(Trace.TraceCommentChangeType.PLATE_CHANGED, this::commentPlateChanged);
            this.listenFor(Trace.TraceCommentChangeType.POST_CHANGED, this::commentPostChanged);
            this.listenFor(Trace.TraceCommentChangeType.PRE_CHANGED, this::commentPreChanged);
            this.listenFor(Trace.TraceCommentChangeType.REPEATABLE_CHANGED, this::commentRepeatableChanged);
            this.listenFor(Trace.TraceCompositeDataChangeType.ADDED, this::compositeDataAdded);
            this.listenFor(Trace.TraceCompositeDataChangeType.LIFESPAN_CHANGED, this::compositeLifespanChanged);
            this.listenFor(Trace.TraceCompositeDataChangeType.REMOVED, this::compositeDataRemoved);
            this.listenFor(Trace.TraceDataTypeChangeType.ADDED, this::dataTypeAdded);
            this.listenFor(Trace.TraceDataTypeChangeType.CHANGED, this::dataTypeChanged);
            this.listenFor(Trace.TraceDataTypeChangeType.REPLACED, this::dataTypeReplaced);
            this.listenFor(Trace.TraceDataTypeChangeType.MOVED, this::dataTypeMoved);
            this.listenFor(Trace.TraceDataTypeChangeType.RENAMED, this::dataTypeRenamed);
            this.listenFor(Trace.TraceDataTypeChangeType.DELETED, this::dataTypeDeleted);
            this.listenFor(Trace.TraceInstructionChangeType.LENGTH_OVERRIDE_CHANGED, this::instructionLengthOverrideChanged);
            this.listenFor(Trace.TraceInstructionChangeType.FLOW_OVERRIDE_CHANGED, this::instructionFlowOverrideChanged);
            this.listenFor(Trace.TraceInstructionChangeType.FALL_THROUGH_OVERRIDE_CHANGED, this::instructionFallThroughChanged);
            this.listenFor(Trace.TraceMemoryBytesChangeType.CHANGED, this::memoryBytesChanged);
            this.listenFor(Trace.TraceMemoryRegionChangeType.ADDED, this::memoryRegionAdded);
            this.listenFor(Trace.TraceMemoryRegionChangeType.CHANGED, this::memoryRegionChanged);
            this.listenFor(Trace.TraceMemoryRegionChangeType.LIFESPAN_CHANGED, this::memoryRegionLifespanChanged);
            this.listenFor(Trace.TraceMemoryRegionChangeType.DELETED, this::memoryRegionDeleted);
            this.listenFor(Trace.TraceSourceArchiveChangeType.ADDED, this::sourceArchiveAdded);
            this.listenFor(Trace.TraceSourceArchiveChangeType.CHANGED, this::sourceArchiveChanged);
            this.listenFor(Trace.TraceSymbolChangeType.ADDED, this::symbolAdded);
            this.listenFor(Trace.TraceSymbolChangeType.SOURCE_CHANGED, this::symbolSourceChanged);
            this.listenFor(Trace.TraceSymbolChangeType.SET_AS_PRIMARY, this::symbolSetAsPrimary);
            this.listenFor(Trace.TraceSymbolChangeType.RENAMED, this::symbolRenamed);
            this.listenFor(Trace.TraceSymbolChangeType.PARENT_CHANGED, this::symbolParentChanged);
            this.listenFor(Trace.TraceSymbolChangeType.ASSOCIATION_ADDED, this::symbolAssociationAdded);
            this.listenFor(Trace.TraceSymbolChangeType.ASSOCIATION_REMOVED, this::symbolAssociationRemoved);
            this.listenFor(Trace.TraceSymbolChangeType.ADDRESS_CHANGED, this::symbolAddressChanged);
            this.listenFor(Trace.TraceSymbolChangeType.LIFESPAN_CHANGED, this::symbolLifespanChanged);
            this.listenFor(Trace.TraceSymbolChangeType.DELETED, this::symbolDeleted);
        }

        @Override
        public void changed(DomainObjectChangeRecord event) {
            this.handleChangeRecord(event);
        }

        private void eventPassthrough(DomainObjectChangeRecord rec) {
            DBTraceProgramView.this.fireEventAllViews(rec);
        }

        private void objectRestored(DomainObjectChangeRecord rec) {
            Long l = DBTraceProgramView.this.versionTag;
            DBTraceProgramView.this.versionTag = DBTraceProgramView.this.versionTag + 1L;
            DBTraceProgramView.this.fireEventAllViews(rec);
        }

        private void bookmarkTypeAdded(TraceBookmarkType type) {
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(120, null, null, (Object)type, null, null));
        }

        private void bookmarkAdded(TraceAddressSpace space, TraceBookmark bm) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isBookmarkVisible(space, bm);
            if (queues == null) {
                return;
            }
            this.fireBookmarkAdded(queues, bm);
        }

        protected void fireBookmarkAdded(DomainObjectEventQueues queues, TraceBookmark bm) {
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(122, bm.getAddress(), bm.getAddress(), (Object)bm, null, null));
        }

        private void bookmarkChanged(TraceAddressSpace space, TraceBookmark bm) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isBookmarkVisible(space, bm);
            if (queues == null) {
                return;
            }
            this.fireBookmarkChanged(queues, bm);
        }

        protected void fireBookmarkChanged(DomainObjectEventQueues queues, TraceBookmark bm) {
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(124, bm.getAddress(), bm.getAddress(), (Object)bm, null, null));
        }

        private void bookmarkLifespanChanged(TraceAddressSpace space, TraceBookmark bm, Lifespan oldSpan, Lifespan newSpan) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.getEventQueues(space);
            if (queues == null) {
                return;
            }
            boolean inOld = DBTraceProgramView.this.isBookmarkVisible(bm, oldSpan);
            boolean inNew = DBTraceProgramView.this.isBookmarkVisible(bm, newSpan);
            if (inOld && !inNew) {
                this.fireBookmarkRemoved(queues, bm);
            }
            if (!inOld && inNew) {
                this.fireBookmarkAdded(queues, bm);
            }
        }

        private void bookmarkDeleted(TraceAddressSpace space, TraceBookmark bm) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isBookmarkVisible(space, bm);
            if (queues == null) {
                return;
            }
            this.fireBookmarkRemoved(queues, bm);
        }

        protected void fireBookmarkRemoved(DomainObjectEventQueues queues, TraceBookmark bm) {
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(123, bm.getAddress(), bm.getAddress(), (Object)bm, null, null));
        }

        private void categoryAdded(long id, Category oldIsNull, Category added) {
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(100, null, null, null, (Object)oldIsNull, (Object)added));
        }

        private void categoryMoved(long id, CategoryPath oldPath, CategoryPath newPath) {
            Category category = DBTraceProgramView.this.getDataTypeManager().getCategory(id);
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(103, null, null, null, (Object)oldPath, (Object)category));
        }

        private void categoryRenamed(long id, String oldName, String newName) {
            Category category = DBTraceProgramView.this.getDataTypeManager().getCategory(id);
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(102, null, null, null, (Object)oldName, (Object)category));
        }

        private void categoryDeleted(long id, CategoryPath deleted, CategoryPath newIsNull) {
            Category parent = DBTraceProgramView.this.getDataTypeManager().getCategory(deleted.getParent());
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(101, null, null, null, (Object)parent, (Object)deleted.getName()));
        }

        private void codeAdded(TraceAddressSpace space, TraceAddressSnapRange range, TraceCodeUnit oldIsNull, TraceCodeUnit added) {
            DomainObjectEventQueues queues;
            DomainObjectEventQueues domainObjectEventQueues = queues = DBTraceProgramView.this.isCodeVisible(space, range) ? DBTraceProgramView.this.getEventQueues(space) : null;
            if (queues == null) {
                return;
            }
            this.fireCodeAdded(queues, range.getX1(), range.getX2());
        }

        protected void fireCodeAdded(DomainObjectEventQueues queues, Address min, Address max) {
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(30, min, max, null, null, null));
        }

        private void codeLifespanChanged(TraceAddressSpace space, TraceCodeUnit unit, Lifespan oldSpan, Lifespan newSpan) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.getEventQueues(space);
            if (queues == null) {
                return;
            }
            boolean inOld = DBTraceProgramView.this.isCodeVisible(unit, oldSpan);
            boolean inNew = DBTraceProgramView.this.isCodeVisible(unit, newSpan);
            if (inOld && !inNew) {
                this.fireCodeRemoved(queues, unit.getMinAddress(), unit.getMaxAddress(), unit);
            }
            if (!inOld && inNew) {
                this.fireCodeAdded(queues, unit.getMinAddress(), unit.getMaxAddress());
            }
        }

        private void codeRemoved(TraceAddressSpace space, TraceAddressSnapRange range, TraceCodeUnit removed, TraceCodeUnit newIsNull) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isCodeVisible(space, removed);
            if (queues == null) {
                return;
            }
            this.fireCodeRemoved(queues, range.getX1(), range.getX2(), removed);
        }

        protected void fireCodeRemoved(DomainObjectEventQueues queues, Address min, Address max, TraceCodeUnit removed) {
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(31, min, max, null, (Object)removed, null));
        }

        private void codeFragmentChanged(TraceAddressSpace space, TraceAddressSnapRange range, ProgramFragment oldFragment, ProgramFragment newFragment) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isVisible(space, range);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(32, null, null, null, (Object)range.getX1(), (Object)range.getX2()));
        }

        private void codeDataTypeReplaced(TraceAddressSpace space, TraceAddressSnapRange range, Long oldDataTypeID, Long newDataTypeID) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isVisible(space, range);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(110, range.getX1(), range.getX2(), null, null, null));
        }

        private void codeDataTypeSettingsChanged(TraceAddressSpace space, TraceAddressSnapRange range) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isVisible(space, range);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(109, range.getX1(), range.getX1(), null, null, null));
        }

        private void commentChanged(int docrType, TraceAddressSpace space, TraceAddressSnapRange range, String oldValue, String newValue) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isVisible(space, range);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(docrType, range.getX1(), range.getX2(), null, (Object)oldValue, (Object)newValue));
        }

        private void commentEolChanged(TraceAddressSpace space, TraceAddressSnapRange range, String oldValue, String newValue) {
            this.commentChanged(90, space, range, oldValue, newValue);
        }

        private void commentPlateChanged(TraceAddressSpace space, TraceAddressSnapRange range, String oldValue, String newValue) {
            this.commentChanged(95, space, range, oldValue, newValue);
        }

        private void commentPostChanged(TraceAddressSpace space, TraceAddressSnapRange range, String oldValue, String newValue) {
            this.commentChanged(92, space, range, oldValue, newValue);
        }

        private void commentPreChanged(TraceAddressSpace space, TraceAddressSnapRange range, String oldValue, String newValue) {
            this.commentChanged(91, space, range, oldValue, newValue);
        }

        private void commentRepeatableChanged(TraceAddressSpace space, TraceAddressSnapRange range, String oldValue, String newValue) {
            this.commentChanged(96, space, range, oldValue, newValue);
        }

        private void compositeDataAdded(TraceAddressSpace space, TraceAddressSnapRange range, TraceData oldIsNull, TraceData added) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isCodeVisible(space, added);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(33, added.getMinAddress(), added.getMaxAddress(), null, null, (Object)added));
        }

        private void compositeLifespanChanged(TraceAddressSpace space, TraceData data, Lifespan oldSpan, Lifespan newSpan) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.getEventQueues(space);
            if (queues == null) {
                return;
            }
            boolean inOld = DBTraceProgramView.this.isCodeVisible(data, oldSpan);
            boolean inNew = DBTraceProgramView.this.isCodeVisible(data, newSpan);
            if (inOld && !inNew) {
                queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(34, data.getMinAddress(), data.getMaxAddress(), null, (Object)data, null));
            }
            if (!inOld && inNew) {
                queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(33, data.getMinAddress(), data.getMaxAddress(), null, null, (Object)data));
            }
        }

        private void compositeDataRemoved(TraceAddressSpace space, TraceAddressSnapRange range, TraceData removed, TraceData newIsNull) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isCodeVisible(space, removed);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(34, removed.getMinAddress(), removed.getMaxAddress(), null, (Object)removed, null));
        }

        private void dataTypeAdded(long id, DataType oldIsNull, DataType added) {
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(104, null, null, null, (Object)oldIsNull, (Object)added));
        }

        private void dataTypeChanged(long id, DataType oldIsNull, DataType changed) {
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(108, null, null, null, (Object)oldIsNull, (Object)changed));
        }

        private void dataTypeReplaced(long id, DataTypePath oldPath, DataTypePath newPath) {
            DataType newType = DBTraceProgramView.this.getDataTypeManager().getDataType(id);
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(110, null, null, null, (Object)newPath, (Object)newType));
        }

        private void dataTypeMoved(long id, DataTypePath oldPath, DataTypePath newPath) {
            Category oldCategory = DBTraceProgramView.this.getDataTypeManager().getCategory(oldPath.getCategoryPath());
            DataType dataType = DBTraceProgramView.this.getDataTypeManager().getDataType(id);
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(107, null, null, null, (Object)oldCategory, (Object)dataType));
        }

        private void dataTypeRenamed(long id, String oldName, String newName) {
            DataType dataType = DBTraceProgramView.this.getDataTypeManager().getDataType(id);
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(106, null, null, null, (Object)oldName, (Object)dataType));
        }

        private void dataTypeDeleted(long id, DataTypePath oldPath, DataTypePath newIsNull) {
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(105, null, null, null, (Object)oldPath, (Object)newIsNull));
        }

        private void instructionFlowOverrideChanged(TraceAddressSpace space, TraceInstruction instruction, FlowOverride oldOverride, FlowOverride newOverride) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isCodeVisible(space, instruction);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(163, instruction.getMinAddress(), instruction.getMinAddress(), null, null, null));
        }

        private void instructionFallThroughChanged(TraceAddressSpace space, TraceInstruction instruction, boolean oldFallThrough, boolean newFallThrough) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isCodeVisible(space, instruction);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(162, instruction.getMinAddress(), instruction.getMinAddress(), null, null, null));
        }

        private void instructionLengthOverrideChanged(TraceAddressSpace space, TraceInstruction instruction, int oldLengthOverride, int newLengthOverride) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isCodeVisible(space, instruction);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(164, instruction.getMinAddress(), instruction.getMinAddress(), null, null, null));
        }

        private void memoryBytesChanged(TraceAddressSpace space, TraceAddressSnapRange range, byte[] oldIsNull, byte[] bytes) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isBytesVisible(space, range);
            if (queues == null) {
                return;
            }
            this.fireMemoryBytesChanged(queues, range);
        }

        protected void fireMemoryBytesChanged(DomainObjectEventQueues queues, TraceAddressSnapRange range) {
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(26, range.getX1(), range.getX2(), null, null, null));
        }

        private void memoryRegionAdded(TraceAddressSpace space, TraceMemoryRegion region) {
            if (!DBTraceProgramView.this.isRegionVisible(region)) {
                return;
            }
            DBTraceProgramView.this.eventQueues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(20, region.getMinAddress(), region.getMaxAddress(), null, null, null));
            DBTraceProgramView.this.eventQueues.fireEvent(new DomainObjectChangeRecord(4));
        }

        private void memoryRegionChanged(TraceAddressSpace space, TraceMemoryRegion region) {
            if (!DBTraceProgramView.this.isRegionVisible(region)) {
                return;
            }
            DBTraceProgramView.this.eventQueues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(22, region.getMinAddress(), region.getMaxAddress(), null, null, null));
            DBTraceProgramView.this.eventQueues.fireEvent(new DomainObjectChangeRecord(4));
        }

        private void memoryRegionLifespanChanged(TraceAddressSpace space, TraceMemoryRegion region, Lifespan oldSpan, Lifespan newSpan) {
            boolean inOld = DBTraceProgramView.this.isRegionVisible(region, oldSpan);
            boolean inNew = DBTraceProgramView.this.isRegionVisible(region, newSpan);
            if (inOld && !inNew) {
                DBTraceProgramView.this.eventQueues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(21, region.getMinAddress(), region.getMaxAddress(), null, null, null));
                DBTraceProgramView.this.eventQueues.fireEvent(new DomainObjectChangeRecord(4));
            }
            if (!inOld && inNew) {
                DBTraceProgramView.this.eventQueues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(20, region.getMinAddress(), region.getMaxAddress(), null, null, null));
                DBTraceProgramView.this.eventQueues.fireEvent(new DomainObjectChangeRecord(4));
            }
        }

        private void memoryRegionDeleted(TraceAddressSpace space, TraceMemoryRegion region) {
            DBTraceProgramView.this.listing.fragmentsByRegion.remove(region);
            if (!DBTraceProgramView.this.isRegionVisible(region)) {
                return;
            }
            DBTraceProgramView.this.eventQueues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(21, region.getMinAddress(), region.getMaxAddress(), null, null, null));
            DBTraceProgramView.this.eventQueues.fireEvent(new DomainObjectChangeRecord(4));
        }

        private void sourceArchiveAdded(UniversalID id) {
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(111, null, null, (Object)id, null, null));
        }

        private void sourceArchiveChanged(UniversalID id) {
            DBTraceProgramView.this.fireEventAllViews((DomainObjectChangeRecord)new ProgramChangeRecord(112, null, null, (Object)id, null, null));
        }

        private void symbolAdded(TraceAddressSpace space, TraceSymbol symbol) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isSymbolVisible(space, symbol);
            if (queues == null) {
                return;
            }
            this.fireSymbolAdded(queues, symbol);
        }

        public void fireSymbolAdded(DomainObjectEventQueues queues, TraceSymbol symbol) {
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(40, symbol.getAddress(), symbol.getAddress(), null, null, (Object)symbol));
        }

        private void symbolSourceChanged(TraceAddressSpace space, TraceSymbol symbol) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isSymbolVisible(space, symbol);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(42, symbol.getAddress(), symbol.getAddress(), (Object)symbol, null, null));
        }

        private void symbolSetAsPrimary(TraceAddressSpace space, TraceSymbol symbol, TraceSymbol oldPrimary, TraceSymbol newPrimary) {
            DomainObjectEventQueues newQueues = DBTraceProgramView.this.isSymbolVisible(space, symbol);
            if (newQueues == null) {
                return;
            }
            DomainObjectEventQueues oldQueues = DBTraceProgramView.this.isSymbolVisible(space, oldPrimary);
            if (oldPrimary != null && oldQueues == null) {
                oldPrimary = null;
            }
            assert (oldQueues == newQueues || oldQueues == null);
            newQueues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(45, symbol.getAddress(), symbol.getAddress(), null, (Object)oldPrimary, (Object)newPrimary));
        }

        private void symbolRenamed(TraceAddressSpace space, TraceSymbol symbol, String oldName, String newName) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isSymbolVisible(space, symbol);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(46, symbol.getAddress(), symbol.getAddress(), (Object)symbol, (Object)oldName, (Object)newName));
        }

        private void symbolParentChanged(TraceAddressSpace space, TraceSymbol symbol, TraceNamespaceSymbol oldParent, TraceNamespaceSymbol newParent) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isSymbolVisible(space, symbol);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(49, symbol.getAddress(), symbol.getAddress(), (Object)symbol, (Object)oldParent, (Object)newParent));
        }

        private void symbolAssociationAdded(TraceAddressSpace space, TraceSymbol symbol, TraceReference oldRefIsNull, TraceReference newRef) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isSymbolVisible(space, symbol);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(50, newRef.getFromAddress(), newRef.getFromAddress(), (Object)newRef, null, (Object)symbol));
        }

        private void symbolAssociationRemoved(TraceAddressSpace space, TraceSymbol symbol, TraceReference oldRef, TraceReference newRefIsNull) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isSymbolVisible(space, symbol);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(51, oldRef.getFromAddress(), oldRef.getFromAddress(), (Object)oldRef, (Object)symbol, null));
        }

        private void symbolAddressChanged(TraceAddressSpace space, TraceSymbol symbol, Address oldAddress, Address newAddress) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isSymbolVisible(space, symbol);
            if (queues == null) {
                return;
            }
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(53, oldAddress, oldAddress, (Object)symbol, (Object)oldAddress, (Object)newAddress));
        }

        private void symbolLifespanChanged(TraceAddressSpace space, TraceSymbolWithLifespan symbol, Lifespan oldSpan, Lifespan newSpan) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.getEventQueues(space);
            if (queues == null) {
                return;
            }
            boolean inOld = DBTraceProgramView.this.isSymbolWithLifespanVisible(symbol, oldSpan);
            boolean inNew = DBTraceProgramView.this.isSymbolWithLifespanVisible(symbol, newSpan);
            if (inOld && !inNew) {
                this.fireSymbolRemoved(queues, symbol);
            }
            if (!inOld && inNew) {
                this.fireSymbolAdded(queues, symbol);
            }
        }

        private void symbolDeleted(TraceAddressSpace space, TraceSymbol symbol) {
            DomainObjectEventQueues queues = DBTraceProgramView.this.isSymbolVisible(space, symbol);
            if (queues == null) {
                return;
            }
            this.fireSymbolRemoved(queues, symbol);
        }

        protected void fireSymbolRemoved(DomainObjectEventQueues queues, TraceSymbol symbol) {
            queues.fireEvent((DomainObjectChangeRecord)new ProgramChangeRecord(41, symbol.getAddress(), symbol.getAddress(), (Object)symbol, (Object)symbol.getName(), (Object)symbol.getID()));
        }
    }

    protected static class OverlappingAddressRangeKeyIteratorMerger<T>
    extends PairingIteratorMerger<Map.Entry<AddressRange, T>, Map.Entry<AddressRange, T>, Map.Entry<AddressRange, T>> {
        protected static <T> Iterable<Pair<Map.Entry<AddressRange, T>, Map.Entry<AddressRange, T>>> iter(final Iterable<Map.Entry<AddressRange, T>> left, final Iterable<Map.Entry<AddressRange, T>> right) {
            return new Iterable<Pair<Map.Entry<AddressRange, T>, Map.Entry<AddressRange, T>>>(){

                @Override
                public Iterator<Pair<Map.Entry<AddressRange, T>, Map.Entry<AddressRange, T>>> iterator() {
                    return new OverlappingAddressRangeKeyIteratorMerger(left.iterator(), right.iterator());
                }
            };
        }

        public OverlappingAddressRangeKeyIteratorMerger(Iterator<Map.Entry<AddressRange, T>> left, Iterator<Map.Entry<AddressRange, T>> right) {
            super(left, right);
        }

        public int compare(Map.Entry<AddressRange, T> o1, Map.Entry<AddressRange, T> o2) {
            return o1.getKey().getMaxAddress().compareTo((Object)o2.getKey().getMaxAddress());
        }

        public boolean test(Map.Entry<AddressRange, T> t, Map.Entry<AddressRange, T> u) {
            return t.getKey().intersects(u.getKey());
        }
    }
}

