/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import db.DBRecord;
import ghidra.program.database.code.InstructionDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InvalidPrototype;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ParserContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownContextException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemBufferMixin;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.StackReference;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.context.DBTraceRegisterContextManager;
import ghidra.trace.database.context.DBTraceRegisterContextSpace;
import ghidra.trace.database.guest.DBTraceGuestPlatform;
import ghidra.trace.database.guest.InternalTracePlatform;
import ghidra.trace.database.listing.AbstractDBTraceCodeUnit;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.symbol.DBTraceReference;
import ghidra.trace.database.symbol.DBTraceReferenceSpace;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceInstruction;
import ghidra.trace.util.InstructionAdapterFromPrototype;
import ghidra.trace.util.MethodProtector;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceInstruction
extends AbstractDBTraceCodeUnit<DBTraceInstruction>
implements TraceInstruction,
InstructionAdapterFromPrototype,
InstructionContext {
    private static final Address[] EMPTY_ADDRESS_ARRAY = new Address[0];
    private static final String TABLE_NAME = "Instructions";
    private static final byte FALLTHROUGH_SET_MASK = 1;
    private static final byte FALLTHROUGH_CLEAR_MASK = -2;
    private static final byte FLOW_OVERRIDE_SET_MASK = 14;
    private static final byte FLOW_OVERRIDE_CLEAR_MASK = -15;
    private static final int FLOW_OVERRIDE_SHIFT = 1;
    private static final byte LENGTH_OVERRIDE_SET_MASK = 112;
    private static final byte LENGTH_OVERRIDE_CLEAR_MASK = -113;
    private static final int LENGTH_OVERRIDE_SHIFT = 4;
    static final String PLATFORM_COLUMN_NAME = "Platform";
    static final String PROTOTYPE_COLUMN_NAME = "Prototype";
    static final String FLAGS_COLUMN_NAME = "Flags";
    @DBAnnotatedColumn(value="Platform")
    static DBObjectColumn PLATFORM_COLUMN;
    @DBAnnotatedColumn(value="Prototype")
    static DBObjectColumn PROTOTYPE_COLUMN;
    @DBAnnotatedColumn(value="Flags")
    static DBObjectColumn FLAGS_COLUMN;
    @DBAnnotatedField(column="Platform")
    private int platformKey;
    @DBAnnotatedField(column="Prototype")
    private int prototypeKey;
    @DBAnnotatedField(column="Flags")
    private byte flags;
    private final MethodProtector clearingFallThroughs = new MethodProtector();
    protected InstructionPrototype prototype;
    protected FlowOverride flowOverride;
    protected int lengthOverride;
    protected ParserContext parserContext;
    protected InternalTracePlatform platform;
    protected InstructionContext instructionContext;
    protected MemBuffer memBuffer;

    static String tableName(AddressSpace space, long threadKey) {
        return DBTraceUtils.tableName(TABLE_NAME, space, threadKey, 0);
    }

    public DBTraceInstruction(DBTraceCodeSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceInstruction, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(space, tree, store, record);
    }

    protected void doSetPlatformMapping(InternalTracePlatform platform) {
        this.platform = platform;
        if (platform.isHost()) {
            this.instructionContext = this;
            this.memBuffer = this;
        } else {
            this.instructionContext = new GuestInstructionContext();
            this.memBuffer = new GuestMemBuffer();
        }
    }

    protected void set(InternalTracePlatform platform, InstructionPrototype prototype, ProcessorContextView context, int forcedLengthOverride) {
        this.platformKey = platform.getIntKey();
        DBTraceGuestPlatform.DBTraceGuestLanguage languageEntry = platform.getLanguageEntry();
        this.prototypeKey = (int)this.space.manager.findOrRecordPrototype(prototype, languageEntry, (MemBuffer)this, context).getKey();
        this.flowOverride = FlowOverride.NONE;
        this.lengthOverride = 0;
        this.update(PLATFORM_COLUMN, PROTOTYPE_COLUMN, FLAGS_COLUMN);
        if (forcedLengthOverride != 0) {
            this.updateLengthOverride(forcedLengthOverride);
        }
        this.doSetPlatformMapping(platform);
        this.prototype = prototype;
    }

    @Override
    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.platform = this.space.manager.platformManager.getPlatformByKey(this.platformKey);
        if (this.platform == null) {
            throw new IOException("Instruction table is corrupt. Missing platform: " + this.platformKey);
        }
        this.prototype = this.space.manager.getPrototypeByKey(this.prototypeKey);
        if (this.prototype == null) {
            Msg.error((Object)this, (Object)("Instruction table is corrupt for address " + this.getMinAddress() + ". Missing prototype " + this.prototypeKey));
            this.prototype = new InvalidPrototype(this.getTrace().getBaseLanguage());
        }
        this.flowOverride = FlowOverride.values()[(this.flags & 0xE) >> 1];
        this.lengthOverride = (this.flags & 0x70) >> 4;
        if (this.lengthOverride != 0 && this.lengthOverride < this.prototype.getLength()) {
            Address minAddr = this.getMinAddress();
            Address newEndAddr = minAddr.add((long)(this.lengthOverride - 1));
            this.doSetRange((AddressRange)new AddressRangeImpl(minAddr, newEndAddr));
        }
        this.doSetPlatformMapping(this.platform);
    }

    protected void setRecordValue(DBTraceInstruction value) {
    }

    protected DBTraceInstruction getRecordValue() {
        return this;
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.space.instructionMapSpace.deleteData(this);
        }
        this.space.instructions.unitRemoved(this);
    }

    @Override
    public void setEndSnap(long endSnap) {
        Lifespan oldSpan;
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            oldSpan = this.getLifespan();
            super.setEndSnap(endSnap);
        }
        this.space.instructions.unitSpanChanged(oldSpan, this);
    }

    @Override
    public TracePlatform getPlatform() {
        return this.platform;
    }

    @Override
    public Language getLanguage() {
        return this.prototype.getLanguage();
    }

    public String toString() {
        return this.getFullString();
    }

    @Override
    public TraceInstruction getNext() {
        return (TraceInstruction)this.space.instructions.getAfter(this.getStartSnap(), this.getX2());
    }

    @Override
    public TraceInstruction getPrevious() {
        return (TraceInstruction)this.space.instructions.getBefore(this.getStartSnap(), this.getX1());
    }

    public InstructionPrototype getPrototype() {
        return this.prototype;
    }

    int getPrototypeKey() {
        return this.prototypeKey;
    }

    @Override
    public int getOperandType(int opIndex) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            int optype = InstructionAdapterFromPrototype.super.getOperandType(opIndex);
            DBTraceReference ref = this.getPrimaryReference(opIndex);
            if (ref instanceof StackReference || ref instanceof ExternalReference || ref != null && ref.getToAddress().isMemoryAddress()) {
                optype |= 0x2000;
            }
            int n = optype;
            return n;
        }
    }

    @Override
    public Address getAddress(int opIndex) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            DBTraceReferenceSpace refSpace = (DBTraceReferenceSpace)this.space.referenceManager.get(this.space, false);
            if (refSpace == null) {
                Address address = InstructionAdapterFromPrototype.super.getAddress(opIndex);
                return address;
            }
            DBTraceReference ref = refSpace.getPrimaryReferenceFrom(this.getStartSnap(), this.getX1(), opIndex);
            if (ref == null) {
                Address address = InstructionAdapterFromPrototype.super.getAddress(opIndex);
                return address;
            }
            Address address = ref.getToAddress();
            return address;
        }
    }

    @Override
    public Address getDefaultFallThrough() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Address fallThrough = this.getGuestDefaultFallThrough();
            Address address = this.platform.mapGuestToHost(fallThrough);
            return address;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Address getGuestDefaultFallThrough() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            FlowType flowType = this.getFlowType();
            if (flowType.hasFallthrough()) {
                try {
                    Address address = this.instructionContext.getAddress().addNoWrap((long)this.prototype.getFallThroughOffset(this.instructionContext));
                    return address;
                }
                catch (AddressOverflowException e) {
                    Address address;
                    block11: {
                        address = null;
                        if (hold == null) break block11;
                        hold.close();
                    }
                    return address;
                }
            }
            Address address = null;
            return address;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public Address getFallThrough() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            this.checkIsValid();
            if (this.isFallThroughOverridden()) {
                DBTraceReferenceSpace refSpace = (DBTraceReferenceSpace)this.space.referenceManager.get(this.space, false);
                if (refSpace == null) {
                    Address address = null;
                    return address;
                }
                for (DBTraceReference dBTraceReference : refSpace.getReferencesFrom(this.getStartSnap(), this.getAddress())) {
                    if (!dBTraceReference.getReferenceType().isFallthrough()) continue;
                    Address address = dBTraceReference.getToAddress();
                    return address;
                }
                Iterator<? extends DBTraceReference> iterator = null;
                return iterator;
            }
            if (this.lengthOverride != 0 && this.getFlowType().hasFallthrough()) {
                Address address = this.getMinAddress().add((long)this.lengthOverride);
                return address;
            }
            Address address = this.getDefaultFallThrough();
            return address;
        }
    }

    public Address getFallFrom() {
        LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());
        try {
            this.checkIsValid();
            DBTraceInstruction ins = this;
            int alignment = Math.min(1, this.getLanguage().getInstructionAlignment());
            try {
                while ((ins = (DBTraceInstruction)this.space.instructions().getContaining(this.getStartSnap(), ins.getMinAddress().subtractNoWrap((long)alignment))) != null && ins.isInDelaySlot() && ins.getLanguage() == this.getLanguage()) {
                }
            }
            catch (AddressOverflowException e) {
                Address address = null;
                if (hold != null) {
                    hold.close();
                }
                return address;
            }
            if (ins == null) {
                Address e = null;
                return e;
            }
            if (ins.getLanguage() != this.getLanguage()) {
                Address e = null;
                return e;
            }
            if (this.isInDelaySlot()) {
                Address e = ins.getMinAddress();
                return e;
            }
            Address fallAddr = ins.getFallThrough();
            if (fallAddr != null && fallAddr.equals((Object)this.getAddress())) {
                Address address = ins.getMinAddress();
                return address;
            }
            Address address = null;
            return address;
        }
        finally {
            if (hold != null) {
                try {
                    hold.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public Address[] getFlows() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Address[] addressArray;
            DBTraceReferenceSpace refSpace = (DBTraceReferenceSpace)this.space.referenceManager.get(this.space, false);
            if (refSpace == null) {
                Address[] addressArray2 = EMPTY_ADDRESS_ARRAY;
                return addressArray2;
            }
            Collection<? extends DBTraceReference> refs = refSpace.getFlowReferencesFrom(this.getStartSnap(), this.getAddress());
            if (refs.isEmpty()) {
                Address[] addressArray3 = EMPTY_ADDRESS_ARRAY;
                return addressArray3;
            }
            ArrayList<Address> list = new ArrayList<Address>();
            for (DBTraceReference dBTraceReference : refs) {
                if (dBTraceReference.getReferenceType().isIndirect()) continue;
                list.add(dBTraceReference.getToAddress());
            }
            if (this.flowOverride == FlowOverride.RETURN && list.size() == 1) {
                addressArray = EMPTY_ADDRESS_ARRAY;
                return addressArray;
            }
            if (this.lengthOverride != 0 && this.getFlowType().hasFallthrough()) {
                list.add(this.getMinAddress().add((long)this.lengthOverride));
            }
            addressArray = list.toArray(new Address[list.size()]);
            return addressArray;
        }
    }

    @Override
    public Address[] getDefaultFlows() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Address[] addressArray;
            Address[] guestFlows = this.getGuestDefaultFlows();
            if (this.platform.isHost() || guestFlows == null) {
                Address[] addressArray2 = guestFlows;
                return addressArray2;
            }
            ArrayList<Address> hostFlows = new ArrayList<Address>();
            for (Address g : guestFlows) {
                Address h = this.platform.mapGuestToHost(g);
                if (h == null) continue;
                hostFlows.add(h);
            }
            if (hostFlows.isEmpty()) {
                addressArray = EMPTY_ADDRESS_ARRAY;
                return addressArray;
            }
            addressArray = hostFlows.toArray(new Address[hostFlows.size()]);
            return addressArray;
        }
    }

    @Override
    public Address[] getGuestDefaultFlows() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Address[] flows = this.prototype.getFlows(this.instructionContext);
            if (this.flowOverride == FlowOverride.RETURN && flows.length == 1) {
                Address[] addressArray = EMPTY_ADDRESS_ARRAY;
                return addressArray;
            }
            Address[] addressArray = flows;
            return addressArray;
        }
    }

    public FlowType getFlowType() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            FlowType flowType = FlowOverride.getModifiedFlowType((FlowType)this.prototype.getFlowType(this.instructionContext), (FlowOverride)this.flowOverride);
            return flowType;
        }
    }

    public boolean isFallthrough() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            if (!this.getFlowType().isFallthrough()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.hasFallthrough();
            return bl;
        }
    }

    public boolean hasFallthrough() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            this.checkIsValid();
            if (this.isFallThroughOverridden()) {
                boolean bl = this.getFallThrough() != null;
                return bl;
            }
            boolean bl = this.getFlowType().hasFallthrough();
            return bl;
        }
    }

    public FlowOverride getFlowOverride() {
        return this.flowOverride;
    }

    private boolean isSameFlowType(FlowType origFlowType, RefType referenceType) {
        if (origFlowType.isCall() && referenceType.isCall()) {
            return true;
        }
        if (origFlowType.isJump() && referenceType.isJump()) {
            return true;
        }
        return origFlowType.isTerminal() && referenceType.isTerminal();
    }

    public void setFlowOverride(FlowOverride flowOverride) {
        FlowOverride oldFlowOverride = this.flowOverride;
        try (LockHold hold = this.space.trace.lockWrite();){
            this.checkDeleted();
            if (this.flowOverride == flowOverride) {
                return;
            }
            FlowType origFlowType = this.getFlowType();
            this.flags = (byte)(this.flags & 0xFFFFFFF1);
            this.flags = (byte)(this.flags | flowOverride.ordinal() << 1 & 0xE);
            this.flowOverride = flowOverride;
            this.update(FLAGS_COLUMN);
            DBTraceReferenceSpace refSpace = (DBTraceReferenceSpace)this.space.referenceManager.get(this.space, true);
            for (DBTraceReference dBTraceReference : refSpace.getFlowReferencesFrom(this.getStartSnap(), this.getX1())) {
                RefType refType;
                if (!this.isSameFlowType(origFlowType, dBTraceReference.getReferenceType()) || !(refType = RefTypeFactory.getDefaultMemoryRefType((CodeUnit)this, (int)dBTraceReference.getOperandIndex(), (Address)dBTraceReference.getToAddress(), (boolean)true)).isFlow() || dBTraceReference.getReferenceType() == refType) continue;
                dBTraceReference.setReferenceType(refType);
            }
        }
        this.space.trace.setChanged(new TraceChangeRecord<DBTraceInstruction, FlowOverride>(Trace.TraceInstructionChangeType.FLOW_OVERRIDE_CHANGED, this.space, this, oldFlowOverride, flowOverride));
    }

    public void setLengthOverride(int length) throws CodeUnitInsertionException {
        int oldLengthOverride = this.lengthOverride;
        try (LockHold hold = this.space.trace.lockWrite();){
            int newLength;
            this.checkDeleted();
            InstructionPrototype proto = this.getPrototype();
            length = InstructionDB.checkLengthOverride((int)length, (InstructionPrototype)proto);
            if (length == this.lengthOverride) {
                return;
            }
            int n = newLength = length != 0 ? length : proto.getLength();
            if (newLength > this.getLength()) {
                Address minAddr = this.getMinAddress();
                Address newEndAddr = minAddr.add((long)(newLength - 1));
                ImmutableTraceAddressSnapRange tasr = new ImmutableTraceAddressSnapRange((AddressRange)new AddressRangeImpl(minAddr.next(), newEndAddr), this.getLifespan());
                for (AbstractDBTraceCodeUnit cu : this.space.definedUnits.getIntersecting(tasr)) {
                    if (cu == this) continue;
                    throw new CodeUnitInsertionException("Length override of " + newLength + " conflicts with code unit at " + cu.getMinAddress() + ", lifespan=" + cu.getLifespan());
                }
            }
            this.updateLengthOverride(length);
        }
        this.space.trace.setChanged(new TraceChangeRecord<DBTraceInstruction, Integer>(Trace.TraceInstructionChangeType.LENGTH_OVERRIDE_CHANGED, this.space, this, oldLengthOverride, length));
    }

    private void updateLengthOverride(int length) {
        this.flags = (byte)(this.flags & 0xFFFFFF8F);
        this.flags = (byte)(this.flags | length << 4);
        this.lengthOverride = length;
        this.update(FLAGS_COLUMN);
        int newLength = length != 0 ? length : this.getPrototype().getLength();
        Address minAddr = this.getMinAddress();
        Address newEndAddr = minAddr.add((long)(newLength - 1));
        this.doSetRange((AddressRange)new AddressRangeImpl(minAddr, newEndAddr));
    }

    public boolean isLengthOverridden() {
        return this.lengthOverride != 0;
    }

    @Override
    public int getLength() {
        if (this.lengthOverride != 0) {
            return this.lengthOverride;
        }
        return super.getLength();
    }

    public int getParsedLength() {
        if (this.lengthOverride == 0) {
            return super.getLength();
        }
        return this.getPrototype().getLength();
    }

    public byte[] getParsedBytes() throws MemoryAccessException {
        if (!this.isLengthOverridden()) {
            return this.getBytes();
        }
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            this.checkIsValid();
            int len = this.getPrototype().getLength();
            byte[] b = new byte[len];
            Address addr = this.getAddress();
            if (len != this.getMemory().getBytes(addr, b)) {
                throw new MemoryAccessException("Failed to read " + len + " bytes at " + addr);
            }
            byte[] byArray = b;
            return byArray;
        }
    }

    public void setFallThrough(Address fallThrough) {
        try (LockHold hold = this.space.trace.lockWrite();){
            this.checkDeleted();
            Address defaultFallThrough = this.prototype.getFallThrough((InstructionContext)this);
            if (Objects.equals(fallThrough, defaultFallThrough)) {
                this.clearFallThroughOverride();
                return;
            }
            if (fallThrough == null) {
                this.clearFallThroughRefs(null);
                this.setFallThroughOverridden(true);
            } else {
                DBTraceReferenceSpace refSpace = (DBTraceReferenceSpace)this.space.referenceManager.get(this.space, true);
                refSpace.addMemoryReference(this.lifespan, this.getAddress(), fallThrough, (RefType)RefType.FALL_THROUGH, SourceType.USER_DEFINED, -1);
                this.setFallThroughOverridden(true);
            }
        }
    }

    public void clearFallThroughOverride() {
        try (LockHold hold = this.space.trace.lockWrite();){
            this.checkDeleted();
            if (!this.isFallThroughOverridden()) {
                return;
            }
            this.clearFallThroughRefs(null);
            this.setFallThroughOverridden(false);
        }
    }

    private void clearFallThroughRefs(DBTraceReference keepFallThroughRef) {
        this.clearingFallThroughs.take(() -> {
            DBTraceReferenceSpace refSpace = (DBTraceReferenceSpace)this.space.referenceManager.get(this.space, false);
            if (refSpace == null) {
                return;
            }
            for (DBTraceReference dBTraceReference : refSpace.getReferencesFrom(this.getStartSnap(), this.getX1())) {
                if (dBTraceReference.getReferenceType() != RefType.FALL_THROUGH || dBTraceReference.equals(keepFallThroughRef)) continue;
                dBTraceReference.delete();
            }
        });
    }

    void fallThroughChanged(DBTraceReference fallThroughRef) {
        this.clearingFallThroughs.avoid(() -> {
            this.clearFallThroughRefs(fallThroughRef);
            this.setFallThroughOverridden(fallThroughRef != null && fallThroughRef.getReferenceType() == RefType.FALL_THROUGH);
        });
    }

    private void setFallThroughOverridden(boolean overridden) {
        if (this.isFallThroughOverridden() == overridden) {
            return;
        }
        this.flags = overridden ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
        this.update(FLAGS_COLUMN);
        this.space.trace.setChanged(new TraceChangeRecord<DBTraceInstruction, Boolean>(Trace.TraceInstructionChangeType.FALL_THROUGH_OVERRIDE_CHANGED, this.space, this, !overridden, overridden));
    }

    public boolean isFallThroughOverridden() {
        return (this.flags & 1) != 0;
    }

    public InstructionContext getInstructionContext() {
        return this.instructionContext;
    }

    public void setValue(Register register, BigInteger value) throws ContextChangeException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            DBTraceRegisterContextSpace ctxSpace = (DBTraceRegisterContextSpace)this.space.trace.getRegisterContextManager().get(this.space, true);
            ctxSpace.setValue(this.getLanguage(), new RegisterValue(register, value), this.lifespan, this.range);
        }
    }

    public void setRegisterValue(RegisterValue value) throws ContextChangeException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            DBTraceRegisterContextSpace ctxSpace = (DBTraceRegisterContextSpace)this.space.trace.getRegisterContextManager().get(this.space, true);
            ctxSpace.setValue(this.getLanguage(), value, this.lifespan, this.range);
        }
    }

    public void clearRegister(Register register) throws ContextChangeException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            DBTraceRegisterContextSpace ctxSpace = (DBTraceRegisterContextSpace)this.space.trace.getRegisterContextManager().get(this.space, false);
            if (ctxSpace == null) {
                return;
            }
            ctxSpace.removeValue(this.getLanguage(), register, this.lifespan, this.range);
        }
    }

    public Register getBaseContextRegister() {
        return this.getLanguage().getContextBaseRegister();
    }

    public List<Register> getRegisters() {
        return this.getLanguage().getRegisters();
    }

    public Register getRegister(String name) {
        return this.getLanguage().getRegister(name);
    }

    public BigInteger getValue(Register register, boolean signed) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            DBTraceRegisterContextManager manager = this.space.trace.getRegisterContextManager();
            Address guestAddress = this.getPlatform().mapHostToGuest(this.getMinAddress());
            RegisterValue rv = manager.getValueWithDefault(this.getPlatform(), register, this.getStartSnap(), guestAddress);
            if (rv == null) {
                BigInteger bigInteger = null;
                return bigInteger;
            }
            BigInteger bigInteger = signed ? rv.getSignedValue() : rv.getUnsignedValue();
            return bigInteger;
        }
    }

    public RegisterValue getRegisterValue(Register register) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            DBTraceRegisterContextManager manager = this.space.trace.getRegisterContextManager();
            Address guestAddress = this.getPlatform().mapHostToGuest(this.getMinAddress());
            RegisterValue registerValue = manager.getValueWithDefault(this.getPlatform(), register, this.getStartSnap(), guestAddress);
            return registerValue;
        }
    }

    public boolean hasValue(Register register) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            DBTraceRegisterContextSpace ctxSpace = (DBTraceRegisterContextSpace)this.space.trace.getRegisterContextManager().get(this.space, false);
            if (ctxSpace == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = ctxSpace.hasRegisterValueInAddressRange(this.getLanguage(), register, this.getStartSnap(), this.range);
            return bl;
        }
    }

    public ProcessorContextView getProcessorContext() {
        return this;
    }

    public MemBuffer getMemBuffer() {
        return this.memBuffer;
    }

    public ParserContext getParserContext() throws MemoryAccessException {
        return this.parserContext == null ? (this.parserContext = this.prototype.getParserContext(this.getMemBuffer(), this.getProcessorContext())) : this.parserContext;
    }

    public ParserContext getParserContext(Address instructionAddress) throws UnknownContextException, MemoryAccessException {
        if (this.getAddress().equals((Object)instructionAddress)) {
            return this.getParserContext();
        }
        DBTraceInstruction instruction = (DBTraceInstruction)this.space.manager.instructions.getAt(this.getStartSnap(), instructionAddress);
        if (instruction == null) {
            throw new UnknownContextException("Trace does not contain referenced instruction: (" + this.getStartSnap() + "," + instructionAddress + ")");
        }
        InstructionPrototype otherProto = instruction.getPrototype();
        if (!otherProto.getClass().equals(this.prototype.getClass())) {
            throw new UnknownContextException("Instruction has incompatible prototype at: (" + this.getStartSnap() + "," + instructionAddress + ")");
        }
        return instruction.getParserContext();
    }

    protected class GuestInstructionContext
    implements InstructionContext {
        protected GuestInstructionContext() {
        }

        public Address getAddress() {
            return DBTraceInstruction.this.platform.mapHostToGuest(DBTraceInstruction.this.getX1());
        }

        public ProcessorContextView getProcessorContext() {
            return DBTraceInstruction.this.getProcessorContext();
        }

        public MemBuffer getMemBuffer() {
            return DBTraceInstruction.this.getMemBuffer();
        }

        public ParserContext getParserContext() throws MemoryAccessException {
            return DBTraceInstruction.this.getParserContext();
        }

        public ParserContext getParserContext(Address instructionAddress) throws UnknownContextException, MemoryAccessException {
            return DBTraceInstruction.this.getParserContext(instructionAddress);
        }
    }

    protected class GuestMemBuffer
    implements MemBufferMixin {
        protected GuestMemBuffer() {
        }

        public Address getAddress() {
            return DBTraceInstruction.this.platform.mapHostToGuest(DBTraceInstruction.this.getX1());
        }

        public Memory getMemory() {
            return null;
        }

        public boolean isBigEndian() {
            return DBTraceInstruction.this.platform.getLanguage().isBigEndian();
        }

        public int getBytes(ByteBuffer buffer, int addressOffset) {
            return DBTraceInstruction.this.getBytes(buffer, addressOffset);
        }
    }
}

