/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbIdentifiers;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.formats.gfilesystem.RefdInputStream;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.SameDirSymbolStore;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolFileLocation;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInputStream;

public class ContainerFileSymbolServer
implements SymbolServer {
    private final FileSystemService fsService;
    private final FSRLRoot fsFSRL;
    private final String subdir;

    public ContainerFileSymbolServer(FSRL programFSRL) {
        this.fsFSRL = programFSRL.getFS();
        this.subdir = FilenameUtils.getFullPath((String)programFSRL.getPath());
        this.fsService = FileSystemService.getInstance();
    }

    @Override
    public String getName() {
        return ".";
    }

    @Override
    public String getDescriptiveName() {
        return SameDirSymbolStore.PROGRAMS_IMPORT_LOCATION_DESCRIPTION_STR + " - " + this.fsFSRL.toPrettyFullpathString();
    }

    @Override
    public boolean isValid(TaskMonitor monitor) {
        return true;
    }

    @Override
    public boolean exists(String filename, TaskMonitor monitor) {
        boolean bl;
        block8: {
            RefdFile file = this.getFile(filename, monitor);
            try {
                boolean bl2 = bl = file != null;
                if (file == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            file.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefdFile getFile(String filename, TaskMonitor monitor) {
        try (FileSystemRef fsRef = this.fsService.getFilesystem(this.fsFSRL, monitor);){
            if (fsRef == null) return null;
            GFileSystem fs = fsRef.getFilesystem();
            String path = FSUtilities.appendPath((String[])new String[]{this.subdir, filename});
            GFile file = fs.lookup(path);
            if (file == null) return null;
            if (file.isDirectory()) return null;
            RefdFile refdFile = new RefdFile(fsRef.dup(), file);
            return refdFile;
        }
        catch (CancelledException | IOException throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SymbolFileLocation> find(SymbolFileInfo fileInfo, Set<FindOption> findOptions, TaskMonitor monitor) {
        block14: {
            try (RefdFile fref = this.getFile(fileInfo.getName(), monitor);){
                List<SymbolFileLocation> list;
                block15: {
                    if (fref == null) break block14;
                    GFile file = fref.file;
                    GFileSystem fs = file.getFilesystem();
                    AbstractPdb pdb = PdbParser.parse(fs.getByteProvider(file, monitor), new PdbReaderOptions(), monitor);
                    try {
                        PdbIdentifiers pdbIdent = pdb.getIdentifiers();
                        SymbolFileInfo foundInfo = SymbolFileInfo.fromPdbIdentifiers(file.getName(), pdbIdent);
                        list = List.of(new SymbolFileLocation(fileInfo.getName(), this, foundInfo));
                        if (pdb == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (pdb != null) {
                            try {
                                pdb.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pdb.close();
                }
                return list;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return List.of();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SymbolServerInputStream getFileStream(String filename, TaskMonitor monitor) throws IOException {
        try (RefdFile fref = this.getFile(filename, monitor);){
            if (fref == null) throw new IOException();
            GFile file = fref.file;
            InputStream is = file.getFilesystem().getInputStream(file, monitor);
            is = new RefdInputStream(fref.fsRef.dup(), is);
            SymbolServerInputStream symbolServerInputStream = new SymbolServerInputStream(is, file.getLength());
            return symbolServerInputStream;
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        throw new IOException();
    }

    @Override
    public String getFileLocation(String filename) {
        return this.fsFSRL.withPath(filename).toPrettyFullpathString();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public String toString() {
        return "ContainerFileSymbolServer: [ fsrl: %s ]".formatted(this.fsFSRL);
    }
}

