/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractPublicMsSymbol;
import ghidra.app.util.datatype.microsoft.GuidDataType;
import ghidra.app.util.datatype.microsoft.GuidUtil;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class PublicSymbolApplier
extends MsSymbolApplier {
    private AbstractPublicMsSymbol symbol;
    private Address symbolAddress = null;
    private Address existingSymbolAddress = null;

    public PublicSymbolApplier(DefaultPdbApplicator applicator, MsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof AbstractPublicMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (AbstractPublicMsSymbol)abstractSymbol;
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }

    @Override
    void apply() throws CancelledException, PdbException {
        this.symbolAddress = this.applicator.getAddress(this.symbol);
        String name = this.symbol.getName();
        if (this.applicator.isInvalidAddress(this.symbolAddress, name)) {
            return;
        }
        this.existingSymbolAddress = this.applicator.witnessSymbolNameAtAddress(this.getName(), this.symbolAddress);
        if (!this.symbolAddress.equals((Object)this.existingSymbolAddress)) {
            this.applicator.createSymbol(this.symbolAddress, name, true);
            Program program = this.applicator.getProgram();
            if (GuidUtil.isGuidLabel((Program)program, (Address)this.symbolAddress, (String)name)) {
                try {
                    DataUtilities.createData((Program)program, (Address)this.symbolAddress, (DataType)new GuidDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
                }
                catch (CodeUnitInsertionException codeUnitInsertionException) {
                    // empty catch block
                }
            }
        }
    }

    Address getAddress() {
        return this.symbolAddress;
    }

    Address getAddressRemappedThroughPublicSymbol() {
        return this.existingSymbolAddress != null ? this.existingSymbolAddress : this.symbolAddress;
    }

    String getName() {
        return this.symbol.getName();
    }
}

