/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumerateMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractFieldListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractNestedTypeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FieldListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;
import java.util.List;

public class FieldListTypeApplier
extends MsTypeApplier {
    static FieldListTypeApplier getFieldListApplierSpecial(DefaultPdbApplicator applicator, RecordNumber recordNumber) throws PdbException {
        if (recordNumber.isNoType()) {
            return (FieldListTypeApplier)applicator.getTypeApplier(4611);
        }
        MsTypeApplier applier = applicator.getTypeApplier(recordNumber);
        if (applier instanceof FieldListTypeApplier) {
            FieldListTypeApplier fieldListApplier = (FieldListTypeApplier)applier;
            return fieldListApplier;
        }
        throw new PdbException("Problem creating field list");
    }

    public FieldListTypeApplier(DefaultPdbApplicator applicator) throws IllegalArgumentException {
        super(applicator);
    }

    @Override
    DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        return null;
    }

    FieldLists getFieldLists(RecordNumber recordNumber) throws PdbException {
        PrimitiveMsType primitive;
        AbstractMsType type = this.applicator.getPdb().getTypeRecord(recordNumber);
        if (type instanceof PrimitiveMsType && (primitive = (PrimitiveMsType)type).isNoType()) {
            return new FieldLists(new ArrayList<AbstractMsType>(), new ArrayList<AbstractMsType>(), new ArrayList<AbstractMemberMsType>(), new ArrayList<AbstractVirtualFunctionTablePointerMsType>(), new ArrayList<AbstractMsType>(), new ArrayList<AbstractNestedTypeMsType>(), new ArrayList<AbstractEnumerateMsType>());
        }
        if (type instanceof AbstractFieldListMsType) {
            AbstractFieldListMsType fieldListType = (AbstractFieldListMsType)type;
            return this.getFieldLists(fieldListType);
        }
        throw new PdbException(type.getClass().getSimpleName() + " seen where " + FieldListMsType.class.getSimpleName() + " expected for record number " + recordNumber);
    }

    FieldLists getFieldLists(AbstractFieldListMsType fieldListType) throws PdbException {
        ArrayList<AbstractMsType> bases = new ArrayList<AbstractMsType>();
        ArrayList<AbstractMsType> members = new ArrayList<AbstractMsType>();
        ArrayList<AbstractMsType> methods = new ArrayList<AbstractMsType>();
        for (MsTypeField typeIterated : fieldListType.getBaseClassList()) {
            bases.add((AbstractMsType)((Object)typeIterated));
        }
        for (MsTypeField typeIterated : fieldListType.getMemberList()) {
            members.add((AbstractMsType)((Object)typeIterated));
        }
        for (MsTypeField typeIterated : fieldListType.getMethodList()) {
            methods.add((AbstractMsType)((Object)typeIterated));
        }
        ArrayList<AbstractMemberMsType> nonstaticMembers = new ArrayList<AbstractMemberMsType>(fieldListType.getNonStaticMembers());
        ArrayList<AbstractVirtualFunctionTablePointerMsType> vftPtrs = new ArrayList<AbstractVirtualFunctionTablePointerMsType>(fieldListType.getVftPointers());
        ArrayList<AbstractNestedTypeMsType> nestedTypes = new ArrayList<AbstractNestedTypeMsType>(fieldListType.getNestedTypes());
        ArrayList<AbstractEnumerateMsType> enumerates = new ArrayList<AbstractEnumerateMsType>(fieldListType.getEnumerates());
        for (AbstractIndexMsType indexType : fieldListType.getIndexList()) {
            RecordNumber subRecordNumber = indexType.getReferencedRecordNumber();
            MsTypeApplier referencedTypeApplier = this.applicator.getTypeApplier(indexType.getReferencedRecordNumber());
            if (referencedTypeApplier instanceof FieldListTypeApplier) {
                FieldListTypeApplier fieldListApplier = (FieldListTypeApplier)referencedTypeApplier;
                FieldLists lists = fieldListApplier.getFieldLists(subRecordNumber);
                bases.addAll(lists.bases());
                members.addAll(lists.members());
                methods.addAll(lists.methods());
                nonstaticMembers.addAll(lists.nonstaticMembers());
                vftPtrs.addAll(lists.vftPtrs());
                nestedTypes.addAll(lists.nestedTypes());
                enumerates.addAll(lists.enumerates());
                continue;
            }
            this.pdbLogAndInfoMessage(this, "referenceTypeApplier is not FieldListTypeApplier");
        }
        return new FieldLists(bases, members, nonstaticMembers, vftPtrs, methods, nestedTypes, enumerates);
    }

    record FieldLists(List<AbstractMsType> bases, List<AbstractMsType> members, List<AbstractMemberMsType> nonstaticMembers, List<AbstractVirtualFunctionTablePointerMsType> vftPtrs, List<AbstractMsType> methods, List<AbstractNestedTypeMsType> nestedTypes, List<AbstractEnumerateMsType> enumerates) {
    }
}

