/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class ImageFunctionEntry {
    private long startingAddress;
    private long endingAddress;
    private long endOfPrologueAddress;

    public long getStartingAddress() {
        return this.startingAddress;
    }

    public long getEndingAddress() {
        return this.endingAddress;
    }

    public long getEndOfPrologueAddress() {
        return this.endOfPrologueAddress;
    }

    public void deserialize(PdbByteReader reader) throws PdbException {
        this.startingAddress = reader.parseUnsignedIntVal();
        this.endingAddress = reader.parseUnsignedIntVal();
        this.endOfPrologueAddress = reader.parseUnsignedIntVal();
    }

    public String toString() {
        return this.dump();
    }

    String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("ImageFunctionEntry------------------------------------------\n");
        builder.append(String.format("startingAddress: 0X%08X\n", this.startingAddress));
        builder.append(String.format("endingAddress: 0X%08X\n", this.endingAddress));
        builder.append(String.format("endOfPrologueAddress: 0X%08X\n", this.endOfPrologueAddress));
        builder.append("End ImageFunctionEntry--------------------------------------\n");
        return builder.toString();
    }
}

