/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractLongOffsetPcodeExecutorStatePiece<A, T, S>
implements PcodeExecutorStatePiece<A, T> {
    protected final Language language;
    protected final PcodeArithmetic<A> addressArithmetic;
    protected final PcodeArithmetic<T> arithmetic;
    protected final AddressSpace uniqueSpace;

    public AbstractLongOffsetPcodeExecutorStatePiece(Language language, PcodeArithmetic<A> addressArithmetic, PcodeArithmetic<T> arithmetic) {
        this.language = language;
        this.addressArithmetic = addressArithmetic;
        this.arithmetic = arithmetic;
        this.uniqueSpace = language.getAddressFactory().getUniqueSpace();
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public PcodeArithmetic<A> getAddressArithmetic() {
        return this.addressArithmetic;
    }

    @Override
    public PcodeArithmetic<T> getArithmetic() {
        return this.arithmetic;
    }

    protected void setUnique(long offset, int size, T val) {
        S s = this.getForSpace(this.uniqueSpace, true);
        this.setInSpace(s, offset, size, val);
    }

    protected T getUnique(long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        S s = this.getForSpace(this.uniqueSpace, false);
        return this.getFromSpace(s, offset, size, reason);
    }

    protected abstract S getForSpace(AddressSpace var1, boolean var2);

    protected abstract void setInSpace(S var1, long var2, int var4, T var5);

    protected abstract T getFromSpace(S var1, long var2, int var4, PcodeExecutorStatePiece.Reason var5);

    protected T getFromNullSpace(int size, PcodeExecutorStatePiece.Reason reason) {
        return this.arithmetic.fromConst(0L, size);
    }

    @Override
    public void setVar(AddressSpace space, A offset, int size, boolean quantize, T val) {
        long lOffset = this.addressArithmetic.toLong(offset, PcodeArithmetic.Purpose.STORE);
        this.setVar(space, lOffset, size, quantize, val);
    }

    @Override
    public void setVar(AddressSpace space, long offset, int size, boolean quantize, T val) {
        this.checkRange(space, offset, size);
        if (space.isConstantSpace()) {
            throw new IllegalArgumentException("Cannot write to constant space");
        }
        if (space.isUniqueSpace()) {
            this.setUnique(offset, size, val);
            return;
        }
        S s = this.getForSpace(space, true);
        offset = this.quantizeOffset(space, offset);
        this.setInSpace(s, offset, size, val);
    }

    @Override
    public T getVar(AddressSpace space, A offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        long lOffset = this.addressArithmetic.toLong(offset, PcodeArithmetic.Purpose.LOAD);
        return this.getVar(space, lOffset, size, quantize, reason);
    }

    @Override
    public T getVar(AddressSpace space, long offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        this.checkRange(space, offset, size);
        if (space.isConstantSpace()) {
            return this.arithmetic.fromConst(offset, size);
        }
        if (space.isUniqueSpace()) {
            return this.getUnique(offset, size, reason);
        }
        S s = this.getForSpace(space, false);
        if (s == null) {
            return this.getFromNullSpace(size, reason);
        }
        offset = this.quantizeOffset(space, offset);
        return this.getFromSpace(s, offset, size, reason);
    }

    protected abstract Map<Register, T> getRegisterValuesFromSpace(S var1, List<Register> var2);

    @Override
    public Map<Register, T> getRegisterValues() {
        Map<AddressSpace, List<Register>> regsBySpace = this.language.getRegisters().stream().collect(Collectors.groupingBy(Register::getAddressSpace));
        HashMap<Register, T> result = new HashMap<Register, T>();
        for (Map.Entry<AddressSpace, List<Register>> ent : regsBySpace.entrySet()) {
            S s = this.getForSpace(ent.getKey(), false);
            if (s == null) continue;
            result.putAll(this.getRegisterValuesFromSpace(s, ent.getValue()));
        }
        return result;
    }

    public static abstract class CacheingSpaceMap<B, S>
    extends AbstractSpaceMap<S> {
        public CacheingSpaceMap() {
        }

        protected CacheingSpaceMap(Map<AddressSpace, S> spaces) {
            super(spaces);
        }

        protected abstract B getBacking(AddressSpace var1);

        protected abstract S newSpace(AddressSpace var1, B var2);

        @Override
        public synchronized S getForSpace(AddressSpace space, boolean toWrite) {
            return (S)this.spaces.computeIfAbsent(space, s -> this.newSpace((AddressSpace)s, s.isUniqueSpace() ? null : (B)this.getBacking((AddressSpace)s)));
        }
    }

    public static abstract class SimpleSpaceMap<S>
    extends AbstractSpaceMap<S> {
        public SimpleSpaceMap() {
        }

        protected SimpleSpaceMap(Map<AddressSpace, S> spaces) {
            super(spaces);
        }

        protected abstract S newSpace(AddressSpace var1);

        @Override
        public synchronized S getForSpace(AddressSpace space, boolean toWrite) {
            return (S)this.spaces.computeIfAbsent(space, s -> this.newSpace((AddressSpace)s));
        }
    }

    public static abstract class AbstractSpaceMap<S> {
        protected final Map<AddressSpace, S> spaces;

        public AbstractSpaceMap() {
            this.spaces = new HashMap<AddressSpace, S>();
        }

        protected AbstractSpaceMap(Map<AddressSpace, S> spaces) {
            this.spaces = spaces;
        }

        public abstract S getForSpace(AddressSpace var1, boolean var2);

        public Collection<S> values() {
            return this.spaces.values();
        }

        public AbstractSpaceMap<S> fork() {
            throw new UnsupportedOperationException();
        }

        public S fork(S s) {
            throw new UnsupportedOperationException();
        }

        public Map<AddressSpace, S> fork(Map<AddressSpace, S> spaces) {
            return spaces.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.fork(e.getValue())));
        }
    }
}

