/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import generic.lsh.vector.IDFLookup;
import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import generic.lsh.vector.VectorCompare;
import generic.lsh.vector.WeightFactory;
import ghidra.features.bsim.gui.filters.FunctionTagBSimFilterType;
import ghidra.features.bsim.query.BSimJDBCDataSource;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.SQLFunctionDatabase;
import ghidra.features.bsim.query.client.BSimSqlClause;
import ghidra.features.bsim.query.client.CancelledSQLException;
import ghidra.features.bsim.query.client.Configuration;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.IdHistogram;
import ghidra.features.bsim.query.client.RowKeySQL;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.client.tables.CallgraphTable;
import ghidra.features.bsim.query.client.tables.DescriptionTable;
import ghidra.features.bsim.query.client.tables.ExeTable;
import ghidra.features.bsim.query.client.tables.ExeToCategoryTable;
import ghidra.features.bsim.query.client.tables.IdfLookupTable;
import ghidra.features.bsim.query.client.tables.KeyValueTable;
import ghidra.features.bsim.query.client.tables.OptionalTable;
import ghidra.features.bsim.query.client.tables.SQLStringTable;
import ghidra.features.bsim.query.client.tables.WeightTable;
import ghidra.features.bsim.query.description.CategoryRecord;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.RowKey;
import ghidra.features.bsim.query.description.SignatureRecord;
import ghidra.features.bsim.query.description.VectorResult;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.CreateDatabase;
import ghidra.features.bsim.query.protocol.ExeSpecifier;
import ghidra.features.bsim.query.protocol.FilterAtom;
import ghidra.features.bsim.query.protocol.FunctionEntry;
import ghidra.features.bsim.query.protocol.InsertOptionalValues;
import ghidra.features.bsim.query.protocol.InsertRequest;
import ghidra.features.bsim.query.protocol.InstallCategoryRequest;
import ghidra.features.bsim.query.protocol.InstallMetadataRequest;
import ghidra.features.bsim.query.protocol.InstallTagRequest;
import ghidra.features.bsim.query.protocol.PairInput;
import ghidra.features.bsim.query.protocol.PairNote;
import ghidra.features.bsim.query.protocol.QueryChildren;
import ghidra.features.bsim.query.protocol.QueryDelete;
import ghidra.features.bsim.query.protocol.QueryExeCount;
import ghidra.features.bsim.query.protocol.QueryExeInfo;
import ghidra.features.bsim.query.protocol.QueryInfo;
import ghidra.features.bsim.query.protocol.QueryName;
import ghidra.features.bsim.query.protocol.QueryNearest;
import ghidra.features.bsim.query.protocol.QueryNearestVector;
import ghidra.features.bsim.query.protocol.QueryOptionalExist;
import ghidra.features.bsim.query.protocol.QueryOptionalValues;
import ghidra.features.bsim.query.protocol.QueryPair;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.features.bsim.query.protocol.QueryUpdate;
import ghidra.features.bsim.query.protocol.QueryVectorId;
import ghidra.features.bsim.query.protocol.QueryVectorMatch;
import ghidra.features.bsim.query.protocol.ResponseChildren;
import ghidra.features.bsim.query.protocol.ResponseDelete;
import ghidra.features.bsim.query.protocol.ResponseExe;
import ghidra.features.bsim.query.protocol.ResponseInfo;
import ghidra.features.bsim.query.protocol.ResponseInsert;
import ghidra.features.bsim.query.protocol.ResponseName;
import ghidra.features.bsim.query.protocol.ResponseNearest;
import ghidra.features.bsim.query.protocol.ResponseOptionalExist;
import ghidra.features.bsim.query.protocol.ResponseOptionalValues;
import ghidra.features.bsim.query.protocol.ResponsePair;
import ghidra.features.bsim.query.protocol.ResponseUpdate;
import ghidra.features.bsim.query.protocol.SimilarityResult;
import ghidra.util.Msg;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSQLFunctionDatabase<VF extends LSHVectorFactory>
implements SQLFunctionDatabase {
    public static final String SQL_TIME_FORMAT = "YYYY-MM-DD HH24:MI:SS.MSz";
    public static final String JAVA_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSZ";
    private static final String ARCH_TABLE_NAME = "archtable";
    private static final String COMPILER_TABLE_NAME = "comptable";
    private static final String REPOSITORY_TABLE_NAME = "repotable";
    private static final String PATH_TABLE_NAME = "pathtable";
    private static final String CAT_STRING_TABLE_NAME = "catstringtable";
    protected final BSimJDBCDataSource ds;
    public final int supportedLayoutVersion;
    private Connection db = null;
    private DatabaseInformation info;
    private ExeTable exeTable;
    private ExeToCategoryTable exeCategoryTable;
    private DescriptionTable descTable;
    private CallgraphTable callgraphTable;
    private SQLStringTable archtable;
    private SQLStringTable compilertable;
    private SQLStringTable repositorytable;
    private SQLStringTable pathtable;
    private SQLStringTable catstringtable;
    private IdfLookupTable idfLookupTable;
    private WeightTable weightTable;
    protected final VF vectorFactory;
    private FunctionDatabase.Error lasterror;
    private FunctionDatabase.Status status;
    private boolean isinit;
    private KeyValueTable keyValueTable;
    private OptionalTable[] optionaltables = null;
    private boolean trackcallgraph = true;

    protected AbstractSQLFunctionDatabase(BSimJDBCDataSource ds, VF vectorFactory, int supportedLayoutVersion) {
        this.ds = ds;
        this.supportedLayoutVersion = supportedLayoutVersion;
        this.vectorFactory = vectorFactory;
        this.archtable = new SQLStringTable(ARCH_TABLE_NAME, 1000);
        this.compilertable = new SQLStringTable(COMPILER_TABLE_NAME, 1000);
        this.repositorytable = new SQLStringTable(REPOSITORY_TABLE_NAME, 1000);
        this.pathtable = new SQLStringTable(PATH_TABLE_NAME, 1000);
        this.catstringtable = new SQLStringTable(CAT_STRING_TABLE_NAME, 1000);
        this.callgraphTable = new CallgraphTable();
        this.exeCategoryTable = new ExeToCategoryTable(this.catstringtable);
        this.keyValueTable = new KeyValueTable();
        this.exeTable = new ExeTable(this.archtable, this.compilertable, this.repositorytable, this.pathtable, this.exeCategoryTable);
        this.descTable = new DescriptionTable(this.exeTable);
        this.weightTable = new WeightTable();
        this.idfLookupTable = new IdfLookupTable();
        this.lasterror = null;
        this.info = null;
        this.status = FunctionDatabase.Status.Unconnected;
        this.isinit = false;
    }

    @Override
    public void close() {
        this.weightTable.close();
        this.idfLookupTable.close();
        this.archtable.close();
        this.compilertable.close();
        this.repositorytable.close();
        this.pathtable.close();
        this.catstringtable.close();
        this.callgraphTable.close();
        this.exeCategoryTable.close();
        this.keyValueTable.close();
        this.exeTable.close();
        this.descTable.close();
        if (this.optionaltables != null) {
            for (OptionalTable table : this.optionaltables) {
                table.close();
            }
            this.optionaltables = null;
        }
        if (this.db != null) {
            this.closing(this.db);
            try {
                this.db.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.db = null;
        }
        this.status = FunctionDatabase.Status.Unconnected;
        this.isinit = false;
        this.info = null;
    }

    protected void closing(Connection c) {
    }

    protected Connection initConnection() throws SQLException {
        if (this.db == null) {
            this.db = this.ds.getConnection();
        }
        return this.db;
    }

    protected Connection beginTransaction(boolean lockTablesForWrite) throws SQLException {
        this.db.setAutoCommit(false);
        if (lockTablesForWrite) {
            this.lockTablesForWrite();
        }
        return this.db;
    }

    protected void lockTablesForWrite() throws SQLException {
    }

    protected void endTransaction(boolean commit) throws SQLException {
        if (commit) {
            this.db.commit();
        } else {
            this.db.rollback();
        }
        this.db.setAutoCommit(true);
    }

    private int deleteExecutable(ExecutableRecord erec, List<FunctionDescription> funclist, boolean hasCategories) throws SQLException {
        if (hasCategories) {
            this.exeCategoryTable.delete(erec.getRowId().getLong());
        }
        if (this.trackcallgraph) {
            for (FunctionDescription element : funclist) {
                this.callgraphTable.delete(element.getId().getLong());
            }
        }
        return this.deleteExeRows(erec);
    }

    private int deleteExeRows(ExecutableRecord erec) throws SQLException {
        long rowid = erec.getRowId().getLong();
        int delcount = this.descTable.delete(rowid);
        this.exeTable.delete(rowid);
        return delcount;
    }

    private void readExecutableCategories(DatabaseInformation dbIndo) throws SQLException {
        int count = Integer.parseInt(this.keyValueTable.getValue("execatcount"));
        if (count <= 0) {
            dbIndo.execats = null;
            return;
        }
        dbIndo.execats = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String key = "execat" + Integer.toString(i + 1);
            String value = this.keyValueTable.getValue(key);
            dbIndo.execats.add(value);
        }
    }

    private void readFunctionTags(DatabaseInformation dbInfo) throws SQLException {
        String countString = this.keyValueTable.getValue("functiontagcount");
        int count = countString != null ? Integer.parseInt(countString) : 0;
        if (count <= 0) {
            dbInfo.functionTags = null;
            return;
        }
        dbInfo.functionTags = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String key = "functiontag" + (i + 1);
            String value = this.keyValueTable.getValue(key);
            dbInfo.functionTags.add(value);
        }
    }

    private DatabaseInformation parseDatabaseInfo() throws SQLException {
        DatabaseInformation dbInfo = new DatabaseInformation();
        dbInfo.databasename = this.keyValueTable.getValue("name");
        dbInfo.owner = this.keyValueTable.getValue("owner");
        dbInfo.description = this.keyValueTable.getValue("description");
        dbInfo.major = (short)Integer.parseInt(this.keyValueTable.getValue("major"));
        dbInfo.minor = (short)Integer.parseInt(this.keyValueTable.getValue("minor"));
        dbInfo.settings = Integer.parseInt(this.keyValueTable.getValue("settings"));
        String val = this.keyValueTable.getValue("readonly");
        dbInfo.readonly = false;
        if (val.length() > 0) {
            dbInfo.readonly = val.charAt(0) == 't';
        }
        val = this.keyValueTable.getValue("trackcallgraph");
        dbInfo.trackcallgraph = false;
        if (val.length() > 0) {
            dbInfo.trackcallgraph = val.charAt(0) == 't';
        }
        try {
            dbInfo.layout_version = Integer.parseInt(this.keyValueTable.getValue("layout"));
        }
        catch (SQLException exception) {
            dbInfo.layout_version = 0;
        }
        dbInfo.dateColumnName = this.keyValueTable.getValue("datecolumn");
        if (dbInfo.dateColumnName.equals("Ingest Date")) {
            dbInfo.dateColumnName = null;
        }
        this.readExecutableCategories(dbInfo);
        this.readFunctionTags(dbInfo);
        return dbInfo;
    }

    protected void initializeDatabase(Configuration config) throws SQLException {
        this.initConnection();
        this.setConnectionOnTables(this.db);
        try (Statement st = this.db.createStatement();){
            config.info = this.parseDatabaseInfo();
            config.k = Integer.parseInt(this.keyValueTable.getValue("k"));
            config.L = Integer.parseInt(this.keyValueTable.getValue("L"));
            config.weightfactory = new WeightFactory();
            config.idflookup = new IDFLookup();
            this.trackcallgraph = config.info.trackcallgraph;
        }
        this.weightTable.recoverWeights(config.weightfactory);
        this.idfLookupTable.recoverIDFLookup(config.idflookup);
    }

    protected abstract void generateRawDatabase() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDatabase(Configuration config) throws SQLException {
        this.generateRawDatabase();
        this.trackcallgraph = config.info.trackcallgraph;
        this.initConnection();
        this.setConnectionOnTables(this.db);
        try (Statement st = this.db.createStatement();){
            this.beginTransaction(false);
            boolean commit = false;
            try {
                this.archtable.createTable();
                this.compilertable.createTable();
                this.repositorytable.createTable();
                this.pathtable.createTable();
                this.catstringtable.createTable();
                this.keyValueTable.create(st);
                this.keyValueTable.writeBasicInfo(config.info);
                this.keyValueTable.insert("k", Integer.toString(config.k));
                this.keyValueTable.insert("L", Integer.toString(config.L));
                commit = true;
            }
            finally {
                this.endTransaction(commit);
            }
            this.exeCategoryTable.create(st);
            this.exeTable.create(st);
            this.descTable.create(st);
            if (this.trackcallgraph) {
                this.callgraphTable.create(st);
            }
            this.installWeights(this.db, config.weightfactory);
            this.installIDFLookup(this.db, config.idflookup);
        }
        catch (SQLException err) {
            throw new SQLException("Could not create database: " + err.getMessage());
        }
    }

    protected void setConnectionOnTables(Connection db) {
        this.weightTable.setConnection(db);
        this.idfLookupTable.setConnection(db);
        this.archtable.setConnection(db);
        this.compilertable.setConnection(db);
        this.repositorytable.setConnection(db);
        this.pathtable.setConnection(db);
        this.catstringtable.setConnection(db);
        this.callgraphTable.setConnection(db);
        this.exeCategoryTable.setConnection(db);
        this.keyValueTable.setConnection(db);
        this.exeTable.setConnection(db);
        this.descTable.setConnection(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installWeights(Connection conn, WeightFactory factory) throws SQLException {
        try (Statement st = conn.createStatement();){
            this.weightTable.drop(st);
            this.weightTable.create(st);
            double[] weightArray = factory.toArray();
            this.beginTransaction(false);
            boolean commit = false;
            try {
                for (int i = 0; i < weightArray.length; ++i) {
                    this.weightTable.insert(i, weightArray[i]);
                }
                commit = true;
            }
            finally {
                this.endTransaction(commit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installIDFLookup(Connection conn, IDFLookup lookup) throws SQLException {
        try (Statement st = conn.createStatement();){
            this.idfLookupTable.drop(st);
            this.idfLookupTable.create(st);
            int[] intArray = lookup.toArray();
            this.beginTransaction(false);
            boolean commit = false;
            try {
                for (int i = 0; i < intArray.length; i += 2) {
                    this.idfLookupTable.insert(intArray[i + 1], intArray[i]);
                }
                commit = true;
            }
            finally {
                this.endTransaction(commit);
            }
        }
    }

    private void updateFunction(FunctionDescription.Update rec) throws SQLException {
        try (Statement st = this.db.createStatement();){
            StringBuilder buf = new StringBuilder();
            buf.append("UPDATE desctable SET ");
            boolean previous = false;
            if (rec.function_name) {
                previous = true;
                buf.append("name_func='");
                AbstractSQLFunctionDatabase.appendEscapedLiteral(buf, rec.update.getFunctionName());
                buf.append('\'');
            }
            if (rec.flags) {
                if (previous) {
                    buf.append(',');
                }
                buf.append("flags=");
                buf.append(rec.update.getFlags());
            }
            buf.append(" WHERE id = ");
            buf.append(rec.update.getId().getLong());
            st.executeUpdate(buf.toString());
        }
    }

    private ExecutableRecord makeExecutableRecordTemp(ExeTable.ExecutableRow row) throws SQLException {
        ExecutableRecord exeres;
        String arch = this.archtable.getString(row.arch_id);
        RowKeySQL rowid = new RowKeySQL(row.rowid);
        if (ExecutableRecord.isLibraryHash(row.md5)) {
            exeres = new ExecutableRecord(row.exename, arch, rowid);
        } else {
            String cname = this.compilertable.getString(row.compiler_id);
            String repo = this.repositorytable.getString(row.repo_id);
            String path = null;
            if (repo != null) {
                path = this.pathtable.getString(row.path_id);
            }
            exeres = new ExecutableRecord(row.md5, row.exename, cname, arch, new Date(row.date_milli), rowid, repo, path);
        }
        return exeres;
    }

    private boolean markPreviouslyStoredFunctions(DescriptionManager input, Iterator<FunctionDescription> iter) throws SQLException {
        boolean newfuncs = false;
        while (iter.hasNext()) {
            FunctionDescription func = iter.next();
            ExecutableRecord erec = func.getExecutableRecord();
            if (!erec.isAlreadyStored()) {
                newfuncs = true;
                continue;
            }
            DescriptionTable.DescriptionRow row = this.descTable.queryFuncNameAddr(erec.getRowId().getLong(), func.getFunctionName(), func.getAddress());
            if (row == null) {
                newfuncs = true;
                continue;
            }
            input.setFunctionDescriptionId(func, new RowKeySQL(row.rowid));
        }
        return newfuncs;
    }

    long queryArchString(String value) throws SQLException {
        return this.archtable.readStringId(value);
    }

    long queryCompilerString(String value) throws SQLException {
        return this.compilertable.readStringId(value);
    }

    long queryRepositoryString(String value) throws SQLException {
        return this.repositorytable.readStringId(value);
    }

    long queryCategoryString(String value) throws SQLException {
        return this.catstringtable.readStringId(value);
    }

    private int queryAllFunc(List<FunctionDescription> vecres, ExecutableRecord exe, DescriptionManager res, int max) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ALL * FROM desctable WHERE id_exe = ");
        buf.append((int)exe.getRowId().getLong());
        if (max > 0) {
            buf.append(" LIMIT ").append(max);
        }
        try (Statement st = this.db.createStatement();){
            int n;
            block13: {
                ResultSet rs = st.executeQuery(buf.toString());
                try {
                    st.setFetchSize(50);
                    int count = 0;
                    List<DescriptionTable.DescriptionRow> descrow = this.descTable.extractDescriptionRows(rs, max);
                    count = descrow.size();
                    this.descTable.convertDescriptionRows(vecres, descrow, exe, res, null);
                    n = count;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateExecutable(DescriptionManager manage, ExecutableRecord erec, List<FunctionDescription> badfunc, boolean checkExeCategories) throws LSHException, SQLException {
        List<FunctionDescription.Update> updatelist;
        this.beginTransaction(true);
        boolean commit = false;
        try {
            ExeTable.ExecutableRow row = this.exeTable.queryMd5ExeMatch(erec.getMd5());
            if (row == null) {
                int n = -1;
                return n;
            }
            ExecutableRecord erec_db = this.makeExecutableRecordTemp(row);
            DescriptionManager dbmanage = new DescriptionManager();
            erec_db = dbmanage.transferExecutable(erec_db);
            if (checkExeCategories) {
                List<CategoryRecord> catvec = this.exeCategoryTable.queryExecutableCategories(erec_db.getRowId().getLong(), 100);
                dbmanage.setExeCategories(erec_db, catvec);
            }
            ExecutableRecord.Update exe_update = new ExecutableRecord.Update();
            boolean has_exe_update = erec.diffForUpdate(exe_update, erec_db);
            ArrayList<FunctionDescription> funclist = new ArrayList<FunctionDescription>();
            this.queryAllFunc(funclist, erec_db, dbmanage, 0);
            Map<Long, FunctionDescription> addrmap = FunctionDescription.createAddressToFunctionMap(funclist.iterator());
            updatelist = FunctionDescription.generateUpdates(manage.listFunctions(erec), addrmap, badfunc);
            if (!has_exe_update && updatelist.isEmpty()) {
                int n = 0;
                return n;
            }
            if (has_exe_update) {
                this.exeTable.updateExecutable(exe_update);
            }
            for (FunctionDescription.Update updateRec : updatelist) {
                this.updateFunction(updateRec);
            }
            commit = true;
            int val = has_exe_update ? 1 : 0;
        }
        finally {
            this.endTransaction(commit);
        }
        return val += 2 * updatelist.size();
    }

    private OptionalTable getOptionalTable(String tableName, int keyType, int valueType, boolean testExistence) throws SQLException {
        OptionalTable[] newArray;
        if (this.optionaltables != null) {
            for (OptionalTable table : this.optionaltables) {
                if (!table.getName().equals(tableName)) continue;
                if (keyType != table.getKeyType() || valueType != table.getValueType()) {
                    throw new SQLException("Optional table: column type mismatch");
                }
                return table;
            }
        }
        OptionalTable table = new OptionalTable(tableName, keyType, valueType, this.db);
        if (testExistence && !table.exists()) {
            table.close();
            return null;
        }
        if (this.optionaltables != null) {
            newArray = Arrays.copyOf(this.optionaltables, this.optionaltables.length + 1);
            newArray[this.optionaltables.length] = table;
        } else {
            newArray = new OptionalTable[]{table};
        }
        this.optionaltables = newArray;
        return table;
    }

    public static void appendEscapedLiteral(StringBuilder buf, String str) throws SQLException {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\u0000') {
                throw new SQLException("Zero byte in SQL string");
            }
            if (ch == '\\' || ch == '\'') {
                buf.append(ch);
            }
            buf.append(ch);
        }
    }

    protected void convertDescriptionRows(SimilarityResult simres, List<DescriptionTable.DescriptionRow> descvec, VectorResult vecres, DescriptionManager res, SignatureRecord srec) throws SQLException, LSHException {
        Iterator<DescriptionTable.DescriptionRow> iter = descvec.iterator();
        DescriptionTable.DescriptionRow currow = iter.next();
        RowKeySQL rowKey = new RowKeySQL(currow.id_exe);
        ExecutableRecord curexe = res.findExecutableByRow(rowKey);
        if (curexe == null) {
            ExeTable.ExecutableRow exerow = this.exeTable.querySingleExecutableId(currow.id_exe);
            curexe = this.exeTable.makeExecutableRecord(res, exerow);
            res.cacheExecutableByRow(curexe, rowKey);
        }
        FunctionDescription fres = DescriptionTable.convertDescriptionRow(currow, curexe, res, srec);
        if (simres != null) {
            simres.addNote(fres, vecres.sim, vecres.signif);
        }
        if (srec != null) {
            res.setSignatureId(srec, currow.id_sig);
        }
        while (iter.hasNext()) {
            currow = iter.next();
            rowKey = new RowKeySQL(currow.id_exe);
            curexe = res.findExecutableByRow(rowKey);
            if (curexe == null) {
                ExeTable.ExecutableRow exerow = this.exeTable.querySingleExecutableId(currow.id_exe);
                curexe = this.exeTable.makeExecutableRecord(res, exerow);
                res.cacheExecutableByRow(curexe, rowKey);
            }
            fres = DescriptionTable.convertDescriptionRow(currow, curexe, res, srec);
            if (simres == null) continue;
            simres.addNote(fres, vecres.sim, vecres.signif);
        }
    }

    private void fillinChildren(FunctionDescription func, DescriptionManager manager, Map<RowKey, FunctionDescription> funcmap) throws SQLException, LSHException {
        List<CallgraphTable.CallgraphRow> callvec = this.callgraphTable.queryCallgraphRows(func, this.trackcallgraph);
        for (CallgraphTable.CallgraphRow element : callvec) {
            long id = element.dest;
            RowKeySQL key = new RowKeySQL(id);
            FunctionDescription fdesc = funcmap.get(key);
            if (fdesc == null) {
                fdesc = this.descTable.querySingleDescriptionId(manager, id);
                funcmap.put(fdesc.getId(), fdesc);
            }
            manager.makeCallgraphLink(func, fdesc, 0);
        }
    }

    private void fillinExecutableCategories(DescriptionManager manage) throws SQLException {
        TreeSet<ExecutableRecord> exes = manage.getExecutableRecordSet();
        int max = 100;
        for (ExecutableRecord erec : exes) {
            if (erec.categoriesAreSet()) continue;
            List<CategoryRecord> catvec = this.exeCategoryTable.queryExecutableCategories(erec.getRowId().getLong(), max);
            manage.setExeCategories(erec, catvec);
        }
    }

    private void deleteVectors(Iterator<IdHistogram> iter) throws SQLException {
        while (iter.hasNext()) {
            IdHistogram hist = iter.next();
            this.deleteVectors(hist.id, hist.count);
        }
    }

    protected abstract int deleteVectors(long var1, int var3) throws SQLException;

    long recoverExternalFunctionId(String exename, String functionname, String reparch) throws SQLException, LSHException {
        String md5 = ExecutableRecord.calcLibraryMd5Placeholder(exename, reparch);
        ExeTable.ExecutableRow row = this.exeTable.queryMd5ExeMatch(md5);
        if (row == null) {
            throw new LSHException("Could not resolve filter specifying executable: " + exename);
        }
        DescriptionTable.DescriptionRow descRow = this.descTable.queryFuncNameAddr(row.rowid, functionname, -1L);
        if (descRow == null) {
            throw new LSHException("Could not resolve filter specifying function: [" + exename + "]" + functionname);
        }
        return descRow.rowid;
    }

    private void queryAssociatedSignature(FunctionDescription functionDescription, DescriptionManager descriptionManager, Map<Long, SignatureRecord> sigmap) throws SQLException {
        SignatureRecord srec;
        if (functionDescription.getSignatureRecord() != null) {
            return;
        }
        long vectorId = functionDescription.getVectorId();
        if (vectorId == 0L) {
            return;
        }
        if (sigmap != null) {
            srec = sigmap.get(vectorId);
            if (srec == null) {
                VectorResult rowres = this.queryVectorId(vectorId);
                srec = descriptionManager.newSignature(rowres.vec, rowres.hitcount);
                descriptionManager.setSignatureId(srec, vectorId);
                sigmap.put(vectorId, srec);
            }
        } else {
            VectorResult rowres = this.queryVectorId(vectorId);
            srec = descriptionManager.newSignature(rowres.vec, rowres.hitcount);
            descriptionManager.setSignatureId(srec, vectorId);
        }
        descriptionManager.attachSignature(functionDescription, srec);
    }

    protected abstract VectorResult queryVectorId(long var1) throws SQLException;

    private void queryAssociatedSignatures(List<FunctionDescription> funcvec, DescriptionManager manager) throws SQLException {
        TreeMap<Long, SignatureRecord> sigmap = new TreeMap<Long, SignatureRecord>();
        for (FunctionDescription element : funcvec) {
            this.queryAssociatedSignature(element, manager, sigmap);
        }
    }

    private int getTotalCount(List<VectorResult> resultSet) {
        int count = 0;
        for (VectorResult res : resultSet) {
            count += res.hitcount;
        }
        return count;
    }

    private void testExecutableDuplication(DescriptionManager input) throws SQLException, LSHException, FunctionDatabase.DatabaseNonFatalException {
        boolean pickout_storedfuncs = false;
        for (ExecutableRecord erec : input.getExecutableRecordSet()) {
            ExeTable.ExecutableRow row = this.exeTable.queryMd5ExeMatch(erec.getMd5());
            if (row == null) continue;
            ExecutableRecord tmp = this.makeExecutableRecordTemp(row);
            int cmp = tmp.compareMetadata(erec);
            if (cmp != 0) {
                String fatalerror = FunctionDatabase.constructFatalError(cmp, erec, tmp);
                if (fatalerror != null) {
                    throw new LSHException(fatalerror);
                }
                throw new FunctionDatabase.DatabaseNonFatalException(FunctionDatabase.constructNonfatalError(cmp, erec, tmp));
            }
            if (erec.getRowId() != null) {
                if (!erec.getRowId().equals(tmp.getRowId())) {
                    throw new LSHException("Id mismatch when inserting executable: " + erec.getNameExec());
                }
            } else {
                input.setExeRowId(erec, tmp.getRowId());
            }
            input.setExeAlreadyStored(erec);
            if (!erec.isLibrary()) {
                throw new FunctionDatabase.DatabaseNonFatalException(erec.getNameExec() + " is already ingested");
            }
            pickout_storedfuncs = true;
        }
        if (pickout_storedfuncs && !this.markPreviouslyStoredFunctions(input, input.listAllFunctions())) {
            throw new FunctionDatabase.DatabaseNonFatalException("Already inserted");
        }
    }

    private void commitExecutables(DescriptionManager input) throws SQLException {
        for (ExecutableRecord erec : input.getExecutableRecordSet()) {
            if (erec.isAlreadyStored()) continue;
            long newid = this.exeTable.insert(erec);
            input.setExeRowId(erec, new RowKeySQL(newid));
        }
        if (this.info.execats != null) {
            for (ExecutableRecord erec : input.getExecutableRecordSet()) {
                this.exeCategoryTable.storeExecutableCategories(erec);
            }
        }
    }

    @Override
    public FunctionDatabase.Status getStatus() {
        if (this.status == FunctionDatabase.Status.Unconnected) {
            return this.ds.getStatus();
        }
        return this.status;
    }

    @Override
    public FunctionDatabase.ConnectionType getConnectionType() {
        return this.ds.getConnectionType();
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public void setUserName(String userName) {
    }

    @Override
    public LSHVectorFactory getLSHVectorFactory() {
        return this.vectorFactory;
    }

    @Override
    public DatabaseInformation getInfo() {
        return this.info;
    }

    @Override
    public int compareLayout() {
        if (this.supportedLayoutVersion < 0 || this.info.layout_version == this.supportedLayoutVersion) {
            return 0;
        }
        return this.info.layout_version < this.supportedLayoutVersion ? -1 : 1;
    }

    @Override
    public BSimServerInfo getServerInfo() {
        return this.ds.getServerInfo();
    }

    @Override
    public String getURLString() {
        return this.ds.getServerInfo().toURLString();
    }

    @Override
    public FunctionDatabase.Error getLastError() {
        return this.lasterror;
    }

    private void generate(Configuration config) throws SQLException {
        config.info.layout_version = this.supportedLayoutVersion;
        this.info = config.info;
        this.vectorFactory.set(config.weightfactory, config.idflookup, config.info.settings);
        this.createDatabase(config);
        this.status = FunctionDatabase.Status.Ready;
        this.isinit = true;
    }

    @Override
    public boolean initialize() {
        if (this.isinit) {
            return true;
        }
        try {
            Configuration config = new Configuration();
            this.initializeDatabase(config);
            this.info = config.info;
            this.vectorFactory.set(config.weightfactory, config.idflookup, config.info.settings);
        }
        catch (CancelledSQLException e) {
            this.status = FunctionDatabase.Status.Error;
            this.lasterror = new FunctionDatabase.Error(FunctionDatabase.ErrorCategory.AuthenticationCancelled, "Authentication cancelled by user");
            return false;
        }
        catch (SQLException err) {
            String msg;
            this.status = FunctionDatabase.Status.Error;
            Throwable cause = err.getCause();
            if (cause == null) {
                cause = err;
            }
            this.lasterror = (msg = cause.getMessage()).contains("already in use:") ? new FunctionDatabase.Error(FunctionDatabase.ErrorCategory.Initialization, "Database already in use by another process") : (msg.contains("authentication failed") || msg.contains("requires a valid client certificate") ? new FunctionDatabase.Error(FunctionDatabase.ErrorCategory.Authentication, "Could not authenticate with database") : (msg.contains("does not exist") && !msg.contains(" role ") ? new FunctionDatabase.Error(FunctionDatabase.ErrorCategory.Nodatabase, cause.getMessage()) : new FunctionDatabase.Error(FunctionDatabase.ErrorCategory.Initialization, "Database error on initialization: " + cause.getMessage())));
            return false;
        }
        this.status = FunctionDatabase.Status.Ready;
        this.isinit = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(DescriptionManager input) throws SQLException, LSHException, FunctionDatabase.DatabaseNonFatalException {
        this.beginTransaction(true);
        boolean commit = false;
        try {
            FunctionDescription func;
            this.testExecutableDuplication(input);
            this.commitExecutables(input);
            Iterator<FunctionDescription> iter = input.listAllFunctions();
            long start_id = 0L;
            while (iter.hasNext()) {
                func = iter.next();
                if (func.getId() != null) continue;
                SignatureRecord srec = func.getSignatureRecord();
                if (srec != null) {
                    long sig_id = this.storeSignatureRecord(srec);
                    input.setSignatureId(srec, sig_id);
                }
                long id = this.descTable.insert(func);
                if (start_id == 0L) {
                    start_id = id;
                }
                input.setFunctionDescriptionId(func, new RowKeySQL(id));
            }
            if (this.trackcallgraph) {
                iter = input.listAllFunctions();
                while (iter.hasNext()) {
                    func = iter.next();
                    if (func.getId().getLong() < start_id) continue;
                    this.callgraphTable.insert(func);
                }
            }
            commit = true;
        }
        finally {
            this.endTransaction(commit);
        }
    }

    protected abstract long storeSignatureRecord(SignatureRecord var1) throws SQLException;

    private void queryNearest(SimilarityResult simres, DescriptionManager res, LSHVector vec, QueryNearest query, BSimSqlClause filter, HashMap<LSHVector, List<VectorResult>> vecToResultsMap) throws SQLException, LSHException {
        ArrayList<VectorResult> resultset = new ArrayList<VectorResult>();
        int vectormax = query.vectormax;
        if (vectormax == 0) {
            vectormax = 2000000;
        }
        if (vecToResultsMap.containsKey(vec)) {
            resultset = vecToResultsMap.get(vec);
            simres.setTotalCount(this.getTotalCount(resultset));
        } else {
            simres.setTotalCount(this.queryNearestVector(resultset, vec, query.thresh, query.signifthresh, vectormax));
            vecToResultsMap.put(vec, resultset);
        }
        int count = 0;
        for (VectorResult dresult : resultset) {
            if (count >= query.max) break;
            count += this.retrieveFuncDescFromVectors(dresult, res, count, query, filter, simres);
        }
    }

    protected int retrieveFuncDescFromVectors(VectorResult dresult, DescriptionManager res, int count, QueryNearest query, BSimSqlClause filter, SimilarityResult simres) throws SQLException, LSHException {
        SignatureRecord srec = res.newSignature(dresult.vec, dresult.hitcount);
        List<DescriptionTable.DescriptionRow> descres = filter == null ? this.descTable.queryVectorIdMatch(dresult.vectorid, query.max - count) : this.descTable.queryVectorIdMatchFilter(dresult.vectorid, filter.tableClause(), filter.whereClause(), query.max - count);
        if (descres == null) {
            throw new SQLException("Error querying vectorid: " + Long.toString(dresult.vectorid));
        }
        if (descres.size() == 0) {
            if (filter != null) {
                return 0;
            }
            throw new SQLException("No functions matching vectorid: " + Long.toString(dresult.vectorid));
        }
        this.convertDescriptionRows(simres, descres, dresult, res, srec);
        return descres.size();
    }

    protected abstract int queryNearestVector(List<VectorResult> var1, LSHVector var2, double var3, double var5, int var7) throws SQLException;

    protected abstract void queryNearestVector(QueryNearestVector var1) throws SQLException;

    private void queryByName(List<FunctionDescription> functionDescriptions, DescriptionManager manager, ExecutableRecord executableRecord, String functionName, boolean shouldReturnSignatures, int maxResults) throws SQLException {
        if (functionDescriptions == null) {
            functionDescriptions = new ArrayList<FunctionDescription>();
        }
        if (functionName.length() == 0) {
            this.queryAllFunc(functionDescriptions, executableRecord, manager, maxResults);
        } else {
            List<DescriptionTable.DescriptionRow> descres = this.descTable.queryFuncName(executableRecord.getRowId().getLong(), functionName, maxResults);
            this.descTable.convertDescriptionRows(functionDescriptions, descres, executableRecord, manager, null);
        }
        if (shouldReturnSignatures) {
            this.queryAssociatedSignatures(functionDescriptions, manager);
        }
    }

    private FunctionDescription queryByNameAddress(DescriptionManager manager, ExecutableRecord erec, String funcname, long address, boolean sigs) throws SQLException {
        DescriptionTable.DescriptionRow row = this.descTable.queryFuncNameAddr(erec.getRowId().getLong(), funcname, address);
        FunctionDescription func = DescriptionTable.convertDescriptionRow(row, erec, manager, null);
        if (sigs) {
            this.queryAssociatedSignature(func, manager, null);
        }
        return func;
    }

    private List<ExecutableRecord> queryExecutables(DescriptionManager manager, int limit, String filterMd5, String filterExeName, long filterArch, long filterCompilerName, ExeTable.ExeTableOrderColumn columnName, boolean includeFakes) throws SQLException, LSHException {
        ArrayList<ExecutableRecord> records = new ArrayList<ExecutableRecord>();
        List<ExeTable.ExecutableRow> rows = this.exeTable.queryAllExe(limit, filterMd5, filterExeName, filterArch, filterCompilerName, columnName, includeFakes);
        for (ExeTable.ExecutableRow row : rows) {
            ExecutableRecord record = this.exeTable.makeExecutableRecord(manager, row);
            records.add(record);
        }
        return records;
    }

    private ExecutableRecord findSingleExecutable(ExeSpecifier spec, DescriptionManager manager) throws SQLException, LSHException {
        if (!StringUtils.isBlank((CharSequence)spec.exemd5)) {
            ExeTable.ExecutableRow row = this.exeTable.queryMd5ExeMatch(spec.exemd5);
            if (row == null) {
                return null;
            }
            return this.exeTable.makeExecutableRecord(manager, row);
        }
        if (StringUtils.isBlank((CharSequence)spec.exename)) {
            throw new LSHException("ExeSpecifier must provide either md5 or name");
        }
        return this.exeTable.querySingleExecutable(manager, spec.exename, spec.arch, spec.execompname);
    }

    private ExecutableRecord findSingleExeWithMap(ExeSpecifier exe, DescriptionManager manager, TreeMap<ExeSpecifier, ExecutableRecord> nameMap) throws SQLException, LSHException {
        ExecutableRecord erec = nameMap.get(exe);
        if (erec != null) {
            return erec;
        }
        erec = this.findSingleExecutable(exe, manager);
        nameMap.put(exe, erec);
        return erec;
    }

    private ExecutableRecord queryExecutableByMd5(String md5, DescriptionManager res) throws LSHException, SQLException {
        ExeTable.ExecutableRow row = this.exeTable.queryMd5ExeMatch(md5);
        if (row != null) {
            return this.exeTable.makeExecutableRecord(res, row);
        }
        return null;
    }

    private void queryCallgraph(DescriptionManager manage) throws LSHException, SQLException {
        if (!this.info.trackcallgraph) {
            throw new LSHException("Database does not track callgraph");
        }
        TreeMap<RowKey, FunctionDescription> funcmap = new TreeMap<RowKey, FunctionDescription>();
        manage.generateFunctionIdMap(funcmap);
        ArrayList<FunctionDescription> funclist = new ArrayList<FunctionDescription>();
        for (FunctionDescription element : funcmap.values()) {
            funclist.add(element);
        }
        for (FunctionDescription element : funclist) {
            this.fillinChildren(element, manage, funcmap);
        }
    }

    protected QueryResponseRecord doQuery(BSimQuery<?> query, Connection c) throws LSHException, SQLException, FunctionDatabase.DatabaseNonFatalException {
        if (query instanceof QueryNearest) {
            QueryNearest q = (QueryNearest)query;
            this.fdbQueryNearest(q);
        } else if (query instanceof QueryNearestVector) {
            QueryNearestVector q = (QueryNearestVector)query;
            this.fdbQueryNearestVector(q);
        } else if (query instanceof InsertRequest) {
            InsertRequest q = (InsertRequest)query;
            this.fdbDatabaseInsert(q);
        } else if (query instanceof QueryInfo) {
            QueryInfo q = (QueryInfo)query;
            this.fdbDatabaseInfo(q);
        } else if (query instanceof QueryName) {
            QueryName q = (QueryName)query;
            this.fdbQueryName(q);
        } else if (query instanceof QueryExeInfo) {
            QueryExeInfo q = (QueryExeInfo)query;
            this.fdbQueryExeInfo(q);
        } else if (query instanceof QueryExeCount) {
            QueryExeCount q = (QueryExeCount)query;
            this.fdbQueryExeCount(q);
        } else if (query instanceof CreateDatabase) {
            CreateDatabase q = (CreateDatabase)query;
            this.fdbDatabaseCreate(q);
        } else if (query instanceof QueryChildren) {
            QueryChildren q = (QueryChildren)query;
            this.fdbQueryChildren(q);
        } else if (query instanceof QueryDelete) {
            QueryDelete q = (QueryDelete)query;
            this.fdbDelete(q);
        } else if (query instanceof QueryUpdate) {
            QueryUpdate q = (QueryUpdate)query;
            this.fdbUpdate(q);
        } else if (query instanceof QueryVectorId) {
            QueryVectorId q = (QueryVectorId)query;
            this.fdbQueryVectorId(q);
        } else if (query instanceof QueryVectorMatch) {
            QueryVectorMatch q = (QueryVectorMatch)query;
            this.fdbQueryVectorMatch(q);
        } else if (query instanceof QueryPair) {
            QueryPair q = (QueryPair)query;
            this.fdbQueryPair(q);
        } else if (query instanceof QueryOptionalValues) {
            QueryOptionalValues q = (QueryOptionalValues)query;
            this.fdbQueryOptionalValues(q);
        } else if (query instanceof InsertOptionalValues) {
            InsertOptionalValues q = (InsertOptionalValues)query;
            this.fdbInsertOptionalValues(q);
        } else if (query instanceof QueryOptionalExist) {
            QueryOptionalExist q = (QueryOptionalExist)query;
            this.fdbOptionalExist(q);
        } else if (query instanceof InstallCategoryRequest) {
            InstallCategoryRequest q = (InstallCategoryRequest)query;
            this.fdbInstallCategory(q);
        } else if (query instanceof InstallTagRequest) {
            InstallTagRequest q = (InstallTagRequest)query;
            this.fdbInstallTag(q);
        } else if (query instanceof InstallMetadataRequest) {
            InstallMetadataRequest q = (InstallMetadataRequest)query;
            this.fdbInstallMetadata(q);
        } else {
            return null;
        }
        return query.getResponse();
    }

    @Override
    public QueryResponseRecord query(BSimQuery<?> query) {
        this.lasterror = null;
        try {
            if (!(query instanceof CreateDatabase) && !this.initialize()) {
                this.lasterror = new FunctionDatabase.Error(FunctionDatabase.ErrorCategory.Nodatabase, "The database does not exist");
                return null;
            }
            query.buildResponseTemplate();
            QueryResponseRecord response = this.doQuery(query, this.db);
            if (response == null) {
                this.lasterror = new FunctionDatabase.Error(FunctionDatabase.ErrorCategory.Fatal, "Unknown query type");
                query.clearResponse();
            }
        }
        catch (FunctionDatabase.DatabaseNonFatalException err) {
            this.lasterror = new FunctionDatabase.Error(FunctionDatabase.ErrorCategory.Nonfatal, "Skipping -" + query.getName() + "- : " + err.getMessage());
            query.clearResponse();
        }
        catch (LSHException err) {
            this.lasterror = new FunctionDatabase.Error(FunctionDatabase.ErrorCategory.Fatal, "Fatal error during -" + query.getName() + "- : " + err.getMessage());
            query.clearResponse();
        }
        catch (SQLException err) {
            this.lasterror = new FunctionDatabase.Error(FunctionDatabase.ErrorCategory.Fatal, "SQL error during -" + query.getName() + "- : " + err.getMessage());
            query.clearResponse();
        }
        return query.getResponse();
    }

    private void fdbQueryNearestVector(QueryNearestVector query) throws LSHException, SQLException {
        FunctionDatabase.checkSettingsForQuery(query.manage, this.info);
        this.queryNearestVector(query);
    }

    private void fdbQueryPair(QueryPair query) throws SQLException, LSHException {
        ResponsePair response = query.pairResponse;
        ResponsePair.Accumulator accumulator = new ResponsePair.Accumulator();
        ArrayList<FunctionDescription> aFuncList = new ArrayList<FunctionDescription>();
        ArrayList<FunctionDescription> bFuncList = new ArrayList<FunctionDescription>();
        DescriptionManager resManage = new DescriptionManager();
        TreeMap<ExeSpecifier, ExecutableRecord> nameMap = new TreeMap<ExeSpecifier, ExecutableRecord>();
        for (PairInput pairInput : query.pairs) {
            FunctionDescription funcA = null;
            FunctionDescription funcB = null;
            ExecutableRecord erec = this.findSingleExeWithMap(pairInput.execA, resManage, nameMap);
            if (erec == null) {
                ++accumulator.missedExe;
            } else {
                funcA = this.queryByNameAddress(resManage, erec, pairInput.funcA.funcName, pairInput.funcA.address, true);
                if (funcA == null) {
                    ++accumulator.missedFunc;
                }
            }
            erec = this.findSingleExeWithMap(pairInput.execB, resManage, nameMap);
            if (erec == null) {
                ++accumulator.missedExe;
            } else {
                funcB = this.queryByNameAddress(resManage, erec, pairInput.funcB.funcName, pairInput.funcB.address, true);
                if (funcB == null) {
                    ++accumulator.missedFunc;
                }
            }
            aFuncList.add(funcA);
            bFuncList.add(funcB);
        }
        Iterator bIter = bFuncList.iterator();
        VectorCompare vectorData = new VectorCompare();
        for (FunctionDescription funcA : aFuncList) {
            FunctionDescription funcB = (FunctionDescription)bIter.next();
            if (funcA == null || funcB == null) continue;
            SignatureRecord sigA = funcA.getSignatureRecord();
            if (sigA == null) {
                ++accumulator.missedVector;
                continue;
            }
            SignatureRecord sigB = funcB.getSignatureRecord();
            if (sigB == null) {
                ++accumulator.missedVector;
                continue;
            }
            double sim = sigA.getLSHVector().compare(sigB.getLSHVector(), vectorData);
            double signif = this.vectorFactory.calculateSignificance(vectorData);
            PairNote pairNote = new PairNote(funcA, funcB, sim, signif, vectorData.dotproduct, vectorData.acount, vectorData.bcount, vectorData.intersectcount);
            response.notes.add(pairNote);
            ++accumulator.pairCount;
            accumulator.sumSim += sim;
            accumulator.sumSimSquare += sim * sim;
            accumulator.sumSig += signif;
            accumulator.sumSigSquare += signif * signif;
        }
        response.scale = this.vectorFactory.getSignificanceScale();
        response.fillOutStatistics(accumulator);
    }

    private void fdbQueryNearest(QueryNearest query) throws LSHException, SQLException {
        FunctionDatabase.checkSettingsForQuery(query.manage, this.info);
        BSimSqlClause filter = null;
        if (query.bsimFilter != null) {
            ExecutableRecord repexe = query.manage.getExecutableRecordSet().first();
            IDSQLResolution[] idres = new IDSQLResolution[query.bsimFilter.numAtoms()];
            for (int i = 0; i < idres.length; ++i) {
                FilterAtom atom = query.bsimFilter.getAtom(i);
                idres[i] = atom.type.generateIDSQLResolution(atom);
                if (idres[i] == null) continue;
                idres[i].resolve(this, repexe);
            }
            filter = SQLEffects.createFilter(query.bsimFilter, idres, this);
        }
        ResponseNearest response = query.nearresponse;
        response.totalfunc = 0;
        response.totalmatch = 0;
        response.uniquematch = 0;
        DescriptionManager descMgr = new DescriptionManager();
        Iterator<FunctionDescription> iter = query.manage.listAllFunctions();
        this.queryFunctions(query, filter, response, descMgr, iter);
        response.manage.transferSettings(query.manage);
        if (query.fillinCategories && this.info.execats != null) {
            this.fillinExecutableCategories(response.manage);
        }
    }

    private void fdbQueryVectorId(QueryVectorId query) throws SQLException {
        for (Long id : query.vectorIds) {
            VectorResult res = this.queryVectorId(id);
            query.vectorIdResponse.vectorResults.add(res);
        }
    }

    private void fdbQueryVectorMatch(QueryVectorMatch query) throws SQLException, LSHException {
        BSimSqlClause filter = null;
        if (query.bsimFilter != null) {
            ExecutableRecord repexe = null;
            IDSQLResolution[] idres = new IDSQLResolution[query.bsimFilter.numAtoms()];
            for (int i = 0; i < idres.length; ++i) {
                FilterAtom atom = query.bsimFilter.getAtom(i);
                idres[i] = atom.type.generateIDSQLResolution(atom);
                if (idres[i] == null) continue;
                ((IDSQLResolution)idres[i]).resolve(this, repexe);
            }
            filter = SQLEffects.createFilter(query.bsimFilter, idres, this);
        }
        ArrayList<VectorResult> vectorList = new ArrayList<VectorResult>();
        for (Long id : query.vectorIds) {
            VectorResult vecResult = this.queryVectorId(id);
            vectorList.add(vecResult);
        }
        int count = 0;
        DescriptionManager manage = query.matchresponse.manage;
        for (VectorResult vecResult : vectorList) {
            if (count >= query.max) break;
            SignatureRecord srec = manage.newSignature(vecResult.vec, vecResult.hitcount);
            List<DescriptionTable.DescriptionRow> descres = filter == null ? this.descTable.queryVectorIdMatch(vecResult.vectorid, query.max - count) : this.descTable.queryVectorIdMatchFilter(vecResult.vectorid, filter.tableClause(), filter.whereClause(), query.max - count);
            if (descres == null) {
                throw new SQLException("Error querying vectorid: " + Long.toString(vecResult.vectorid));
            }
            if (descres.size() == 0) {
                if (filter != null) continue;
                throw new SQLException("No functions matching vectorid: " + Long.toString(vecResult.vectorid));
            }
            count += descres.size();
            this.convertDescriptionRows(null, descres, vecResult, manage, srec);
        }
        if (query.fillinCategories && this.info.execats != null) {
            this.fillinExecutableCategories(manage);
        }
    }

    protected int queryFunctions(QueryNearest query, BSimSqlClause filter, ResponseNearest response, DescriptionManager descMgr, Iterator<FunctionDescription> iter) throws SQLException, LSHException {
        HashMap<LSHVector, List<VectorResult>> vecToResultMap = new HashMap<LSHVector, List<VectorResult>>();
        while (iter.hasNext()) {
            LSHVector thevec;
            double len2;
            FunctionDescription frec = iter.next();
            SignatureRecord srec = frec.getSignatureRecord();
            if (srec == null || (len2 = this.vectorFactory.getSelfSignificance(thevec = srec.getLSHVector())) < query.signifthresh) continue;
            ++response.totalfunc;
            SimilarityResult simres = new SimilarityResult(frec);
            if (descMgr.getExecutableRecordSet().size() > 1000) {
                descMgr.clear();
            } else {
                descMgr.clearFunctions();
            }
            this.queryNearest(simres, descMgr, thevec, query, filter, vecToResultMap);
            if (simres.size() == 0) continue;
            ++response.totalmatch;
            if (simres.size() == 1) {
                ++response.uniquematch;
            }
            response.result.add(simres);
            simres.transfer(response.manage, true);
        }
        return vecToResultMap.size();
    }

    private void fdbDatabaseInsert(InsertRequest query) throws LSHException, SQLException, FunctionDatabase.DatabaseNonFatalException {
        if (this.info.readonly) {
            throw new LSHException("Trying to insert on read-only database");
        }
        if (FunctionDatabase.checkSettingsForInsert(query.manage, this.info)) {
            this.info.major = query.manage.getMajorVersion();
            this.info.minor = query.manage.getMinorVersion();
            this.info.settings = query.manage.getSettings();
            this.keyValueTable.writeBasicInfo(this.info);
        }
        ResponseInsert response = query.insertresponse;
        if (query.repo_override != null && query.repo_override.length() != 0) {
            query.manage.overrideRepository(query.repo_override, query.path_override);
        }
        this.insert(query.manage);
        response.numexe = query.manage.getExecutableRecordSet().size();
        response.numfunc = query.manage.numFunctions();
    }

    private void fdbDatabaseInfo(QueryInfo query) {
        ResponseInfo response = query.inforesponse;
        response.info = this.info;
    }

    private void fdbQueryName(QueryName query) throws SQLException, LSHException {
        ResponseName response = query.nameresponse;
        response.printselfsig = query.printselfsig;
        response.printjustexe = query.printjustexe;
        response.manage.setVersion(this.info.major, this.info.minor);
        response.manage.setSettings(this.info.settings);
        ExecutableRecord erec = this.findSingleExecutable(query.spec, response.manage);
        if (erec == null) {
            response.uniqueexecutable = false;
            return;
        }
        response.uniqueexecutable = true;
        this.queryByName(null, response.manage, erec, query.funcname, query.fillinSigs, query.maxfunc);
        if (query.fillinCallgraph) {
            this.queryCallgraph(response.manage);
        }
        if (query.fillinCategories && this.info.execats != null) {
            this.fillinExecutableCategories(response.manage);
        }
    }

    private void fdbQueryExeInfo(QueryExeInfo query) throws SQLException, LSHException {
        ResponseExe response = query.exeresponse;
        boolean unknownArchOrCompiler = false;
        long archId = 0L;
        if (query.filterArch != null && (archId = this.queryArchString(query.filterArch)) == 0L) {
            unknownArchOrCompiler = true;
            Msg.warn((Object)this, (Object)("Architecture ID not defined within BSim database: " + query.filterArch));
        }
        long compId = 0L;
        if (query.filterCompilerName != null && (compId = this.queryCompilerString(query.filterCompilerName)) == 0L) {
            unknownArchOrCompiler = true;
            Msg.warn((Object)this, (Object)("Compiler ID not defined within BSim database: " + query.filterCompilerName));
        }
        if (unknownArchOrCompiler) {
            response.records = List.of();
            response.recordCount = 0;
            return;
        }
        List<ExecutableRecord> records = this.queryExecutables(response.manage, query.limit, query.filterMd5, query.filterExeName, archId, compId, query.sortColumn, query.includeFakes);
        response.records = records;
        response.recordCount = records.size();
        if (query.fillinCategories && this.info.execats != null) {
            this.fillinExecutableCategories(response.manage);
        }
    }

    private void fdbQueryExeCount(QueryExeCount query) throws SQLException {
        ResponseExe response = query.exeresponse;
        long archId = 0L;
        if (query.filterArch != null) {
            archId = this.queryArchString(query.filterArch);
        }
        long compId = 0L;
        if (query.filterCompilerName != null) {
            compId = this.queryCompilerString(query.filterCompilerName);
        }
        response.recordCount = this.exeTable.queryExeCount(query.filterMd5, query.filterExeName, archId, compId, query.includeFakes);
    }

    private void fdbQueryChildren(QueryChildren query) throws LSHException, SQLException {
        if (!this.info.trackcallgraph) {
            throw new LSHException("Database does not track callgraph");
        }
        ResponseChildren response = query.childrenresponse;
        ExecutableRecord exe = null;
        if (query.md5sum.length() != 0) {
            exe = this.queryExecutableByMd5(query.md5sum, response.manage);
        } else {
            exe = this.exeTable.querySingleExecutable(response.manage, query.name_exec, query.arch, query.name_compiler);
            if (exe == null) {
                throw new LSHException("Could not (uniquely) match executable");
            }
        }
        for (FunctionEntry entry : query.functionKeys) {
            FunctionDescription func = this.queryByNameAddress(response.manage, exe, entry.funcName, entry.address, true);
            if (func == null) {
                throw new LSHException("Could not find function: " + entry.funcName);
            }
            response.correspond.add(func);
        }
        TreeMap<RowKey, FunctionDescription> funcmap = new TreeMap<RowKey, FunctionDescription>();
        response.manage.generateFunctionIdMap(funcmap);
        for (FunctionDescription element : response.correspond) {
            this.fillinChildren(element, response.manage, funcmap);
        }
    }

    private void fdbDatabaseCreate(CreateDatabase query) throws LSHException, SQLException {
        ResponseInfo response = query.inforesponse;
        Configuration config = FunctionDatabase.loadConfigurationTemplate(query.config_template);
        if (query.info.databasename != null) {
            config.info.databasename = query.info.databasename;
        }
        if (query.info.owner != null) {
            config.info.owner = query.info.owner;
        }
        if (query.info.description != null) {
            config.info.description = query.info.description;
        }
        if (!query.info.trackcallgraph) {
            config.info.trackcallgraph = query.info.trackcallgraph;
        }
        if (query.info.functionTags != null) {
            AbstractSQLFunctionDatabase.checkStrings(query.info.functionTags, "function tags", FunctionTagBSimFilterType.MAX_TAG_COUNT);
            config.info.functionTags = query.info.functionTags;
        }
        if (query.info.execats != null) {
            AbstractSQLFunctionDatabase.checkStrings(query.info.execats, "categories", -1);
            config.info.execats = query.info.execats;
        }
        this.generate(config);
        response.info = config.info;
    }

    private static void checkStrings(List<String> list, String type, int limit) throws LSHException {
        if (limit > 0 && list.size() > limit) {
            throw new LSHException("Too many " + type + " specified (limit=" + FunctionTagBSimFilterType.MAX_TAG_COUNT + "): " + list.size());
        }
        HashSet<String> names = new HashSet<String>();
        for (String name : list) {
            if (!CategoryRecord.enforceTypeCharacters(name)) {
                throw new LSHException("Bad characters in one or more proposed " + type);
            }
            if (names.add(name)) continue;
            throw new LSHException("Duplicate " + type + " entry specified: " + name);
        }
    }

    private void fdbInstallCategory(InstallCategoryRequest query) throws LSHException, SQLException {
        ResponseInfo response = query.installresponse;
        if (!CategoryRecord.enforceTypeCharacters(query.type_name)) {
            throw new LSHException("Bad characters in proposed category type");
        }
        if (query.isdatecolumn) {
            this.info.dateColumnName = query.type_name;
            this.keyValueTable.insert("datecolumn", this.info.dateColumnName);
            response.info = this.info;
            return;
        }
        if (this.info.execats != null) {
            for (String cat : this.info.execats) {
                if (!cat.equals(query.type_name)) continue;
                throw new LSHException("Executable category already exists");
            }
        }
        if (this.info.execats == null) {
            this.info.execats = new ArrayList<String>();
        }
        this.info.execats.add(query.type_name);
        this.keyValueTable.writeExecutableCategories(this.info);
        response.info = this.info;
    }

    public List<String> getFunctionTags() {
        return this.info.functionTags;
    }

    private void fdbInstallTag(InstallTagRequest query) throws LSHException, SQLException {
        ResponseInfo response = query.installresponse;
        if (!CategoryRecord.enforceTypeCharacters(query.tag_name)) {
            throw new LSHException("Bad characters in proposed function tag");
        }
        if (this.info.functionTags != null && this.info.functionTags.contains(query.tag_name)) {
            throw new LSHException("Function tag already exists");
        }
        if (this.info.functionTags == null) {
            this.info.functionTags = new ArrayList<String>();
        }
        if (this.info.functionTags.size() >= FunctionTagBSimFilterType.MAX_TAG_COUNT) {
            throw new LSHException("Cannot allocate new function tag: " + query.tag_name + " - Column space is full");
        }
        this.info.functionTags.add(query.tag_name);
        this.keyValueTable.writeFunctionTags(this.info);
        response.info = this.info;
    }

    private void fdbInstallMetadata(InstallMetadataRequest query) throws SQLException {
        ResponseInfo response = query.installresponse;
        if (query.dbname != null) {
            this.info.databasename = query.dbname;
        }
        if (query.owner != null) {
            this.info.owner = query.owner;
        }
        if (query.description != null) {
            this.info.description = query.description;
        }
        if (query.dbname != null || query.owner != null || query.description != null) {
            this.keyValueTable.writeBasicInfo(this.info);
        }
        response.info = this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fdbDelete(QueryDelete query) throws SQLException, LSHException {
        ResponseDelete response = query.respdelete;
        for (ExeSpecifier spec : query.exelist) {
            DescriptionManager manage = new DescriptionManager();
            ExecutableRecord erec = null;
            boolean commit = false;
            this.beginTransaction(true);
            try {
                if (spec.exemd5 != null && spec.exemd5.length() != 0) {
                    ExeTable.ExecutableRow row = this.exeTable.queryMd5ExeMatch(spec.exemd5);
                    if (row != null) {
                        erec = this.exeTable.makeExecutableRecord(manage, row);
                    }
                } else {
                    erec = this.exeTable.querySingleExecutable(manage, spec.exename, spec.arch, spec.execompname);
                }
                if (erec == null) {
                    response.missedlist.add(spec);
                    continue;
                }
                ResponseDelete.DeleteResult delrec = new ResponseDelete.DeleteResult();
                delrec.md5 = erec.getMd5();
                delrec.name = erec.getNameExec();
                ArrayList<FunctionDescription> funclist = new ArrayList<FunctionDescription>();
                this.queryAllFunc(funclist, erec, manage, 0);
                TreeSet<IdHistogram> table = IdHistogram.buildVectorIdHistogram(funclist.iterator());
                this.deleteVectors(table.iterator());
                delrec.funccount = this.deleteExecutable(erec, funclist, this.info.execats != null);
                response.reslist.add(delrec);
                commit = true;
            }
            finally {
                this.endTransaction(commit);
            }
        }
    }

    private void fdbUpdate(QueryUpdate query) throws LSHException, SQLException {
        ResponseUpdate response = query.updateresponse;
        for (ExecutableRecord erec : query.manage.getExecutableRecordSet()) {
            int res = this.updateExecutable(query.manage, erec, response.badfunc, this.info.execats != null);
            if (res < 0) {
                response.badexe.add(erec);
                continue;
            }
            if ((res & 1) != 0) {
                ++response.exeupdate;
            }
            response.funcupdate += res >> 1;
        }
    }

    private void fdbOptionalExist(QueryOptionalExist query) throws SQLException {
        ResponseOptionalExist response = query.optionalresponse;
        OptionalTable table = this.getOptionalTable(query.tableName, query.keyType, query.valueType, true);
        response.tableExists = table != null;
        response.wasCreated = false;
        if (table == null && query.attemptCreation) {
            table = this.getOptionalTable(query.tableName, query.keyType, query.valueType, false);
            table.createTable();
            response.wasCreated = true;
        } else if (table != null && query.clearTable) {
            table.clearTable();
        }
    }

    private void fdbQueryOptionalValues(QueryOptionalValues query) throws SQLException {
        ResponseOptionalValues response = query.optionalresponse;
        OptionalTable table = this.getOptionalTable(query.tableName, query.keyType, query.valueType, true);
        if (table == null) {
            response.resultArray = null;
            response.tableExists = false;
            return;
        }
        response.tableExists = true;
        response.resultArray = new Object[query.keys.length];
        for (int i = 0; i < response.resultArray.length; ++i) {
            response.resultArray[i] = table.readValue(query.keys[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fdbInsertOptionalValues(InsertOptionalValues query) throws SQLException {
        ResponseOptionalExist response = query.optionalresponse;
        OptionalTable table = this.getOptionalTable(query.tableName, query.keyType, query.valueType, true);
        response.wasCreated = false;
        if (table == null) {
            response.tableExists = false;
            return;
        }
        response.tableExists = true;
        this.beginTransaction(false);
        boolean commit = false;
        try {
            table.lockForWrite();
            for (int i = 0; i < query.keys.length; ++i) {
                table.writeValue(query.keys[i], query.values[i]);
            }
            commit = true;
        }
        finally {
            this.endTransaction(commit);
        }
    }
}

