/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results.apply;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import ghidra.app.services.ProgramManager;
import ghidra.features.bsim.gui.search.results.BSimApplyResult;
import ghidra.features.bsim.gui.search.results.BSimApplyResultsDisplayDialog;
import ghidra.features.bsim.gui.search.results.BSimMatchResult;
import ghidra.features.bsim.gui.search.results.BSimResultStatus;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramTask;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractBSimApplyTask
extends ProgramTask {
    private ServiceProvider serviceProvider;
    private List<BSimApplyResult> applyResults = new ArrayList<BSimApplyResult>();
    private List<BSimMatchResult> resultsToBeApplied;
    private FunctionManager functionManager;
    private ProgramManager programManager;
    private Set<Program> openedPrograms = new HashSet<Program>();
    private String taskName;

    public AbstractBSimApplyTask(Program program, String taskName, List<BSimMatchResult> results, ServiceProvider serviceProvider) {
        super(program, "Apply Function Names", true, true, true);
        this.taskName = taskName;
        this.serviceProvider = serviceProvider;
        this.functionManager = program.getFunctionManager();
        this.programManager = (ProgramManager)serviceProvider.getService(ProgramManager.class);
        this.resultsToBeApplied = results;
    }

    public void doRun(TaskMonitor monitor) {
        if (this.programManager == null) {
            Msg.error((Object)((Object)this), (Object)"Program Manager Service not found!");
            return;
        }
        try {
            this.applyResults(monitor);
            this.releaseOpenedPrograms();
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        Swing.runLater(() -> this.displayTaskResults(monitor.isCancelled()));
    }

    protected void releaseOpenedPrograms() {
        for (Program p : this.openedPrograms) {
            p.release((Object)this);
        }
    }

    private void applyResults(TaskMonitor monitor) throws CancelledException {
        Map<Address, List<BSimMatchResult>> map = this.groupResultsBySearchAddress(monitor);
        monitor.initialize((long)map.size(), "Applying " + this.taskName + "...");
        for (Address address : map.keySet()) {
            this.applyResultsForAddress(address, map.get(address), monitor);
            monitor.increment();
        }
    }

    private Map<Address, List<BSimMatchResult>> groupResultsBySearchAddress(TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.resultsToBeApplied.size(), "Grouping results...");
        HashMap<Address, List<BSimMatchResult>> map = new HashMap<Address, List<BSimMatchResult>>();
        for (BSimMatchResult result : this.resultsToBeApplied) {
            monitor.increment();
            Address address = result.getAddress();
            List list = map.computeIfAbsent(address, k -> new ArrayList());
            list.add(result);
        }
        return map;
    }

    private void applyResultsForAddress(Address address, List<BSimMatchResult> resultsForAddress, TaskMonitor monitor) {
        Function targetFunction = this.functionManager.getFunctionAt(address);
        if (targetFunction == null) {
            this.error("Can't find original function", resultsForAddress.get(0));
            this.markRows(resultsForAddress, BSimResultStatus.ERROR);
            return;
        }
        List<Function> sourceFunctions = this.getSourceFunctions(resultsForAddress);
        if (sourceFunctions.isEmpty()) {
            this.markRows(this.resultsToBeApplied, BSimResultStatus.ERROR);
            return;
        }
        if (sourceFunctions.size() > 1 && !this.hasSameApplyData(sourceFunctions)) {
            this.applyResults.add(new BSimApplyResult(targetFunction.getName(), "<multiple functions>", BSimResultStatus.ERROR, targetFunction.getEntryPoint(), "Attempted to apply different " + this.taskName + "s to the same function"));
            this.markRows(resultsForAddress, BSimResultStatus.ERROR);
            return;
        }
        BSimApplyResult applyResult = this.apply(targetFunction, sourceFunctions.get(0));
        this.applyResults.add(applyResult);
        this.markRows(resultsForAddress, applyResult.getStatus());
    }

    private List<Function> getSourceFunctions(List<BSimMatchResult> resultsForAddress) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (BSimMatchResult bSimMatchResult : resultsForAddress) {
            Function remoteFunction = this.getRemoteFunction(bSimMatchResult);
            if (remoteFunction == null) continue;
            functions.add(remoteFunction);
        }
        return functions;
    }

    private Function getRemoteFunction(BSimMatchResult result) {
        Program remoteProgram = this.getRemoteProgram(result);
        if (remoteProgram == null) {
            return null;
        }
        FunctionDescription matchDescription = result.getMatchFunctionDescription();
        long addressOffset = matchDescription.getAddress();
        AddressSpace space = remoteProgram.getAddressFactory().getDefaultAddressSpace();
        Address address = space.getAddress(addressOffset);
        FunctionManager remoteFunctionManager = remoteProgram.getFunctionManager();
        Function matchFunction = remoteFunctionManager.getFunctionAt(address);
        if (matchFunction == null) {
            this.error("Couldn't find remote function at address " + address + " in remote program " + remoteProgram.getName(), result);
        }
        return matchFunction;
    }

    private Program getRemoteProgram(BSimMatchResult result) {
        URL url = this.getRemoteProgramURL(result);
        if (url == null) {
            return null;
        }
        Program remoteProgram = this.programManager.openCachedProgram(url, (Object)this);
        if (remoteProgram == null) {
            this.error("Open remote program failed: " + url, result);
            return null;
        }
        if (!this.openedPrograms.add(remoteProgram)) {
            remoteProgram.release((Object)this);
        }
        return remoteProgram;
    }

    private void markRows(List<BSimMatchResult> list, BSimResultStatus state) {
        for (BSimMatchResult row : list) {
            row.setStatus(state);
        }
    }

    private URL getRemoteProgramURL(BSimMatchResult result) {
        String urlString = result.getExecutableURLString();
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            this.error("Bad URL: " + urlString, result);
            return null;
        }
    }

    private void displayTaskResults(boolean cancelled) {
        if (!this.hasErrorsOrIgnores()) {
            return;
        }
        BSimApplyResultsDisplayDialog resultsPanel = new BSimApplyResultsDisplayDialog(this.serviceProvider, this.applyResults, this.program);
        DockingWindowManager.showDialog((DialogComponentProvider)resultsPanel);
    }

    private boolean hasErrorsOrIgnores() {
        for (BSimApplyResult result : this.applyResults) {
            if (!result.isError() && !result.isIgnored()) continue;
            return true;
        }
        return false;
    }

    private void error(String message, BSimMatchResult result) {
        this.applyResults.add(new BSimApplyResult(result, BSimResultStatus.ERROR, message));
    }

    protected abstract boolean hasSameApplyData(List<Function> var1);

    protected abstract BSimApplyResult apply(Function var1, Function var2);
}

