/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.DialogComponentProvider;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.RowObjectTableModel;
import generic.lsh.vector.LSHVectorFactory;
import generic.theme.GIcon;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProvider;
import ghidra.app.services.FunctionComparisonService;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.features.bsim.gui.BSimSearchPlugin;
import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.filters.Md5BSimFilterType;
import ghidra.features.bsim.gui.search.dialog.BSimFilterSet;
import ghidra.features.bsim.gui.search.dialog.BSimSearchSettings;
import ghidra.features.bsim.gui.search.dialog.SelectedFunctionsTableDialog;
import ghidra.features.bsim.gui.search.results.BSimExecutablesSummaryModel;
import ghidra.features.bsim.gui.search.results.BSimMatchResult;
import ghidra.features.bsim.gui.search.results.BSimMatchResultsModel;
import ghidra.features.bsim.gui.search.results.BSimResultStatus;
import ghidra.features.bsim.gui.search.results.BSimSearchInfoDisplayDialog;
import ghidra.features.bsim.gui.search.results.BSimSearchResultsFilterDialog;
import ghidra.features.bsim.gui.search.results.ExecutableResult;
import ghidra.features.bsim.gui.search.results.FunctionComparisonException;
import ghidra.features.bsim.gui.search.results.apply.NameAndNamespaceBSimApplyTask;
import ghidra.features.bsim.gui.search.results.apply.SignatureBSimApplyTask;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.facade.SFQueryInfo;
import ghidra.features.bsim.query.facade.SFQueryResult;
import ghidra.features.bsim.query.protocol.BSimFilter;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Counter;
import ghidra.util.table.GhidraFilterTable;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.IntSupplier;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import resources.Icons;

public class BSimSearchResultsProvider
extends ComponentProviderAdapter {
    private static final Icon FUNCTIONS_ICON = new GIcon("icon.bsim.functions.table");
    private static final String PROVIDER_WINDOW_GROUP = "bsim.results";
    private static final String NAME = "BSim Search Results";
    private static final Icon SPLIT_VIEW_ICON = new GIcon("icon.bsim.table.split");
    private static final String APPLY_GROUP = "0";
    private BSimServerInfo serverInfo;
    private SFQueryInfo queryInfo;
    private Program program;
    private JComponent mainComponent;
    private JPanel mainPanel;
    private BSimMatchResultsModel matchesModel;
    private BSimExecutablesSummaryModel executablesModel;
    private DatabaseInformation dbInfo;
    private LSHVectorFactory lshVectorFactory;
    private BSimFilterSet postFilters = new BSimFilterSet();
    private List<BSimMatchResult> rows = new ArrayList<BSimMatchResult>();
    private GhidraFilterTable<BSimMatchResult> matchesTable;
    private JPanel matchesPanel;
    private GhidraFilterTable<ExecutableResult> executablesTable;
    private JPanel executablesPanel;
    private ToggleDockingAction showExecutableTableAction;
    private BSimSearchPlugin plugin;
    private DomainObjectListener listener = new MyDomainObjectListener();
    private BSimSearchSettings settings;

    public BSimSearchResultsProvider(BSimSearchPlugin plugin, PluginTool tool, BSimServerInfo serverInfo, DatabaseInformation dbInfo, LSHVectorFactory lshVectorFactory, SFQueryInfo queryInfo, BSimSearchSettings settings) {
        super(tool, NAME, plugin.getName());
        this.plugin = plugin;
        this.serverInfo = serverInfo;
        this.dbInfo = dbInfo;
        this.lshVectorFactory = lshVectorFactory;
        this.queryInfo = queryInfo;
        this.settings = settings;
        this.program = queryInfo.getProgram();
        this.setWindowGroup(PROVIDER_WINDOW_GROUP);
        this.setDefaultWindowPosition(WindowPosition.WINDOW);
        this.setTitle(NAME);
        this.setSubTitle(this.getIdString());
        this.setTabText("BSim " + this.getIdString());
        this.setWindowMenuGroup("BSim");
        this.setHelpLocation(new HelpLocation("BSimSearchPlugin", "Similar_Functions_Results"));
        this.setTransient();
        this.mainComponent = this.buildComponent();
        tool.addComponentProvider((ComponentProvider)this, true);
        this.createActions();
        this.matchesTable.installNavigation((GoToService)tool.getService(GoToService.class));
        this.matchesTable.setNavigateOnSelectionEnabled(true);
        this.program.addListener(this.listener);
    }

    public void componentHidden() {
        super.componentHidden();
        if (this.plugin != null) {
            this.plugin.providerClosed(this);
        }
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Search Info", this.getName()).toolBarIcon(Icons.INFO_ICON)).helpLocation(new HelpLocation("BSimSearchPlugin", "Search_Info_Action"))).onAction(c -> this.showSearchInfo())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Show Searched Functions", this.getName()).toolBarIcon(FUNCTIONS_ICON)).helpLocation(new HelpLocation("BSimSearchPlugin", "Searched_Functions"))).onAction(c -> this.showSearchedFunctions())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Filter Results", this.getName()).toolBarIcon(Icons.CONFIGURE_FILTER_ICON)).helpLocation(new HelpLocation("BSimSearchPlugin", "Filter_Results_Action"))).onAction(c -> this.showFilterPanel())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Filter Executable", this.getName()).popupMenuPath(new String[]{"Filter on this Executable"})).description("Filter on a specific executable in the function match table")).helpLocation(new HelpLocation("BSimSearchPlugin", "Filter_On_Executable"))).withContext(ExecutableTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() == 1).onAction(this::filterOnExecutable).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Load Executable", this.getName()).popupMenuPath(new String[]{"Load Executable"})).description("Load the selected executable into the Codebrowser")).helpLocation(new HelpLocation("BSimSearchPlugin", "Load_Executable"))).withContext(ExecutableTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() == 1).onAction(this::loadExecutable).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Compare Functions", this.getName()).popupMenuPath(new String[]{"Compare Functions"})).popupMenuGroup("1")).keyBinding("shift c")).sharedKeyBinding()).description("Compares the Functions with its remote match")).helpLocation(new HelpLocation("BSimSearchPlugin", "Compare_Functions"))).withContext(BSimMatchesTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() > 0).onAction(this::compareFunctions).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Apply Function Name", this.getName()).popupMenuPath(new String[]{"Apply Name"})).popupMenuGroup(APPLY_GROUP, "1")).helpLocation(new HelpLocation("BSimSearchPlugin", "Apply_Name"))).withContext(BSimMatchesTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() > 0).onAction(this::applyName).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Apply Function Signature", this.getName()).popupMenuPath(new String[]{"Apply Signature"})).popupMenuGroup(APPLY_GROUP, "2")).helpLocation(new HelpLocation("BSimSearchPlugin", "Apply_Signature"))).withContext(BSimMatchesTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() > 0).onAction(this::applySignature).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Apply Signature and Datatypes", this.getName()).popupMenuPath(new String[]{"Apply Signature and Data Types"})).popupMenuGroup(APPLY_GROUP, "3")).helpLocation(new HelpLocation("BSimSearchPlugin", "Apply_Signature_With_Datatypes"))).withContext(BSimMatchesTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() > 0).onAction(this::applySignatureWithDatatypes).buildAndInstallLocal((ComponentProvider)this);
        this.showExecutableTableAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Show Executables Table", this.getName()).toolBarIcon(SPLIT_VIEW_ICON)).description("Toggles showing Executables table")).helpLocation(new HelpLocation("BSimSearchPlugin", "Hide_Show_Executables_Table"))).selected(true).onAction(c -> this.showExecutableTable(this.showExecutableTableAction.isSelected()))).buildAndInstallLocal((ComponentProvider)this);
        this.addLocalAction((DockingActionIf)new SelectionNavigationAction((Plugin)this.plugin, this.matchesTable.getTable()));
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Clear BSim Error Status", this.getName()).popupMenuPath(new String[]{"Clear error status"})).helpLocation(new HelpLocation("BSimSearchPlugin", "Clear_Error_Status"))).withContext(BSimMatchesTableActionContext.class).enabledWhen(this::canClearErrors).onAction(this::clearErrors).buildAndInstallLocal((ComponentProvider)this);
    }

    private void applyName(BSimMatchesTableActionContext c) {
        List selected = this.matchesTable.getSelectedRowObjects();
        NameAndNamespaceBSimApplyTask task = new NameAndNamespaceBSimApplyTask(this.program, selected, (ServiceProvider)this.dockingTool);
        TaskLauncher.launch((Task)task);
        this.matchesModel.fireTableDataChanged();
    }

    private void applySignature(BSimMatchesTableActionContext c) {
        List selected = this.matchesTable.getSelectedRowObjects();
        SignatureBSimApplyTask task = new SignatureBSimApplyTask(this.program, selected, true, (ServiceProvider)this.dockingTool);
        TaskLauncher.launch((Task)task);
        this.matchesModel.fireTableDataChanged();
    }

    private void applySignatureWithDatatypes(BSimMatchesTableActionContext c) {
        List selected = this.matchesTable.getSelectedRowObjects();
        SignatureBSimApplyTask task = new SignatureBSimApplyTask(this.program, selected, false, (ServiceProvider)this.dockingTool);
        TaskLauncher.launch((Task)task);
        this.matchesModel.fireTableDataChanged();
    }

    private boolean canClearErrors(BSimMatchesTableActionContext c) {
        int rowCount = c.getSelectedRowCount();
        if (rowCount == 0) {
            return false;
        }
        if (rowCount == 1) {
            BSimMatchResult selectedRowObject = (BSimMatchResult)this.matchesTable.getSelectedRowObject();
            return selectedRowObject.getStatus() == BSimResultStatus.ERROR;
        }
        return true;
    }

    private void clearErrors(BSimMatchesTableActionContext c) {
        List selected = this.matchesTable.getSelectedRowObjects();
        for (BSimMatchResult result : selected) {
            if (result.getStatus() != BSimResultStatus.ERROR) continue;
            result.setStatus(BSimResultStatus.NOT_APPLIED);
        }
        this.matchesModel.fireTableDataChanged();
    }

    private void compareFunctions(BSimMatchesTableActionContext c) {
        FunctionComparisonService service = (FunctionComparisonService)this.tool.getService(FunctionComparisonService.class);
        if (service == null) {
            Msg.error((Object)((Object)this), (Object)"Function Comparison Service not found!");
            return;
        }
        FunctionComparisonProvider comparisonProvider = service.createFunctionComparisonProvider();
        comparisonProvider.removeAddFunctionsAction();
        List selectedRowObjects = this.matchesTable.getSelectedRowObjects();
        HashSet<Program> openedPrograms = new HashSet<Program>();
        for (BSimMatchResult row : selectedRowObjects) {
            try {
                Function originalFunction = this.getOriginalFunction(row);
                Function matchFunction = this.getMatchFunction(row, openedPrograms);
                comparisonProvider.getModel().compareFunctions(originalFunction, matchFunction);
            }
            catch (FunctionComparisonException e) {
                Msg.showError((Object)((Object)this), null, (String)"Unable to Compare Functions", (Object)("Compare Functions: " + e.getMessage()));
            }
        }
        comparisonProvider.setCloseListener(() -> {
            for (Program remote : openedPrograms) {
                remote.release((Object)this);
            }
        });
    }

    private void filterOnExecutable(ExecutableTableActionContext c) {
        ExecutableRecord exerecord = c.getSelectedExecutableResult().getExecutableRecord();
        Md5BSimFilterType filterType = new Md5BSimFilterType();
        this.postFilters.removeAll(filterType);
        this.postFilters.addEntry(filterType, List.of(exerecord.getMd5()));
        this.updateTableData();
    }

    private void loadExecutable(ExecutableTableActionContext c) {
        ExecutableResult result = c.getSelectedExecutableResult();
        ExecutableRecord record = result.getExecutableRecord();
        String programUrl = record.getURLString();
        this.openRemoteProgramInTool(programUrl);
    }

    private void showFilterPanel() {
        List<BSimFilterType> filters = BSimFilterType.generateBsimFilters(this.dbInfo, false);
        BSimSearchResultsFilterDialog filterDialog = new BSimSearchResultsFilterDialog(filters, this.postFilters);
        this.tool.showDialog((DialogComponentProvider)filterDialog);
        BSimFilterSet results = filterDialog.getFilters();
        if (results != null) {
            this.postFilters = results;
            this.updateTableData();
        }
    }

    private void updateTableData() {
        BSimFilter filter = this.postFilters.getBSimFilter();
        List<BSimMatchResult> filteredrows = BSimMatchResult.filterMatchRows(filter, this.rows);
        TreeSet<ExecutableResult> execrows = ExecutableResult.generateFromMatchRows(filteredrows);
        this.matchesModel.reload(this.program, filteredrows);
        this.executablesModel.reload(this.program, execrows);
    }

    private void showSearchInfo() {
        this.tool.showDialog((DialogComponentProvider)new BSimSearchInfoDisplayDialog(this.serverInfo, this.settings, false));
    }

    private void showSearchedFunctions() {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        HelpLocation help = new HelpLocation("BSimSearchPlugin", "Searched_Functions");
        this.tool.showDialog((DialogComponentProvider)new SelectedFunctionsTableDialog(this.queryInfo.getFunctions(), service, help, this.getFunctionMatchCount()));
    }

    private Map<Address, Integer> getFunctionMatchCount() {
        Counter counter;
        HashMap<Address, Counter> map = new HashMap<Address, Counter>();
        for (BSimMatchResult result : this.rows) {
            Address address = result.getAddress();
            counter = map.computeIfAbsent(address, a -> new Counter());
            counter.increment();
        }
        HashMap<Address, Integer> countMap = new HashMap<Address, Integer>();
        for (FunctionSymbol functionSymbol : this.queryInfo.getFunctions()) {
            counter = (Counter)map.get(functionSymbol.getAddress());
            countMap.put(functionSymbol.getAddress(), counter == null ? 0 : counter.count());
        }
        return countMap;
    }

    private JComponent buildComponent() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(1000, 800));
        this.matchesModel = new BSimMatchResultsModel(this.tool, this.dbInfo, this.lshVectorFactory);
        this.matchesTable = new GhidraFilterTable((RowObjectTableModel)this.matchesModel);
        this.matchesPanel = this.buildTitledTablePanel("Function Matches", this.matchesTable, () -> this.rows.size());
        this.executablesModel = new BSimExecutablesSummaryModel(this.tool, this.dbInfo);
        this.executablesTable = new GhidraFilterTable((RowObjectTableModel)this.executablesModel);
        this.executablesPanel = this.buildTitledTablePanel("Executables", this.executablesTable, () -> this.executablesModel.getUnfilteredRowCount());
        this.showExecutableTable(true);
        return this.mainPanel;
    }

    private void showExecutableTable(boolean selected) {
        this.mainPanel.removeAll();
        if (selected) {
            JSplitPane split = new JSplitPane(0, this.matchesPanel, this.executablesPanel);
            split.setResizeWeight(0.5);
            split.setDividerSize(10);
            this.mainPanel.add((Component)split, "Center");
        } else {
            this.mainPanel.add((Component)this.matchesPanel, "Center");
        }
        this.mainPanel.validate();
    }

    public JComponent getComponent() {
        return this.mainComponent;
    }

    private String getIdString() {
        String serverShortName = this.serverInfo.getShortDBName();
        StringBuilder builder = new StringBuilder("[server: ");
        builder.append(serverShortName);
        builder.append(", function: ");
        Set<FunctionSymbol> functions = this.queryInfo.getFunctions();
        if (functions.size() == 1) {
            builder.append(functions.iterator().next().getName());
        } else {
            builder.append(functions.size() + " selected");
        }
        builder.append(", Similarity: ");
        builder.append(this.queryInfo.getSimilarityThreshold());
        builder.append(", Confidence: ");
        builder.append(this.queryInfo.getSignificanceThreshold());
        builder.append("]");
        return builder.toString();
    }

    public void setFinalQueryResults(SFQueryResult result) {
        this.rows = BSimMatchResult.generate(result.getSimilarityResults(), this.program);
        this.updateTableData();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (event != null) {
            return this.getActionContext(event.getSource());
        }
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return this.getActionContext(kfm.getFocusOwner());
    }

    private ActionContext getActionContext(Object source) {
        if (source == this.matchesTable.getTable()) {
            return new BSimMatchesTableActionContext();
        }
        if (source == this.executablesTable.getTable()) {
            return new ExecutableTableActionContext();
        }
        return new DefaultActionContext((ComponentProvider)this);
    }

    private Program openRemoteProgramInTool(String urlString) {
        ProgramManager service = (ProgramManager)this.tool.getService(ProgramManager.class);
        try {
            URL url = new URL(urlString);
            return service.openProgram(url, 1);
        }
        catch (MalformedURLException exc) {
            return null;
        }
    }

    private Program getCachedRemoteProgram(String urlString, Set<Program> openedPrograms) {
        ProgramManager service = (ProgramManager)this.tool.getService(ProgramManager.class);
        try {
            URL url = new URL(urlString);
            Program remote = service.openCachedProgram(url, (Object)this);
            if (remote == null) {
                return null;
            }
            if (!openedPrograms.add(remote)) {
                remote.release((Object)this);
            }
            return remote;
        }
        catch (MalformedURLException exc) {
            return null;
        }
    }

    private JPanel buildTitledTablePanel(String title, GhidraFilterTable<?> table, IntSupplier nonFilteredRowCount) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 2, 10, 2));
        JLabel titleLabel = new JLabel(title);
        panel.add((Component)titleLabel, "North");
        panel.add((Component)table, "Center");
        RowObjectTableModel model = table.getModel();
        model.addTableModelListener(e -> {
            int rowCount = model.getRowCount();
            String text = title + "  - " + rowCount + " results";
            int nonFilteredSize = nonFilteredRowCount.getAsInt();
            if (nonFilteredSize != rowCount) {
                text = text + "   (Filtered from " + nonFilteredSize + " results)";
            }
            titleLabel.setText(text);
        });
        return panel;
    }

    private Function getOriginalFunction(BSimMatchResult resultRow) throws FunctionComparisonException {
        Address originalEntryPoint = resultRow.getAddress();
        FunctionManager originalFunctionManager = this.program.getFunctionManager();
        Function originalFunction = originalFunctionManager.getFunctionAt(originalEntryPoint);
        if (originalFunction == null) {
            throw new FunctionComparisonException("Couldn't get local function " + resultRow.getOriginalFunctionDescription().getFunctionName() + " at " + originalEntryPoint.toString() + ".");
        }
        return originalFunction;
    }

    private Function getMatchFunction(BSimMatchResult resultRow, Set<Program> opened) throws FunctionComparisonException {
        Program matchProgram = this.getCachedRemoteProgram(resultRow.getExecutableURLString(), opened);
        if (matchProgram == null) {
            throw new FunctionComparisonException("Couldn't open remote program: " + resultRow.getExecutableURLString() + " for " + resultRow.getSimilarFunctionName() + ".");
        }
        FunctionDescription matchFunctionDescription = resultRow.getMatchFunctionDescription();
        long matchOffset = matchFunctionDescription.getAddress();
        Address matchEntryPoint = matchProgram.getAddressFactory().getDefaultAddressSpace().getAddress(matchOffset);
        FunctionManager matchFunctionManager = matchProgram.getFunctionManager();
        Function matchFunction = matchFunctionManager.getFunctionAt(matchEntryPoint);
        if (matchFunction == null) {
            throw new FunctionComparisonException("Couldn't get remote function " + matchFunctionDescription.getFunctionName() + " at " + matchEntryPoint + ".");
        }
        return matchFunction;
    }

    public Program getProgram() {
        return this.program;
    }

    BSimMatchResultsModel getMatchesModel() {
        return this.matchesModel;
    }

    BSimExecutablesSummaryModel getExecutablesModel() {
        return this.executablesModel;
    }

    private class MyDomainObjectListener
    implements DomainObjectListener {
        private MyDomainObjectListener() {
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            if (ev.containsEvent(46) || ev.containsEvent(4)) {
                BSimSearchResultsProvider.this.matchesModel.fireTableDataChanged();
            }
        }
    }

    private class ExecutableTableActionContext
    extends DefaultActionContext {
        ExecutableTableActionContext() {
            super((ComponentProvider)BSimSearchResultsProvider.this);
        }

        public ExecutableResult getSelectedExecutableResult() {
            return (ExecutableResult)BSimSearchResultsProvider.this.executablesTable.getSelectedRowObject();
        }

        public int getSelectedRowCount() {
            return BSimSearchResultsProvider.this.executablesTable.getTable().getSelectedRowCount();
        }
    }

    private class BSimMatchesTableActionContext
    extends DefaultActionContext {
        BSimMatchesTableActionContext() {
            super((ComponentProvider)BSimSearchResultsProvider.this);
        }

        public int getSelectedRowCount() {
            return BSimSearchResultsProvider.this.matchesTable.getTable().getSelectedRowCount();
        }
    }
}

