/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbModuleSection;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetModule;
import agent.gdb.model.impl.GdbModelTargetSectionContainer;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSection;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Section", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetSection
extends DefaultTargetObject<TargetObject, GdbModelTargetSectionContainer>
implements TargetSection {
    public static final String VISIBLE_RANGE_ATTRIBUTE_NAME = "range";
    protected final GdbModelImpl impl;
    protected final GdbModuleSection section;
    protected final GdbModelTargetModule module;
    protected final AddressRange range;

    protected static String indexSection(GdbModuleSection section) {
        return section.getName();
    }

    protected static String keySection(GdbModuleSection section) {
        return PathUtils.makeKey((String)GdbModelTargetSection.indexSection(section));
    }

    public GdbModelTargetSection(GdbModelTargetSectionContainer sections, GdbModelTargetModule module, GdbModuleSection section) {
        super((AbstractDebuggerObjectModel)sections.impl, (TargetObject)sections, GdbModelTargetSection.keySection(section), "Section");
        this.impl = sections.impl;
        this.section = section;
        this.impl.addModelObject(section, (TargetObject)this);
        this.module = module;
        this.range = this.doGetRange();
        this.changeAttributes(List.of(), List.of(), Map.of("_module", module, "_range", this.range, VISIBLE_RANGE_ATTRIBUTE_NAME, this.range, "_display", section.getName()), "Initialized");
    }

    public GdbModelTargetModule getModule() {
        return this.module;
    }

    protected AddressRange doGetRange() {
        if (this.section.getVmaStart() == this.section.getVmaEnd()) {
            return null;
        }
        Address min = this.impl.space.getAddress(this.section.getVmaStart());
        Address max = this.impl.space.getAddress(this.section.getVmaEnd() - 1L);
        return new AddressRangeImpl(min, max);
    }

    public AddressRange getRange() {
        return this.range;
    }

    @TargetAttributeType(name="range")
    public AddressRange getVisibleRange() {
        return this.range;
    }

    public String getDisplay() {
        return this.section.getName();
    }
}

