/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemConsideredStatus;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.util.AddressCorrelation;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;

public class ClearMatchTask
extends VtTask {
    private final List<VTMatch> matches;
    protected final VTController controller;

    public ClearMatchTask(VTController controller, List<VTMatch> matches) {
        super("Clear Matches", controller.getSession());
        this.controller = controller;
        this.matches = matches;
        if (!(this.session instanceof VTSessionDB)) {
            throw new IllegalArgumentException("Unexpected condition - VTSession is not a DB object!");
        }
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        this.clearMatches(monitor);
        return true;
    }

    private void clearMatches(TaskMonitor monitor) throws CancelledException, VersionTrackingApplyException {
        monitor.setMessage("Clearing matches");
        monitor.initialize((long)this.matches.size());
        for (VTMatch match : this.matches) {
            monitor.checkCancelled();
            VTAssociation association = match.getAssociation();
            VTAssociationStatus status = association.getStatus();
            if (status == VTAssociationStatus.BLOCKED || status == VTAssociationStatus.AVAILABLE) continue;
            this.removeAppliedMarkup(match, monitor);
            this.clearMatch(match);
            monitor.incrementProgress(1L);
        }
        monitor.setProgress((long)this.matches.size());
    }

    private void removeAppliedMarkup(VTMatch match, TaskMonitor monitor) throws CancelledException, VersionTrackingApplyException {
        MatchInfo matchInfo = this.controller.getMatchInfo(match);
        Collection<VTMarkupItem> markupItems = matchInfo.getAppliableMarkupItems(monitor);
        AddressCorrelation correlation = this.getCorrelation(matchInfo);
        if (correlation == null) {
            return;
        }
        for (VTMarkupItem item : markupItems) {
            monitor.checkCancelled();
            this.maybeUnapply(item);
            this.maybeClearStatus(item);
            this.maybeResetDestinationAddressToDefault(item, correlation, monitor);
        }
    }

    private AddressCorrelation getCorrelation(MatchInfo matchInfo) {
        VTAssociationType type = matchInfo.getMatch().getAssociation().getType();
        if (type == VTAssociationType.FUNCTION) {
            Function source = matchInfo.getSourceFunction();
            Function destination = matchInfo.getDestinationFunction();
            if (source == null || destination == null) {
                return null;
            }
            return this.controller.getCorrelator(source, destination);
        }
        if (type == VTAssociationType.DATA) {
            Data source = matchInfo.getSourceData();
            Data destination = matchInfo.getDestinationData();
            if (source == null || destination == null) {
                return null;
            }
            return this.controller.getCorrelator(source, destination);
        }
        return null;
    }

    private void maybeUnapply(VTMarkupItem markupItem) throws VersionTrackingApplyException {
        if (markupItem.canUnapply()) {
            markupItem.unapply();
        }
    }

    private void maybeClearStatus(VTMarkupItem markupItem) {
        VTMarkupItemStatus status = markupItem.getStatus();
        if (!status.isDefault() && !status.isUnappliable()) {
            markupItem.setConsidered(VTMarkupItemConsideredStatus.UNCONSIDERED);
        }
    }

    private void maybeResetDestinationAddressToDefault(VTMarkupItem markupItem, AddressCorrelation correlation, TaskMonitor monitor) throws CancelledException {
        if (correlation == null) {
            return;
        }
        Address destinationAddress = null;
        AddressRange range = correlation.getCorrelatedDestinationRange(markupItem.getSourceAddress(), monitor);
        if (range != null) {
            destinationAddress = range.getMinAddress();
        }
        markupItem.setDefaultDestinationAddress(destinationAddress, correlation.getName());
    }

    private void clearMatch(VTMatch match) {
        VTAssociation association = match.getAssociation();
        try {
            association.clearStatus();
        }
        catch (VTAssociationStatusException e) {
            throw new AssertException("Should not have been given an association to clear when it is not already accepted or rejected - current status: " + association.getStatus());
        }
    }
}

