/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SummaryHeader
implements StructConverter {
    public static final String NAME = "PAGEDUMP_SUMMARY";
    public static final int SIGNATURE = 1162297680;
    private int signature;
    private int validDump;
    private int dumpOptions;
    private int headerSize;
    private int bitmapSize;
    private int pages;
    private int sizeOfBitMap;
    private int[] buffer;
    private DumpFileReader reader;
    private long index;

    SummaryHeader(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setSignature(this.reader.readNextInt());
        this.setValidDump(this.reader.readNextInt());
        this.setDumpOptions(this.reader.readNextInt());
        this.setHeaderSize(this.reader.readNextInt());
        this.setBitmapSize(this.reader.readNextInt());
        this.setSizeOfBitMap(this.reader.readNextInt());
        this.reader.readNextLong();
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(STRING, 4, "Signature", null);
        struct.add(STRING, 4, "ValidDump", null);
        struct.add(DWORD, 4, "DumpOptions", null);
        struct.add(DWORD, 4, "HeaderSize", null);
        struct.add(DWORD, 4, "BitmapSize", null);
        struct.add(DWORD, 4, "Pages", null);
        StructureDataType s0 = new StructureDataType("RTL_BITMAP", 0);
        s0.add(DWORD, 4, "SizeOfBitMap", null);
        if (this.sizeOfBitMap > 0) {
            s0.add(QWORD, 8, "", null);
            ArrayDataType a = new ArrayDataType(BYTE, this.sizeOfBitMap, 1);
            s0.add((DataType)a, a.getLength(), "Buffer", null);
        }
        struct.add((DataType)s0, s0.getLength(), "BitMap", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public int getSignature() {
        return this.signature;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    public int getValidDump() {
        return this.validDump;
    }

    public void setValidDump(int validDump) {
        this.validDump = validDump;
    }

    public int getDumpOptions() {
        return this.dumpOptions;
    }

    public void setDumpOptions(int dumpOptions) {
        this.dumpOptions = dumpOptions;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public int getBitmapSize() {
        return this.bitmapSize;
    }

    public void setBitmapSize(int bitmapSize) {
        this.bitmapSize = bitmapSize;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public int getSizeOfBitMap() {
        return this.sizeOfBitMap;
    }

    public void setSizeOfBitMap(int sizeOfBitMap) {
        this.sizeOfBitMap = sizeOfBitMap;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int[] buffer) {
        this.buffer = buffer;
    }
}

