/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.analyzer;

import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.cdex.CDexConstants;
import ghidra.file.formats.android.dex.analyzer.DexAnalysisState;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;

public class DexMarkupDataAnalyzer
extends FileFormatAnalyzer {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMaximum(set == null ? program.getMemory().getSize() : set.getNumAddresses());
        monitor.setProgress(0L);
        DexAnalysisState analysisState = DexAnalysisState.getState(program);
        DexHeader header = analysisState.getHeader();
        int headerLength = header.toDataType().getLength();
        Listing listing = program.getListing();
        DataIterator dataIterator = listing.getDefinedData(set, true);
        while (dataIterator.hasNext()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            Data data = dataIterator.next();
            if (data.getMinAddress().getOffset() == 0L) continue;
            monitor.setMessage("DEX: Data markup ... " + data.getMinAddress());
            if (!data.isStructure()) continue;
            this.processData(data, headerLength, monitor);
        }
        return true;
    }

    public boolean canAnalyze(Program program) {
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        return DexConstants.isDexFile((ByteProvider)provider) || CDexConstants.isCDEX(program);
    }

    @Override
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.DATA_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Android DEX/CDEX Data Markup";
    }

    public String getName() {
        return "Android DEX/CDEX Data Markup";
    }

    @Override
    public AnalysisPriority getPriority() {
        return new AnalysisPriority(5);
    }

    public boolean isPrototype() {
        return false;
    }

    private void processData(Data data, int headerLength, TaskMonitor monitor) throws Exception {
        for (int i = 0; i < data.getNumComponents(); ++i) {
            Scalar scalar;
            monitor.checkCancelled();
            Data component = data.getComponent(i);
            if (component.getNumComponents() > 0) {
                this.processData(component, headerLength, monitor);
            }
            if (component.getReferencesFrom().length > 0 || component.getFieldName().toLowerCase().indexOf("offset") == -1 || (scalar = component.getScalar(0)).getUnsignedValue() < (long)headerLength) continue;
            Address destination = component.getMinAddress().getNewAddress(scalar.getUnsignedValue());
            Program program = component.getProgram();
            ReferenceManager referenceManager = program.getReferenceManager();
            referenceManager.addMemoryReference(component.getMinAddress(), destination, RefType.DATA, SourceType.ANALYSIS, 0);
        }
    }
}

