/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.android.bootimg.BootImageHeader;
import ghidra.file.formats.android.bootimg.BootImageHeaderV0;
import ghidra.file.formats.android.bootimg.BootImageHeaderV1;
import ghidra.file.formats.android.bootimg.BootImageHeaderV2;
import ghidra.file.formats.android.bootimg.BootImageHeaderV3;
import ghidra.file.formats.android.bootimg.BootImageHeaderV4;
import ghidra.file.formats.android.bootimg.BootImageUtil;
import java.io.IOException;

public final class BootImageHeaderFactory {
    public static final BootImageHeader getBootImageHeader(ByteProvider provider, boolean littleEndian) throws IOException {
        return BootImageHeaderFactory.getBootImageHeader(new BinaryReader(provider, littleEndian));
    }

    public static final BootImageHeader getBootImageHeader(BinaryReader reader) throws IOException {
        if (!BootImageUtil.isBootImage(reader)) {
            throw new IOException("BootImageHeader magic not found.");
        }
        int version = reader.readInt(40L);
        switch (version) {
            case 0: {
                return new BootImageHeaderV0(reader);
            }
            case 1: {
                return new BootImageHeaderV1(reader);
            }
            case 2: {
                return new BootImageHeaderV2(reader);
            }
            case 3: {
                return new BootImageHeaderV3(reader);
            }
            case 4: {
                return new BootImageHeaderV4(reader);
            }
        }
        throw new IOException("BootImageHeader unsupported version found: " + version);
    }
}

