/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bsfv;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.decompiler.CTokenHighlightMatcher;
import ghidra.app.decompiler.DecompilerHighlightService;
import ghidra.app.decompiler.DecompilerHighlighter;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.bsfv.BSimFeatureGraphDisplayOptions;
import ghidra.bsfv.BSimFeatureGraphType;
import ghidra.bsfv.BSimFeatureVisualizerPlugin;
import ghidra.bsfv.BsfvGraphDisplayListener;
import ghidra.bsfv.BsfvRowObject;
import ghidra.bsfv.BsfvTableModel;
import ghidra.bsfv.BsfvTableProvider;
import ghidra.bsfv.BsfvTokenHighlightMatcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.GraphException;
import ghidra.util.table.GhidraTable;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;

public class HighlightAndGraphAction
extends DockingAction {
    public static final String BSIM_FEATURE_HIGHLIGHTER_NAME = "BSimFeatureHighlighter";
    public static final String NAME = "Highlight and Graph";
    private BsfvTableProvider provider;
    private BSimFeatureVisualizerPlugin plugin;
    private GraphType featureGraphType;
    private GraphDisplayOptions featureGraphOptions;
    private AttributedGraph featureGraph;

    public HighlightAndGraphAction(BsfvTableProvider provider, BSimFeatureVisualizerPlugin plugin) {
        super(NAME, plugin.getName());
        this.provider = provider;
        this.plugin = plugin;
        this.featureGraphType = new BSimFeatureGraphType();
        this.featureGraphOptions = new BSimFeatureGraphDisplayOptions(this.featureGraphType, (Tool)plugin.getTool());
        this.setPopupMenuData(new MenuData(new String[]{NAME}));
        this.setDescription("Create a graph and decompiler highlight for this BSim feature");
        HelpLocation help = new HelpLocation(plugin.getName(), "Visualizing_BSim_Features");
        this.setHelpLocation(help);
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.provider.getModel().getLastSelectedObjects().size() > 0;
    }

    public void actionPerformed(ActionContext context) {
        GraphDisplayBroker graphDisplayBroker = (GraphDisplayBroker)this.plugin.getTool().getService(GraphDisplayBroker.class);
        if (graphDisplayBroker == null) {
            Msg.showError((Object)((Object)this), (Component)this.plugin.getTool().getToolFrame(), (String)"BSimFeatureVisualizer Error", (Object)"No graph display providers found: Please add a graph display provider to your tool");
            return;
        }
        GhidraTable bsimFeatureTable = this.provider.getTable();
        BsfvTableModel model = this.provider.getModel();
        if (bsimFeatureTable.getSelectedRow() == -1) {
            return;
        }
        PcodeOpAST pcode = model.getOpAt(bsimFeatureTable.getSelectedRow());
        PcodeOpAST previousPcode = model.getPreviousOpAt(bsimFeatureTable.getSelectedRow());
        this.featureGraph = new AttributedGraph("BSim Feature Graph", this.featureGraphType);
        StringBuilder graphName = new StringBuilder();
        switch (model.getFeatureTypeAt(bsimFeatureTable.getSelectedRow())) {
            case DATA_FLOW: {
                this.addDataFlowFeatureGraph(pcode, BSimFeatureGraphType.DATAFLOW_WINDOW_SIZE, this.featureGraph, true);
                graphName.append("DATA(");
                graphName.append(pcode.getMnemonic());
                graphName.append(")@");
                graphName.append(pcode.getSeqnum().getTarget());
                break;
            }
            case CONTROL_FLOW: {
                int blockIndex = model.getBlockIndexAt(bsimFeatureTable.getSelectedRow());
                this.addControlFlowFeatureGraph(blockIndex, this.featureGraph);
                graphName.append("CONTROL@");
                graphName.append(model.getBasicBlockStart(bsimFeatureTable.getSelectedRow()));
                break;
            }
            case COMBINED: {
                int blockIndex = model.getBlockIndexAt(bsimFeatureTable.getSelectedRow());
                this.addControlFlowFeatureGraph(blockIndex, this.featureGraph);
                this.addDataFlowFeatureGraph(pcode, 1 + BSimFeatureGraphType.DATAFLOW_WINDOW_SIZE / 2, this.featureGraph, true);
                graphName.append("COMBINED(");
                graphName.append(pcode.getMnemonic());
                graphName.append(")@");
                graphName.append(pcode.getSeqnum().getTarget());
                break;
            }
            case DUAL_FLOW: {
                this.addDataFlowFeatureGraph(pcode, 1 + BSimFeatureGraphType.DATAFLOW_WINDOW_SIZE / 2, this.featureGraph, true);
                this.addDataFlowFeatureGraph(previousPcode, 1 + BSimFeatureGraphType.DATAFLOW_WINDOW_SIZE / 2, this.featureGraph, false);
                graphName.append("DUAL(");
                graphName.append(pcode.getMnemonic());
                graphName.append(",");
                graphName.append(previousPcode.getMnemonic());
                graphName.append(")@");
                graphName.append(pcode.getSeqnum().getTarget());
                break;
            }
            case COPY_SIG: {
                int blockIndex = model.getBlockIndexAt(bsimFeatureTable.getSelectedRow());
                this.addCopySigFeatureGraph(blockIndex, this.featureGraph);
                graphName.append("COPY_SIG@");
                graphName.append(model.getBasicBlockStart(bsimFeatureTable.getSelectedRow()));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        GraphDisplay graphDisplay = null;
        try {
            boolean reuseGraph = this.plugin.getReuseGraph();
            graphDisplay = graphDisplayBroker.getDefaultGraphDisplay(reuseGraph, TaskMonitor.DUMMY);
        }
        catch (GraphException e) {
            Msg.showError((Object)((Object)this), null, (String)"Graph Error", (Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (graphDisplay == null) {
            Msg.showError((Object)((Object)this), null, (String)"null GraphDisplay", (Object)"null GraphDisplay");
        } else {
            try {
                graphDisplay.setGraph(this.featureGraph, this.featureGraphOptions, graphName.toString(), false, TaskMonitor.DUMMY);
                graphDisplay.setGraphDisplayListener((GraphDisplayListener)new BsfvGraphDisplayListener(this.plugin.getTool(), this.plugin.getCurrentProgram(), graphDisplay));
            }
            catch (CancelledException e) {
                return;
            }
        }
        DecompilerHighlightService highlightService = this.plugin.getDecompilerHighlightService();
        if (highlightService == null) {
            Msg.showError((Object)((Object)this), null, (String)"DecompilerHighlightService not found", (Object)"DecompilerHighlightService not found");
        } else if (!this.plugin.getHighlightByRow()) {
            BsfvTokenHighlightMatcher tokenMatcher = new BsfvTokenHighlightMatcher((BsfvRowObject)model.getRowObject(bsimFeatureTable.getSelectedRow()), model.getHighFunction(), this.plugin);
            DecompilerHighlighter highlighter = highlightService.createHighlighter(BSIM_FEATURE_HIGHLIGHTER_NAME, (CTokenHighlightMatcher)tokenMatcher);
            highlighter.applyHighlights();
        }
    }

    AttributedGraph getGraph() {
        return this.featureGraph;
    }

    private void addCopySigFeatureGraph(int blockIndex, AttributedGraph graph) {
        AttributedVertex baseBlockVertex = graph.addVertex("copy" + Integer.toString(blockIndex));
        HighFunction hfunction = this.provider.getModel().getHighFunction();
        PcodeBlockBasic basicBlock = (PcodeBlockBasic)hfunction.getBasicBlocks().get(blockIndex);
        this.setVertexTypeAndAttributes(baseBlockVertex, (PcodeBlock)basicBlock, "Copy Signature");
    }

    private void addControlFlowFeatureGraph(Integer baseBlockIndex, AttributedGraph graph) {
        int i;
        HashMap<Integer, AttributedVertex> indicesToVertices = new HashMap<Integer, AttributedVertex>();
        HighFunction hfunction = this.provider.getModel().getHighFunction();
        ArrayList bBlocks = hfunction.getBasicBlocks();
        PcodeBlockBasic baseBlock = (PcodeBlockBasic)bBlocks.get(baseBlockIndex);
        if (baseBlock.getStart() == null || baseBlock.getStop() == null) {
            Msg.info((Object)((Object)this), (Object)("null base block: baseBlockIndex " + baseBlockIndex));
            return;
        }
        AttributedVertex baseBlockVertex = graph.addVertex("cf" + Integer.toString(baseBlockIndex));
        this.setVertexTypeAndAttributes(baseBlockVertex, (PcodeBlock)baseBlock, "Base Block");
        indicesToVertices.put(baseBlockIndex, baseBlockVertex);
        int numParents = baseBlock.getInSize();
        for (i = 0; i < numParents; ++i) {
            int j;
            PcodeBlock parentBlock = baseBlock.getIn(i);
            AttributedVertex parentVertex = indicesToVertices.computeIfAbsent(parentBlock.getIndex(), x -> graph.addVertex("cf" + Integer.toString(parentBlock.getIndex())));
            this.setVertexTypeAndAttributes(parentVertex, parentBlock, "Parent Block");
            this.addGraphEdge(graph, parentBlock, parentVertex, (PcodeBlock)baseBlock, baseBlockVertex);
            int numGrandParents = parentBlock.getInSize();
            for (j = 0; j < numGrandParents; ++j) {
                PcodeBlock grandParentBlock = parentBlock.getIn(j);
                AttributedVertex grandParentVertex = indicesToVertices.computeIfAbsent(grandParentBlock.getIndex(), x -> graph.addVertex("cf" + Integer.toString(grandParentBlock.getIndex())));
                this.setVertexTypeAndAttributes(grandParentVertex, grandParentBlock, "Grandparent Block");
                this.addGraphEdge(graph, grandParentBlock, grandParentVertex, parentBlock, parentVertex);
            }
            int numSiblings = parentBlock.getOutSize();
            for (j = 0; j < numSiblings; ++j) {
                PcodeBlock siblingBlock = parentBlock.getOut(j);
                if (siblingBlock.equals(baseBlock)) continue;
                AttributedVertex siblingVertex = indicesToVertices.computeIfAbsent(siblingBlock.getIndex(), x -> graph.addVertex("cf" + Integer.toString(siblingBlock.getIndex())));
                this.setVertexTypeAndAttributes(siblingVertex, siblingBlock, "Sibling Block");
                this.addGraphEdge(graph, parentBlock, parentVertex, siblingBlock, siblingVertex);
            }
        }
        int numChildren = baseBlock.getOutSize();
        for (i = 0; i < numChildren; ++i) {
            PcodeBlock childBlock = baseBlock.getOut(i);
            AttributedVertex childVertex = indicesToVertices.computeIfAbsent(childBlock.getIndex(), x -> graph.addVertex("cf" + Integer.toString(childBlock.getIndex())));
            this.setVertexTypeAndAttributes(childVertex, childBlock, "Child Block");
            this.addGraphEdge(graph, (PcodeBlock)baseBlock, baseBlockVertex, childBlock, childVertex);
        }
    }

    private void setVertexTypeAndAttributes(AttributedVertex vertex, PcodeBlock block, String vertexType) {
        String existingType = vertex.getVertexType();
        if (existingType != null) {
            if (!existingType.equals(vertexType) && !existingType.equals("Base Block")) {
                vertex.setVertexType("BSim Neighbor Block");
            }
            return;
        }
        vertex.setVertexType(vertexType);
        vertex.setAttribute("Block Start", block.getStart().toString());
        vertex.setAttribute("Block Stop", block.getStop().toString());
        vertex.setAttribute("Call String", this.provider.getModel().getCallString(block.getIndex()));
    }

    private void addGraphEdge(AttributedGraph graph, PcodeBlock sourceBlock, AttributedVertex sourceVertex, PcodeBlock targetBlock, AttributedVertex targetVertex) {
        AttributedEdge edge = graph.addEdge(sourceVertex, targetVertex);
        if (sourceBlock.getOutSize() != 2) {
            edge.setEdgeType("Default");
            return;
        }
        if (sourceBlock.getFalseOut().equals(targetBlock)) {
            edge.setEdgeType("False");
        } else {
            edge.setEdgeType("True");
        }
    }

    private AttributedVertex addDataFlowFeatureGraph(PcodeOpAST pcode, int windowSize, AttributedGraph graph, boolean primaryBase) {
        LinkedList<DataflowQueueElement> varnodes = new LinkedList<DataflowQueueElement>();
        VarnodeAST vn = (VarnodeAST)pcode.getOutput();
        Set<PcodeOpAST> featuredOps = this.provider.getModel().getFeaturedOps();
        HashMap<VarnodeAST, AttributedVertex> varnodesToVertices = new HashMap<VarnodeAST, AttributedVertex>();
        HashMap<PcodeOpAST, AttributedVertex> opsToVertices = new HashMap<PcodeOpAST, AttributedVertex>();
        AttributedVertex baseVertex = null;
        if (vn == null) {
            baseVertex = graph.addVertex("df" + Integer.toString(graph.getVertexCount()), "void");
            vn = new VarnodeAST(Address.NO_ADDRESS, 0, 0);
        } else {
            baseVertex = graph.addVertex("df" + Integer.toString(graph.getVertexCount()), vn.toString(this.plugin.getCurrentProgram().getLanguage()));
            baseVertex.setAttribute("Size", Integer.toString(vn.getSize()));
        }
        baseVertex.setVertexType(primaryBase ? "Base Varnode" : "Secondary Base Varnode");
        varnodesToVertices.put(vn, baseVertex);
        DataflowQueueElement base = new DataflowQueueElement(vn, windowSize);
        varnodes.add(base);
        while (!varnodes.isEmpty()) {
            DataflowQueueElement currentElement = (DataflowQueueElement)varnodes.poll();
            VarnodeAST outputVarnode = currentElement.vn;
            AttributedVertex varnodeVertex = (AttributedVertex)varnodesToVertices.get(outputVarnode);
            PcodeOpAST currentPcode = null;
            currentPcode = outputVarnode.getAddress().equals((Object)Address.NO_ADDRESS) ? pcode : (PcodeOpAST)outputVarnode.getDef();
            boolean collapsedOp = false;
            if (!featuredOps.contains(currentPcode) && currentPcode != pcode) {
                collapsedOp = true;
            }
            if (collapsedOp) {
                varnodeVertex.setVertexType("Collapsed Varnode");
                if (opsToVertices.containsKey(currentPcode)) continue;
            }
            AttributedVertex pcodeVertex = opsToVertices.computeIfAbsent(currentPcode, x -> graph.addVertex("df" + Integer.toString(graph.getVertexCount()), x.getMnemonic()));
            if (collapsedOp) {
                pcodeVertex.setVertexType("Collapsed Op");
            } else {
                pcodeVertex.setVertexType("Pcode Op");
            }
            pcodeVertex.setAttribute("Address", currentPcode.getSeqnum().getTarget().toString());
            pcodeVertex.setAttribute("Pcode Output", currentPcode.getOutput() == null ? "void" : currentPcode.getOutput().toString(this.plugin.getCurrentProgram().getLanguage()));
            AttributedEdge edge = graph.addEdge(pcodeVertex, varnodeVertex);
            if (collapsedOp) {
                edge.setEdgeType("Collapsed Output");
            } else {
                edge.setEdgeType("Output");
            }
            int start = 0;
            int stop = currentPcode.getNumInputs();
            switch (currentPcode.getOpcode()) {
                case 68: {
                    stop = 1;
                    break;
                }
                case 61: {
                    --stop;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 29: 
                case 30: 
                case 31: 
                case 63: {
                    if (!currentPcode.getInput(1).isConstant()) break;
                    --stop;
                    break;
                }
            }
            for (int j = ++start; j < stop; ++j) {
                int numHops;
                Varnode iv = currentPcode.getInput(j);
                if (iv == null) {
                    Msg.info((Object)((Object)this), (Object)("Null input for pcode " + currentPcode.getMnemonic()));
                    continue;
                }
                VarnodeAST inputVarnode = (VarnodeAST)iv;
                AttributedVertex inputVarnodeVertex = varnodesToVertices.computeIfAbsent(inputVarnode, x -> graph.addVertex("df" + Integer.toString(graph.getVertexCount()), inputVarnode.toString(this.plugin.getCurrentProgram().getLanguage())));
                inputVarnodeVertex.setVertexType("Default");
                if (inputVarnode.isConstant() && inputVarnode.isInput()) {
                    inputVarnodeVertex.setVertexType("Constant Function Input");
                } else {
                    if (inputVarnode.isConstant()) {
                        inputVarnodeVertex.setVertexType("Constant");
                    }
                    if (inputVarnode.isInput()) {
                        inputVarnodeVertex.setVertexType("Function Input");
                    }
                }
                if (inputVarnode.isAddress()) {
                    inputVarnodeVertex.setVertexType("Address Varnode");
                }
                inputVarnodeVertex.setAttribute("Size", Integer.toString(inputVarnode.getSize()));
                edge = graph.addEdge(inputVarnodeVertex, pcodeVertex);
                if (collapsedOp) {
                    edge.setEdgeType("Collapsed Input");
                } else {
                    edge.setEdgeType("Input");
                }
                if (inputVarnode.getDef() == null) continue;
                int n = numHops = collapsedOp ? currentElement.remainingHops : currentElement.remainingHops - 1;
                if (numHops <= 0) continue;
                DataflowQueueElement inputElement = new DataflowQueueElement(inputVarnode, numHops);
                varnodes.add(inputElement);
            }
        }
        return baseVertex;
    }

    private class DataflowQueueElement {
        public int remainingHops;
        public VarnodeAST vn;

        public DataflowQueueElement(VarnodeAST vn, int remainingHops) {
            this.vn = vn;
            this.remainingHops = remainingHops;
        }
    }
}

