/*
 * Decompiled with CFR 0.152.
 */
package ghidra.comm.util;

import ghidra.comm.util.BitmaskUniverse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;

public class BitmaskSet<E extends Enum<E>>
implements Set<E> {
    private final Class<E> universe;
    private long bitmask;

    @SafeVarargs
    public static <E extends Enum<E>> BitmaskSet<E> of(E ... elements) {
        long bitmask = 0L;
        for (E elem : elements) {
            bitmask |= ((BitmaskUniverse)elem).getMask();
        }
        Class<?> universe = elements.getClass().getComponentType();
        return new BitmaskSet(universe, bitmask);
    }

    public BitmaskSet(Class<E> universe, long bitmask) {
        this.universe = universe;
        this.bitmask = bitmask;
    }

    public BitmaskSet(Class<E> universe, Collection<E> collection) {
        this.universe = universe;
        BitmaskSet<E> that = this.castSameType(collection);
        if (that != null) {
            this.bitmask = that.bitmask;
            return;
        }
        if (collection.isEmpty()) {
            return;
        }
        for (Enum elem : collection) {
            this.bitmask |= ((BitmaskUniverse)((Object)elem)).getMask();
        }
    }

    public BitmaskSet(BitmaskSet<E> that) {
        this.universe = that.universe;
        this.bitmask = that.bitmask;
    }

    public BitmaskSet(Class<E> universe) {
        this.universe = universe;
    }

    protected boolean containsImpl(E elem) {
        long mask = ((BitmaskUniverse)elem).getMask();
        return (mask & this.bitmask) == mask;
    }

    protected boolean removeImpl(E elem) {
        long old = this.bitmask;
        this.bitmask &= ((BitmaskUniverse)elem).getMask() ^ 0xFFFFFFFFFFFFFFFFL;
        return old != this.bitmask;
    }

    protected BitmaskSet<E> castSameType(Collection<?> c) {
        if (!(c instanceof BitmaskSet)) {
            return null;
        }
        BitmaskSet bm = (BitmaskSet)c;
        if (this.universe != bm.universe) {
            return null;
        }
        BitmaskSet bme = bm;
        return bme;
    }

    @Override
    public int size() {
        int count = 0;
        for (Enum elem : (Enum[])this.universe.getEnumConstants()) {
            if (!this.containsImpl(elem)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.bitmask == 0L;
    }

    @Override
    public boolean contains(Object o) {
        if (this.universe != o.getClass()) {
            return false;
        }
        Enum elem = (Enum)o;
        return this.containsImpl(elem);
    }

    @Override
    public Iterator<E> iterator() {
        List<Enum> all = Arrays.asList((Enum[])this.universe.getEnumConstants());
        return IteratorUtils.filteredIterator(all.iterator(), x$0 -> this.containsImpl((Enum)x$0));
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<Enum> arr = new ArrayList<Enum>();
        for (Enum elem : (Enum[])this.universe.getEnumConstants()) {
            if (!this.containsImpl(elem)) continue;
            arr.add(elem);
        }
        return arr.toArray(a);
    }

    @Override
    public boolean add(E elem) {
        long old = this.bitmask;
        this.bitmask |= ((BitmaskUniverse)elem).getMask();
        return old != this.bitmask;
    }

    @Override
    public boolean remove(Object o) {
        if (this.universe != o.getClass()) {
            return false;
        }
        Enum elem = (Enum)o;
        return this.removeImpl(elem);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.isEmpty()) {
            return true;
        }
        BitmaskSet<E> that = this.castSameType(c);
        if (that != null) {
            return (this.bitmask | that.bitmask) == this.bitmask;
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Collection<?> c) {
        if (c.isEmpty()) {
            return false;
        }
        BitmaskSet<E> that = this.castSameType(c);
        if (that != null) {
            return (this.bitmask & that.bitmask) != 0L;
        }
        for (Object o : c) {
            if (!this.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        long old = this.bitmask;
        BitmaskSet<E> that = this.castSameType(c);
        if (that != null) {
            this.bitmask |= that.bitmask;
            return old != this.bitmask;
        }
        if (c.isEmpty()) {
            return false;
        }
        for (Enum elem : c) {
            this.bitmask |= ((BitmaskUniverse)((Object)elem)).getMask();
        }
        return old != this.bitmask;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        long old = this.bitmask;
        if (c.isEmpty()) {
            this.bitmask = 0L;
            return old != this.bitmask;
        }
        BitmaskSet<E> that = this.castSameType(c);
        if (that != null) {
            this.bitmask &= that.bitmask;
            return old != this.bitmask;
        }
        long toKeep = 0L;
        for (Object o : c) {
            if (this.universe != o.getClass()) continue;
            Enum elem = (Enum)o;
            toKeep |= ((BitmaskUniverse)((Object)elem)).getMask();
        }
        this.bitmask &= toKeep;
        return old != this.bitmask;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.isEmpty()) {
            return false;
        }
        long old = this.bitmask;
        BitmaskSet<E> that = this.castSameType(c);
        if (that != null) {
            this.bitmask &= that.bitmask ^ 0xFFFFFFFFFFFFFFFFL;
            return old != this.bitmask;
        }
        long toRemove = 0L;
        for (Object o : c) {
            if (this.universe != o.getClass()) continue;
            Enum elem = (Enum)o;
            toRemove |= ((BitmaskUniverse)((Object)elem)).getMask();
        }
        this.bitmask &= toRemove ^ 0xFFFFFFFFFFFFFFFFL;
        return old != this.bitmask;
    }

    @Override
    public void clear() {
        this.bitmask = 0L;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Collection)) {
            return false;
        }
        Collection col = (Collection)obj;
        BitmaskSet<E> that = this.castSameType(col);
        if (that != null) {
            return this.bitmask == that.bitmask;
        }
        return this.containsAll(col) && col.containsAll(this);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.bitmask);
    }

    public long getBitmask() {
        return this.bitmask;
    }

    public void setBitmask(long bitmask) {
        this.bitmask = bitmask;
    }

    public Class<E> getUniverse() {
        return this.universe;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (Enum elem : this) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(elem);
        }
        sb.append(']');
        return sb.toString();
    }
}

