/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async.seq;

import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceActionProduces;
import ghidra.async.seq.AsyncSequenceActionRuns;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.async.seq.AsyncSequenceWithTemp;
import ghidra.util.Msg;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public class AsyncSequenceWithoutTemp<R> {
    private final CompletableFuture<Void> tmpResult;
    private final CompletableFuture<R> seqResult;

    public AsyncSequenceWithoutTemp(CompletableFuture<R> seqResult, CompletableFuture<Void> tmpResult) {
        this.seqResult = seqResult;
        this.tmpResult = tmpResult;
    }

    public <U> AsyncSequenceWithTemp<R, U> then(AsyncSequenceActionProduces<R, U> action, TypeSpec<U> type) {
        return new AsyncSequenceWithTemp(this.seqResult, this.tmpResult.thenCompose(result -> {
            AsyncSequenceWithTemp.HandlerForProducer handler = new AsyncSequenceWithTemp.HandlerForProducer(this.seqResult);
            try {
                action.accept(handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }));
    }

    public <U> AsyncSequenceWithTemp<R, U> then(Executor executor, AsyncSequenceActionProduces<R, U> action, TypeSpec<U> type) {
        return new AsyncSequenceWithTemp(this.seqResult, this.tmpResult.thenComposeAsync(result -> {
            AsyncSequenceWithTemp.HandlerForProducer handler = new AsyncSequenceWithTemp.HandlerForProducer(this.seqResult);
            try {
                action.accept(handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }, executor));
    }

    public <U> AsyncSequenceWithoutTemp<R> then(AsyncSequenceActionProduces<R, U> action, AtomicReference<U> storage) {
        return new AsyncSequenceWithoutTemp<R>(this.seqResult, (CompletableFuture<Void>)this.tmpResult.thenCompose(result -> {
            AsyncSequenceWithTemp.HandlerForStorer handler = new AsyncSequenceWithTemp.HandlerForStorer(this.seqResult, storage);
            try {
                action.accept(handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }));
    }

    public <U> AsyncSequenceWithoutTemp<R> then(Executor executor, AsyncSequenceActionProduces<R, U> action, AtomicReference<U> storage) {
        return new AsyncSequenceWithoutTemp<R>(this.seqResult, (CompletableFuture<Void>)this.tmpResult.thenComposeAsync(result -> {
            AsyncSequenceWithTemp.HandlerForStorer handler = new AsyncSequenceWithTemp.HandlerForStorer(this.seqResult, storage);
            try {
                action.accept(handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }, executor));
    }

    public AsyncSequenceWithoutTemp<R> then(AsyncSequenceActionRuns<R> action) {
        return new AsyncSequenceWithoutTemp<R>(this.seqResult, (CompletableFuture<Void>)this.tmpResult.thenCompose(result -> {
            AsyncSequenceWithTemp.HandlerForRunner<R> handler = new AsyncSequenceWithTemp.HandlerForRunner<R>(this.seqResult);
            try {
                action.accept(handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }));
    }

    public AsyncSequenceWithoutTemp<R> then(Executor executor, AsyncSequenceActionRuns<R> action) {
        return new AsyncSequenceWithoutTemp<R>(this.seqResult, (CompletableFuture<Void>)this.tmpResult.thenComposeAsync(result -> {
            AsyncSequenceWithTemp.HandlerForRunner<R> handler = new AsyncSequenceWithTemp.HandlerForRunner<R>(this.seqResult);
            try {
                action.accept(handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }, executor));
    }

    public CompletableFuture<R> finish() {
        return this.then((AsyncSequenceActionRuns)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$finish$6(ghidra.async.seq.AsyncSequenceHandlerForRunner ), (Lghidra/async/seq/AsyncSequenceHandlerForRunner;)V)()).seqResult;
    }

    public AsyncSequenceWithoutTemp<R> onExit(BiConsumer<? super R, Throwable> action) {
        this.seqResult.handle((result, exc) -> {
            try {
                action.accept((R)result, (Throwable)exc);
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)"Uncaught exception in onExit", (Throwable)t);
            }
            return result;
        });
        return this;
    }

    private static /* synthetic */ void lambda$finish$6(AsyncSequenceHandlerForRunner seq) {
        seq.exit(null, null);
    }
}

