/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async.loop;

import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoopFirstActionProduces;
import ghidra.async.loop.AsyncLoopHandlerForFirst;
import ghidra.async.loop.AsyncLoopHandlerForSecond;
import ghidra.async.loop.AsyncLoopSecondActionConsumes;
import java.util.concurrent.CompletableFuture;

public class AsyncLoop<R, T>
extends CompletableFuture<R> {
    private final AsyncLoopFirstActionProduces<R, T> producer;
    private final AsyncLoopSecondActionConsumes<R, ? super T> consumer;
    private final AsyncLoopHandlerForFirst<R, T> produceHandler = new AsyncLoopHandlerForFirst<R, T>(){

        @Override
        public Void consume(T iterate, Throwable exc) {
            if (exc != null) {
                AsyncLoop.this.completeExceptionally(exc);
            } else {
                try {
                    AsyncLoop.this.consumer.accept(iterate, AsyncLoop.this.consumeHandler);
                }
                catch (Throwable e) {
                    AsyncLoop.this.completeExceptionally(e);
                }
            }
            return null;
        }

        @Override
        public Void exit(R result, Throwable exc) {
            if (exc != null) {
                AsyncLoop.this.completeExceptionally(exc);
            } else {
                AsyncLoop.this.complete(result);
            }
            return null;
        }
    };
    private final AsyncLoopHandlerForSecond<R> consumeHandler = new AsyncLoopHandlerForSecond<R>(){

        @Override
        public Void repeat(Void v, Throwable exc) {
            if (exc != null) {
                AsyncLoop.this.completeExceptionally(exc);
            } else {
                AsyncUtils.FRAMEWORK_EXECUTOR.submit(() -> {
                    try {
                        AsyncLoop.this.producer.accept(AsyncLoop.this.produceHandler);
                    }
                    catch (Throwable e) {
                        AsyncLoop.this.completeExceptionally(e);
                    }
                });
            }
            return null;
        }

        @Override
        public Void exit(R result, Throwable exc) {
            if (exc != null) {
                AsyncLoop.this.completeExceptionally(exc);
            } else {
                AsyncLoop.this.complete(result);
            }
            return null;
        }
    };

    public void begin() {
        this.consumeHandler.repeat(null, null);
    }

    public AsyncLoop(AsyncLoopFirstActionProduces<R, T> producer, TypeSpec<T> type, AsyncLoopSecondActionConsumes<R, ? super T> consumer) {
        this.producer = producer;
        this.consumer = consumer;
    }
}

