/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import ghidra.async.AsyncTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class AsyncDebouncer<T> {
    protected final AsyncTimer timer;
    protected final long windowMillis;
    protected final List<Consumer<T>> listeners = new ArrayList<Consumer<T>>();
    protected CompletableFuture<T> settledPromise;
    protected T lastContact;
    protected CompletableFuture<Void> alarm;

    public AsyncDebouncer(AsyncTimer timer, long windowMillis) {
        this.timer = timer;
        this.windowMillis = windowMillis;
    }

    public synchronized void addListener(Consumer<T> listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(Consumer<T> listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSettled() {
        CompletableFuture<T> promise;
        ArrayList<Consumer<T>> ls;
        AsyncDebouncer asyncDebouncer = this;
        synchronized (asyncDebouncer) {
            this.alarm = null;
            ls = new ArrayList<Consumer<T>>(this.listeners);
            promise = this.settledPromise;
            this.settledPromise = null;
        }
        for (Consumer consumer : ls) {
            consumer.accept(this.lastContact);
        }
        if (promise != null) {
            promise.complete(this.lastContact);
        }
    }

    public synchronized void contact(T val) {
        this.lastContact = val;
        if (this.alarm != null) {
            this.alarm.cancel(false);
        }
        this.alarm = this.timer.mark().after(this.windowMillis).thenRun(this::doSettled);
    }

    public synchronized CompletableFuture<T> settled() {
        if (this.settledPromise == null) {
            this.settledPromise = new CompletableFuture();
        }
        return this.settledPromise;
    }

    public synchronized CompletableFuture<T> stable() {
        if (this.alarm == null) {
            return CompletableFuture.completedFuture(this.lastContact);
        }
        return this.settled();
    }
}

