/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.ref.SarifEquateRefWriter;
import sarif.export.ref.SarifReferenceWriter;
import sarif.managers.SarifMgr;

public class MarkupSarifMgr
extends SarifMgr {
    public static String KEY = "REFERENCES";
    private ReferenceManager refManager;
    private EquateTable equateTable;

    MarkupSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
        this.refManager = program.getReferenceManager();
        this.equateTable = program.getEquateTable();
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        boolean overwrite;
        String tagName = (String)result.get("Message");
        boolean bl = overwrite = options == null || options.isOverwriteReferenceConflicts();
        if (tagName.equals("Ref.Memory")) {
            this.processMemoryReference(result, overwrite);
        } else if (tagName.equals("Ref.Shifted")) {
            this.processShiftedReference(result, overwrite);
        } else if (tagName.equals("Ref.Register")) {
            this.processRegisterReference(result, overwrite);
        } else if (tagName.equals("Ref.Stack")) {
            if (options == null || options.isFunctions()) {
                this.processStackReference(result, overwrite);
            }
        } else if (tagName.equals("Ref.External")) {
            if (options == null || options.isExternalLibraries()) {
                this.processExtLibraryReference(result, overwrite);
            }
        } else if (tagName.equals("Ref.Equate")) {
            this.processEquateReference(result, overwrite);
        }
        return true;
    }

    private RefType getRefType(int type) {
        return RefTypeFactory.get((byte)((byte)type));
    }

    private void processMemoryReference(Map<String, Object> result, boolean overwrite) {
        try {
            Reference ref;
            Reference[] existingMemRefs;
            Address fromAddr = this.getLocation(result);
            if (fromAddr == null) {
                throw new AddressFormatException("Incompatible Memory Reference FROM Address");
            }
            String toAddrStr = (String)result.get("to");
            if (toAddrStr == null) {
                throw new RuntimeException("TO_ADDRESS attribute missing for MEMORY_REFERENCE element");
            }
            Address toAddr = MarkupSarifMgr.parseAddress(this.factory, toAddrStr);
            if (toAddr == null) {
                throw new AddressFormatException("Incompatible Memory Reference TO Address: " + toAddrStr);
            }
            int opIndex = -1;
            if (result.get("opIndex") != null) {
                opIndex = (int)((Double)result.get("opIndex")).doubleValue();
            }
            boolean primary = false;
            if (result.get("primary") != null) {
                primary = (Boolean)result.get("primary");
            }
            Address baseAddr = null;
            if (result.get("base") != null) {
                baseAddr = MarkupSarifMgr.parseAddress(this.factory, (String)result.get("base"));
            }
            if (!overwrite && (existingMemRefs = this.refManager.getReferencesFrom(fromAddr, opIndex)) != null && existingMemRefs.length != 0 && !existingMemRefs[0].isMemoryReference()) {
                this.log.appendMsg("Reference already exists from [" + fromAddr + "] to [" + toAddr + "] on operand [" + opIndex + "]");
                return;
            }
            int index = Integer.parseInt((String)result.get("index"));
            RefType refType = this.getRefType(index);
            SourceType sourceType = this.getSourceType((String)result.get("sourceType"));
            ReferenceManager refMgr = this.program.getReferenceManager();
            if (baseAddr != null) {
                long offset = (long)((Double)result.get("offset")).doubleValue();
                ref = refMgr.addOffsetMemReference(fromAddr, toAddr, toAddr.equals((Object)baseAddr), offset, refType, sourceType, opIndex);
            } else {
                ref = refMgr.addMemoryReference(fromAddr, toAddr, refType, sourceType, opIndex);
            }
            refMgr.setPrimary(ref, primary);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    private void processRegisterReference(Map<String, Object> result, boolean overwrite) {
        try {
            Reference[] existingRefs;
            Address fromAddr = this.getLocation(result);
            if (fromAddr == null) {
                throw new AddressFormatException("Incompatible Memory Reference FROM Address");
            }
            String toAddrStr = (String)result.get("to");
            if (toAddrStr == null) {
                throw new RuntimeException("TO_ADDRESS attribute missing for REGISTER_REFERENCE element");
            }
            Address toAddr = MarkupSarifMgr.parseAddress(this.factory, toAddrStr);
            if (toAddr == null) {
                throw new AddressFormatException("Incompatible Register Reference TO Address: " + toAddrStr);
            }
            Register[] registers = this.program.getLanguage().getRegisters(toAddr);
            Register reg = registers[0];
            int opIndex = -1;
            if (result.get("opIndex") != null) {
                opIndex = (int)((Double)result.get("opIndex")).doubleValue();
            }
            boolean primary = false;
            if (result.get("primary") != null) {
                primary = (Boolean)result.get("primary");
            }
            if (!overwrite && (existingRefs = this.refManager.getReferencesFrom(fromAddr, opIndex)) != null && existingRefs.length != 0) {
                this.log.appendMsg("Memory reference already existed from [" + fromAddr + "] to [" + toAddr + "] on operand [" + opIndex + "]");
                return;
            }
            int index = Integer.parseInt((String)result.get("index"));
            RefType refType = this.getRefType(index);
            SourceType sourceType = this.getSourceType((String)result.get("sourceType"));
            ReferenceManager refMgr = this.program.getReferenceManager();
            Reference ref = refMgr.addRegisterReference(fromAddr, opIndex, reg, refType, sourceType);
            refMgr.setPrimary(ref, primary);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    private void processStackReference(Map<String, Object> result, boolean overwrite) {
        try {
            Reference[] existingRefs;
            CodeUnit cu;
            Address addr = this.getLocation(result);
            if (addr == null) {
                throw new AddressFormatException("Incompatible Stack Reference Address");
            }
            int opIndex = -1;
            if (result.get("opIndex") != null) {
                opIndex = (int)((Double)result.get("opIndex")).doubleValue();
            }
            if ((cu = this.listing.getCodeUnitContaining(addr)) == null) {
                this.log.appendMsg("No codeunit at " + addr);
                return;
            }
            if (!overwrite && (existingRefs = this.refManager.getReferencesFrom(addr, opIndex)) != null && existingRefs.length != 0) {
                this.log.appendMsg("Reference already exists from [" + addr + "] on operand [" + opIndex + "]");
                return;
            }
            Reference ref = cu.getPrimaryReference(opIndex);
            if (ref != null && !overwrite) {
                return;
            }
            int offset = (int)((Double)result.get("offset")).doubleValue();
            int index = Integer.parseInt((String)result.get("index"));
            RefType refType = this.getRefType(index);
            SourceType sourceType = this.getSourceType((String)result.get("sourceType"));
            this.refManager.addStackReference(addr, opIndex, offset, refType, sourceType);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    private void processShiftedReference(Map<String, Object> result, boolean overwrite) {
        try {
            Reference[] existingRefs;
            CodeUnit cu;
            Address addr = this.getLocation(result);
            if (addr == null) {
                throw new AddressFormatException("Incompatible Shifted Reference Address");
            }
            int opIndex = -1;
            if (result.get("opIndex") != null) {
                opIndex = (int)((Double)result.get("opIndex")).doubleValue();
            }
            if ((cu = this.listing.getCodeUnitContaining(addr)) == null) {
                this.log.appendMsg("No codeunit at " + addr);
                return;
            }
            if (!overwrite && (existingRefs = this.refManager.getReferencesFrom(addr, opIndex)) != null && existingRefs.length != 0) {
                this.log.appendMsg("Reference already exists from [" + addr + "] on operand [" + opIndex + "]");
                return;
            }
            Reference ref = cu.getPrimaryReference(opIndex);
            if (ref != null && !overwrite) {
                return;
            }
            int shift = (int)((Double)result.get("shift")).doubleValue();
            long value = (long)((Double)result.get("value")).doubleValue();
            Address toAddr = addr.getNewAddress(value);
            int index = Integer.parseInt((String)result.get("index"));
            RefType refType = this.getRefType(index);
            SourceType sourceType = this.getSourceType((String)result.get("sourceType"));
            this.refManager.addShiftedMemReference(addr, toAddr, shift, refType, sourceType, opIndex);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    private void processExtLibraryReference(Map<String, Object> result, boolean overwrite) {
        try {
            Address addr = this.getLocation(result);
            if (addr == null) {
                throw new AddressFormatException("Incompatible External Reference Address");
            }
            int opIndex = -1;
            if (result.get("opIndex") != null) {
                opIndex = (int)((Double)result.get("opIndex")).doubleValue();
            }
            String namespacePath = (String)result.get("name");
            String label = (String)result.get("libLabel");
            String libAddress = (String)result.get("libAddr");
            Address libAddr = libAddress != null ? this.factory.getAddress(libAddress) : null;
            String libExtAddress = (String)result.get("libExtAddr");
            String origImport = (String)result.get("origImport");
            boolean isFunction = (Boolean)result.get("isFunction");
            if (label == null && libAddr == null) {
                this.log.appendMsg("External library reference for address " + addr + " does not have a label or an external address specified. External reference will not be created");
                return;
            }
            CodeUnit cu = this.listing.getCodeUnitContaining(addr);
            if (cu == null) {
                this.log.appendMsg("No codeunit at " + addr);
                return;
            }
            ExternalReference ref = cu.getExternalReference(opIndex);
            if (ref != null) {
                if (!overwrite) {
                    return;
                }
                this.program.getReferenceManager().delete((Reference)ref);
            }
            RefType refType = null;
            String rt = (String)result.get("kind");
            if (rt != null) {
                int index = Integer.parseInt((String)result.get("index"));
                refType = this.getRefType(index);
            } else {
                refType = RefType.EXTERNAL_REF;
            }
            SourceType sourceType = this.getSourceType((String)result.get("sourceType"));
            ExternalLocation extLoc = (ExternalLocation)externalMap.get(libExtAddress);
            if (extLoc == null) {
                extLoc = this.addExternal(label, namespacePath, libAddr, sourceType, origImport, isFunction);
                externalMap.put(libExtAddress, extLoc);
            }
            if (origImport != null && !origImport.equals(extLoc.getOriginalImportedName())) {
                this.log.appendMsg("Retrieving incorrect external location - known bug");
            }
            this.refManager.addExternalReference(addr, opIndex, extLoc, sourceType, refType);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    private ExternalLocation addExternal(String name, String namespacePath, Address address, SourceType sourceType, String name0, boolean isFunction) throws InvalidInputException, IOException {
        ExternalLocation loc;
        Namespace p = this.walkNamespace(this.program.getGlobalNamespace(), namespacePath + "::", address, sourceType, true);
        Library lib = this.getLibrary(p);
        ExternalManager extManager = this.program.getExternalManager();
        if (isFunction) {
            if (name0 != null) {
                loc = extManager.addExtFunction((Namespace)(lib == null ? p : lib), name0, address, sourceType, false);
                loc.setName(p, name, sourceType);
            } else {
                loc = extManager.addExtFunction(p, name, address, sourceType, true);
            }
        } else if (name0 != null) {
            loc = extManager.addExtLocation((Namespace)(lib == null ? p : lib), name0, address, sourceType, false);
            loc.setName(p, name, sourceType);
        } else {
            loc = extManager.addExtLocation(p, name, address, sourceType, true);
        }
        return loc;
    }

    private Library getLibrary(Namespace p) {
        if (p instanceof Library) {
            Library lib = (Library)p;
            return lib;
        }
        Namespace parent = p.getParentNamespace();
        return parent == null ? null : this.getLibrary(parent);
    }

    private void processEquateReference(Map<String, Object> result, boolean overwrite) {
        try {
            Equate existingEquate;
            Address addr = this.getLocation(result);
            if (addr == null) {
                throw new AddressFormatException("Incompatible Equate Reference Address");
            }
            if (this.listing.isUndefined(addr, addr)) {
                this.log.appendMsg("BAD EQUATE REFERENCE: defined code unit not found at " + addr);
                return;
            }
            CodeUnit cu = this.listing.getCodeUnitContaining(addr);
            if (cu == null) {
                this.log.appendMsg("No codeunit at " + addr);
                return;
            }
            String equateName = (String)result.get("name");
            int opIndex = -1;
            LinkedList<Scalar> instrScalars = new LinkedList<Scalar>();
            if (result.get("OpIndex") != null && (opIndex = (int)((Double)result.get("opIndex")).doubleValue()) != -1) {
                Scalar tempScalar = cu.getScalar(opIndex);
                if (tempScalar != null) {
                    instrScalars.add(tempScalar);
                } else if (cu instanceof Instruction) {
                    Instruction instr = (Instruction)cu;
                    Object[] opObjects = instr.getOpObjects(opIndex);
                    for (int i = 0; i < opObjects.length; ++i) {
                        if (!(opObjects[i] instanceof Scalar)) continue;
                        instrScalars.add((Scalar)opObjects[i]);
                    }
                    if (instrScalars.size() == 0) {
                        this.log.appendMsg("BAD EQUATE REFERENCE: operand [" + opIndex + "] at address [" + addr + "] is not a scalar.");
                        return;
                    }
                }
            }
            long value = 0L;
            if (result.get("value") != null) {
                value = (Long)result.get("value");
                Scalar matchingScalar = null;
                Iterator itr = instrScalars.iterator();
                while (matchingScalar == null && itr.hasNext()) {
                    matchingScalar = (Scalar)itr.next();
                    if (matchingScalar.getSignedValue() == value) continue;
                    matchingScalar = null;
                }
                if (matchingScalar == null) {
                    this.log.appendMsg("BAD EQUATE REFERENCE: equate [" + equateName + "] value [0x" + Long.toHexString(value) + "] does not match scalar on operand [" + opIndex + "] at address [" + addr + "]");
                    return;
                }
            } else if (instrScalars.size() > 0) {
                Msg.warn((Object)this, (Object)"NO VALUE SPECIFIED");
                value = ((Scalar)instrScalars.get(0)).getSignedValue();
            } else {
                this.log.appendMsg("BAD EQUATE REFERENCE: either the VALUE or OPERAND_INDEX must be specified");
                return;
            }
            Equate equate = this.equateTable.getEquate(equateName);
            if (equate != null) {
                if (value != equate.getValue()) {
                    this.log.appendMsg("BAD EQUATE REFERENCE: equate [" + equateName + "] value [0x" + Long.toHexString(value) + "] conflicts with existing equate value [0x" + Long.toHexString(equate.getValue()) + "].");
                    return;
                }
            } else {
                try {
                    equate = this.equateTable.createEquate(equateName, value);
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Got duplicate name while creating equate " + equateName);
                }
                catch (InvalidInputException e) {
                    this.log.appendMsg("Invalid name for equate " + equateName);
                    return;
                }
            }
            if ((existingEquate = this.equateTable.getEquate(addr, opIndex, equate.getValue())) != null && overwrite) {
                existingEquate.removeReference(addr, opIndex);
            }
            equate.addReference(addr, opIndex);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    void write(JsonArray results, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        if (set == null) {
            set = this.program.getMemory();
        }
        monitor.setMessage("Exporting References...");
        AddressIterator iter = this.refManager.getReferenceSourceIterator(set, true);
        ArrayList<Address> request = new ArrayList<Address>();
        while (iter.hasNext()) {
            request.add(iter.next());
        }
        MarkupSarifMgr.writeAsSARIF(this.program, request, results);
        MarkupSarifMgr.writeAsSARIF(this.program, set, results);
    }

    public static void writeAsSARIF(Program program, List<Address> request, JsonArray results) throws IOException {
        SarifReferenceWriter writer = new SarifReferenceWriter(program.getReferenceManager(), request, null);
        new TaskLauncher((Task)new SarifWriterTask("References", writer, results), null);
    }

    public static void writeAsSARIF(Program program, AddressSetView set, JsonArray results) throws IOException {
        SarifEquateRefWriter ewriter = new SarifEquateRefWriter(program.getEquateTable(), set, null);
        new TaskLauncher((Task)new SarifWriterTask("References", ewriter, results), null);
    }
}

