/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.registers;

import com.google.gson.JsonElement;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ProgramContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.registers.ExtRegisterValue;
import sarif.managers.RegisterValuesSarifMgr;

public class SarifRegisterValueWriter
extends AbstractExtWriter {
    List<AddressRange> ranges;
    ProgramContext context;
    List<Register> registers;

    public SarifRegisterValueWriter(ProgramContext context, List<Register> registers, List<AddressRange> request, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.ranges = request;
        this.context = context;
        this.registers = registers;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genRegisters(monitor);
        this.root.add("registers", (JsonElement)this.objects);
    }

    private void genRegisters(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.ranges.size());
        for (AddressRange r : this.ranges) {
            for (Register reg : this.registers) {
                AddressRangeIterator it = this.context.getRegisterValueAddressRanges(reg, r.getMinAddress(), r.getMaxAddress());
                while (it.hasNext()) {
                    monitor.checkCancelled();
                    AddressRange valueRange = (AddressRange)it.next();
                    BigInteger value = this.context.getValue(reg, valueRange.getMinAddress(), false);
                    if (value == null) continue;
                    ExtRegisterValue isf = new ExtRegisterValue(reg, value.toString(16));
                    SarifObject sarif = new SarifObject(RegisterValuesSarifMgr.SUBKEY, RegisterValuesSarifMgr.KEY, this.getTree(isf), valueRange.getMinAddress(), valueRange.getMaxAddress());
                    this.objects.add(this.getTree(sarif));
                }
            }
            monitor.increment();
        }
    }
}

