/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import ghidra.app.decompiler.component.DecompilerController;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.util.task.SwingUpdateManager;

public class DecompilerProgramListener
implements DomainObjectListener {
    private DecompilerController controller;
    private SwingUpdateManager updater;

    public DecompilerProgramListener(DecompilerController controller, Runnable callback) {
        this(controller, new SwingUpdateManager(500, 5000, callback));
    }

    public DecompilerProgramListener(DecompilerController controller, SwingUpdateManager updater) {
        this.controller = controller;
        this.updater = updater;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(20) || ev.containsEvent(21) || ev.containsEvent(4)) {
            this.controller.resetDecompiler();
        } else if (ev.containsEvent(5)) {
            for (DomainObjectChangeRecord record : ev) {
                String value;
                if (record.getEventType() != 5 || !(record.getOldValue() instanceof String) || !(value = (String)record.getOldValue()).startsWith("Specification Extensions")) continue;
                this.controller.resetDecompiler();
                break;
            }
        }
        this.updater.update();
    }

    public void dispose() {
        this.updater.dispose();
    }
}

