/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileCallback;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.decompiler.DecompilerDisposer;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ByteIngest;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PackedDecode;
import ghidra.program.model.pcode.PackedEncode;
import ghidra.program.model.pcode.StringIngest;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DecompileProcess {
    private static final byte[] command_start = new byte[]{0, 0, 1, 2};
    private static final byte[] command_end = new byte[]{0, 0, 1, 3};
    private static final byte[] query_response_start = new byte[]{0, 0, 1, 8};
    private static final byte[] query_response_end = new byte[]{0, 0, 1, 9};
    private static final byte[] string_start = new byte[]{0, 0, 1, 14};
    private static final byte[] string_end = new byte[]{0, 0, 1, 15};
    private static final byte[] exception_start = new byte[]{0, 0, 1, 10};
    private static final byte[] exception_end = new byte[]{0, 0, 1, 11};
    private static final byte[] byte_start = new byte[]{0, 0, 1, 12};
    private static final byte[] byte_end = new byte[]{0, 0, 1, 13};
    private Runtime runtime = Runtime.getRuntime();
    private String[] exepath;
    private Runnable timeoutRunnable;
    private volatile Process nativeProcess;
    private volatile InputStream nativeIn;
    private volatile OutputStream nativeOut;
    private volatile boolean statusGood;
    private int archId = -1;
    private DecompileCallback callback;
    private String programSource;
    private int maxResultSizeMBYtes = 50;
    private PackedDecode paramDecoder;
    private PackedEncode resultEncoder;
    private StringIngest stringDecoder;
    private volatile DisposeState disposestate = DisposeState.NOT_DISPOSED;

    public DecompileProcess(String path) {
        this.exepath = new String[]{path};
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                DecompileProcess.this.dispose();
                DecompileProcess.this.disposestate = DisposeState.DISPOSED_ON_TIMEOUT;
            }
        };
        this.stringDecoder = new StringIngest();
    }

    public void dispose() {
        if (this.disposestate != DisposeState.NOT_DISPOSED) {
            return;
        }
        this.disposestate = DisposeState.DISPOSED_ON_CANCEL;
        this.statusGood = false;
        DecompilerDisposer.dispose(this.nativeProcess, this.nativeOut, this.nativeIn);
    }

    public DisposeState getDisposeState() {
        return this.disposestate;
    }

    private void setup() throws IOException {
        if (this.disposestate != DisposeState.NOT_DISPOSED) {
            throw new IOException("Decompiler has been disposed");
        }
        if (this.nativeProcess != null) {
            this.nativeProcess.destroy();
            this.nativeProcess = null;
        }
        if (this.exepath == null || this.exepath.length == 0 || this.exepath[0] == null) {
            throw new IOException("Could not find decompiler executable");
        }
        try {
            this.nativeProcess = this.runtime.exec(this.exepath);
            this.nativeIn = this.nativeProcess.getInputStream();
            this.nativeOut = this.nativeProcess.getOutputStream();
            this.statusGood = true;
        }
        catch (IOException e) {
            this.disposestate = DisposeState.DISPOSED_ON_STARTUP_FAILURE;
            this.statusGood = false;
            Msg.showError((Object)this, null, (String)"Problem launching decompiler", (Object)"Please report this stack trace to the Ghidra Team", (Throwable)e);
            throw e;
        }
    }

    private int readToBurst() throws IOException {
        if (this.nativeIn == null) {
            throw new IOException("Decompiler disposed!");
        }
        while (true) {
            int cur;
            if ((cur = this.nativeIn.read()) > 0) {
                continue;
            }
            if (cur == -1) break;
            while ((cur = this.nativeIn.read()) == 0) {
            }
            if (cur == 1) {
                cur = this.nativeIn.read();
                if (cur == -1) break;
                return cur;
            }
            if (cur == -1) break;
        }
        throw new IOException("Decompiler process died");
    }

    private void readToResponse() throws IOException, DecompileException {
        int type;
        this.nativeOut.flush();
        while (((type = this.readToBurst()) & 1) == 1) {
        }
        if (type == 10) {
            this.generateException();
        }
        if (type == 6) {
            return;
        }
        throw new IOException("Ghidra/decompiler alignment error");
    }

    private int readToBuffer(ByteIngest buf) throws IOException {
        int cur;
        do {
            buf.ingestStream(this.nativeIn);
            while ((cur = this.nativeIn.read()) == 0) {
            }
            if (cur != 1 || (cur = this.nativeIn.read()) <= 0) continue;
            return cur;
        } while (cur != -1);
        throw new IOException("Decompiler process died");
    }

    private void readQueryParam(ByteIngest ingester) throws IOException {
        int type = this.readToBurst();
        if (type != 14) {
            throw new IOException("GHIDRA/decompiler alignment error");
        }
        ingester.open(65536, this.programSource);
        type = this.readToBuffer(ingester);
        if (type != 15) {
            throw new IOException("GHIDRA/decompiler alignment error");
        }
        ingester.endIngest();
    }

    private void writeString(String msg) throws IOException {
        this.write(string_start);
        this.write(msg.getBytes());
        this.write(string_end);
    }

    private void writeString(Encoder byteResult) throws IOException {
        if (this.nativeOut == null) {
            return;
        }
        this.write(string_start);
        byteResult.writeTo(this.nativeOut);
        this.write(string_end);
    }

    private void generateException() throws IOException, DecompileException {
        this.readQueryParam((ByteIngest)this.stringDecoder);
        String type = this.stringDecoder.toString();
        this.readQueryParam((ByteIngest)this.stringDecoder);
        String message = this.stringDecoder.toString();
        this.readToBurst();
        if (type.equals("alignment")) {
            throw new IOException("Alignment error: " + message);
        }
        throw new DecompileException(type, message);
    }

    /*
     * Unable to fully structure code
     */
    private void readResponse(ByteIngest mainResponse) throws IOException, DecompileException {
        mainResponse.clear();
        this.readToResponse();
        type = this.readToBurst();
        currentResponse = null;
        while (type != 7) {
            switch (type) {
                case 4: {
                    this.readQueryParam((ByteIngest)this.paramDecoder);
                    try {
                        commandId = this.paramDecoder.openElement();
                        switch (commandId) {
                            case 239: {
                                this.isNameUsed();
                                break;
                            }
                            case 240: {
                                this.getBytes();
                                break;
                            }
                            case 245: {
                                this.getComments();
                                break;
                            }
                            case 241: {
                                this.getPcodeInject(1);
                                break;
                            }
                            case 243: {
                                this.getPcodeInject(2);
                                break;
                            }
                            case 242: {
                                this.getPcodeInject(3);
                                break;
                            }
                            case 252: {
                                this.getPcodeInject(4);
                                break;
                            }
                            case 246: {
                                this.getCPoolRef();
                                break;
                            }
                            case 248: {
                                this.getExternalRef();
                                break;
                            }
                            case 249: {
                                this.getMappedSymbols();
                                break;
                            }
                            case 250: {
                                this.getNamespacePath();
                                break;
                            }
                            case 251: {
                                this.getPcode();
                                break;
                            }
                            case 253: {
                                this.getRegister();
                                break;
                            }
                            case 254: {
                                this.getRegisterName();
                                break;
                            }
                            case 255: {
                                this.getStringData();
                                break;
                            }
                            case 244: {
                                this.getCodeLabel();
                                break;
                            }
                            case 247: {
                                this.getDataType();
                                break;
                            }
                            case 256: {
                                this.getTrackedRegisters();
                                break;
                            }
                            case 257: {
                                this.getUserOpName();
                                break;
                            }
                            default: {
                                throw new Exception("Unsupported decompiler query");
                            }
                        }
                    }
                    catch (Exception e) {
                        this.write(DecompileProcess.exception_start);
                        extype = e.getClass().getName();
                        msg = e.getMessage();
                        if (msg == null) {
                            msg = "";
                        }
                        this.writeString(extype);
                        this.writeString(msg);
                        this.write(DecompileProcess.exception_end);
                        if (this.disposestate != DisposeState.NOT_DISPOSED) ** GOTO lbl83
                        Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    }
lbl83:
                    // 3 sources

                    this.nativeOut.flush();
                    this.readToBurst();
                    break;
                }
                case 6: {
                    throw new IOException("GHIDRA/decompiler out of alignment");
                }
                case 10: {
                    this.generateException();
                    break;
                }
                case 14: {
                    if (currentResponse != null) {
                        throw new IOException("Nested decompiler output");
                    }
                    currentResponse = mainResponse;
                    currentResponse.open(this.maxResultSizeMBYtes << 20, this.programSource);
                    break;
                }
                case 15: {
                    if (currentResponse == null) {
                        throw new IOException("Mismatched string header");
                    }
                    currentResponse.endIngest();
                    currentResponse = null;
                    break;
                }
                case 16: {
                    if (currentResponse != null) {
                        currentResponse.clear();
                    }
                    currentResponse = this.stringDecoder;
                    currentResponse.open(0x100000, this.programSource);
                    break;
                }
                case 17: {
                    if (currentResponse == null) {
                        throw new IOException("Mismatched message header");
                    }
                    currentResponse.endIngest();
                    this.callback.setNativeMessage(currentResponse.toString());
                    currentResponse = null;
                    break;
                }
                default: {
                    throw new IOException("GHIDRA/decompiler alignment error");
                }
            }
            if (currentResponse == null) {
                type = this.readToBurst();
                continue;
            }
            type = this.readToBuffer(currentResponse);
        }
    }

    public synchronized void registerProgram(DecompileCallback cback, String pspecxml, String cspecxml, String tspecxml, String coretypesxml, Program program) throws IOException, DecompileException {
        this.callback = cback;
        this.programSource = program.getName();
        this.paramDecoder = new PackedDecode(program.getAddressFactory());
        this.resultEncoder = new PackedEncode();
        StringIngest response = new StringIngest();
        this.setup();
        try {
            this.write(command_start);
            this.writeString("registerProgram");
            this.writeString(pspecxml);
            this.writeString(cspecxml);
            this.writeString(tspecxml);
            this.writeString(coretypesxml);
            this.write(command_end);
            this.readResponse((ByteIngest)response);
        }
        catch (IOException e) {
            this.statusGood = false;
            throw e;
        }
        this.archId = Integer.parseInt(response.toString());
    }

    public synchronized int deregisterProgram() throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException("deregisterProgram called on bad process");
        }
        this.statusGood = false;
        this.write(command_start);
        this.writeString("deregisterProgram");
        this.writeString(Integer.toString(this.archId));
        this.write(command_end);
        this.paramDecoder = null;
        this.resultEncoder = null;
        StringIngest response = new StringIngest();
        this.readResponse((ByteIngest)response);
        int res = Integer.parseInt(response.toString());
        this.callback = null;
        this.programSource = null;
        this.paramDecoder = null;
        this.resultEncoder = null;
        return res;
    }

    public synchronized void sendCommand(String command, ByteIngest response) throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException(command + " called on bad process");
        }
        this.paramDecoder = null;
        this.resultEncoder = null;
        try {
            this.write(command_start);
            this.writeString(command);
            this.writeString(Integer.toString(this.archId));
            this.write(command_end);
            this.readResponse(response);
        }
        catch (IOException e) {
            this.statusGood = false;
            throw e;
        }
    }

    public synchronized boolean isReady() {
        return this.statusGood;
    }

    public synchronized void sendCommandTimeout(String command, int timeoutSecs, DecompInterface.EncodeDecodeSet encodeSet) throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException(command + " called on bad process");
        }
        this.paramDecoder = encodeSet.callbackQuery;
        this.resultEncoder = encodeSet.callbackResponse;
        int validatedTimeoutMs = this.getTimeoutMs(timeoutSecs);
        GTimerMonitor timerMonitor = GTimer.scheduleRunnable((long)validatedTimeoutMs, (Runnable)this.timeoutRunnable);
        try {
            this.write(command_start);
            this.writeString(command);
            this.writeString(Integer.toString(this.archId));
            this.writeString(encodeSet.mainQuery);
            this.write(command_end);
            this.readResponse((ByteIngest)encodeSet.mainResponse);
        }
        catch (IOException e) {
            this.statusGood = false;
            if (timerMonitor.didRun()) {
                throw new DecompileException("process", "timeout");
            }
            throw e;
        }
        finally {
            timerMonitor.cancel();
        }
    }

    private int getTimeoutMs(int timeoutSecs) {
        if (timeoutSecs == 0) {
            return -1;
        }
        return timeoutSecs * 1000;
    }

    public synchronized void sendCommand2Params(String command, String param1, String param2, ByteIngest response) throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException(command + " called on bad process");
        }
        this.paramDecoder = null;
        this.resultEncoder = null;
        try {
            this.write(command_start);
            this.writeString(command);
            this.writeString(Integer.toString(this.archId));
            this.writeString(param1);
            this.writeString(param2);
            this.write(command_end);
            this.readResponse(response);
        }
        catch (IOException e) {
            this.statusGood = false;
            throw e;
        }
    }

    public void setMaxResultSize(int maxResultSizeMBytes) {
        this.maxResultSizeMBYtes = maxResultSizeMBytes;
    }

    public synchronized void sendCommand1Param(String command, Encoder param1, ByteIngest response) throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException(command + " called on bad process");
        }
        this.paramDecoder = null;
        this.resultEncoder = null;
        try {
            this.write(command_start);
            this.writeString(command);
            this.writeString(Integer.toString(this.archId));
            this.writeString(param1);
            this.write(command_end);
            this.readResponse(response);
        }
        catch (IOException e) {
            this.statusGood = false;
            throw e;
        }
    }

    public synchronized void sendCommand1Param(String command, String param1, ByteIngest response) throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException(command + " called on bad process");
        }
        this.paramDecoder = null;
        this.resultEncoder = null;
        try {
            this.write(command_start);
            this.writeString(command);
            this.writeString(Integer.toString(this.archId));
            this.writeString(param1);
            this.write(command_end);
            this.readResponse(response);
        }
        catch (IOException e) {
            this.statusGood = false;
            throw e;
        }
    }

    private void getRegister() throws IOException, DecoderException {
        this.resultEncoder.clear();
        String name = this.paramDecoder.readString(AttributeId.ATTRIB_NAME);
        this.callback.getRegister(name, (Encoder)this.resultEncoder);
        this.write(query_response_start);
        if (!this.resultEncoder.isEmpty()) {
            this.writeString((Encoder)this.resultEncoder);
        }
        this.write(query_response_end);
    }

    private void getRegisterName() throws IOException, DecoderException {
        int el = this.paramDecoder.openElement(ElementId.ELEM_ADDR);
        Address addr = AddressXML.decodeFromAttributes((Decoder)this.paramDecoder);
        int size = (int)this.paramDecoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
        this.paramDecoder.closeElement(el);
        String res = this.callback.getRegisterName(addr, size);
        this.write(query_response_start);
        this.writeString(res);
        this.write(query_response_end);
    }

    private void getTrackedRegisters() throws IOException, DecoderException {
        this.resultEncoder.clear();
        Address addr = AddressXML.decode((Decoder)this.paramDecoder);
        this.callback.getTrackedRegisters(addr, (Encoder)this.resultEncoder);
        this.write(query_response_start);
        this.writeString((Encoder)this.resultEncoder);
        this.write(query_response_end);
    }

    private void getUserOpName() throws IOException, DecoderException {
        int index = (int)this.paramDecoder.readSignedInteger(AttributeId.ATTRIB_INDEX);
        String res = this.callback.getUserOpName(index);
        if (res == null) {
            res = "";
        }
        this.write(query_response_start);
        this.writeString(res);
        this.write(query_response_end);
    }

    private void getPcode() throws IOException, DecoderException {
        this.resultEncoder.clear();
        Address addr = AddressXML.decode((Decoder)this.paramDecoder);
        this.callback.getPcode(addr, this.resultEncoder);
        this.write(query_response_start);
        if (!this.resultEncoder.isEmpty()) {
            this.writeString((Encoder)this.resultEncoder);
        }
        this.write(query_response_end);
    }

    private void getPcodeInject(int type) throws IOException, DecoderException, UnknownInstructionException, MemoryAccessException, NotFoundException {
        this.resultEncoder.clear();
        String name = this.paramDecoder.readString(AttributeId.ATTRIB_NAME);
        this.callback.getPcodeInject(name, (Decoder)this.paramDecoder, type, (Encoder)this.resultEncoder);
        this.write(query_response_start);
        if (!this.resultEncoder.isEmpty()) {
            this.writeString((Encoder)this.resultEncoder);
        }
        this.write(query_response_end);
    }

    private void getCPoolRef() throws IOException, DecoderException {
        this.resultEncoder.clear();
        int size = (int)this.paramDecoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
        long[] refs = new long[size];
        for (int i = 0; i < size; ++i) {
            int el = this.paramDecoder.openElement(ElementId.ELEM_VALUE);
            refs[i] = this.paramDecoder.readUnsignedInteger(AttributeId.ATTRIB_CONTENT);
            this.paramDecoder.closeElement(el);
        }
        this.callback.getCPoolRef(refs, (Encoder)this.resultEncoder);
        this.write(query_response_start);
        if (!this.resultEncoder.isEmpty()) {
            this.writeString((Encoder)this.resultEncoder);
        }
        this.write(query_response_end);
    }

    private void getMappedSymbols() throws IOException, DecoderException {
        this.resultEncoder.clear();
        Address addr = AddressXML.decode((Decoder)this.paramDecoder);
        this.callback.getMappedSymbols(addr, (Encoder)this.resultEncoder);
        this.write(query_response_start);
        if (!this.resultEncoder.isEmpty()) {
            this.writeString((Encoder)this.resultEncoder);
        }
        this.write(query_response_end);
    }

    private void getNamespacePath() throws IOException, DecoderException {
        this.resultEncoder.clear();
        long id = this.paramDecoder.readUnsignedInteger(AttributeId.ATTRIB_ID);
        this.callback.getNamespacePath(id, (Encoder)this.resultEncoder);
        this.write(query_response_start);
        if (!this.resultEncoder.isEmpty()) {
            this.writeString((Encoder)this.resultEncoder);
        }
        this.write(query_response_end);
    }

    private void isNameUsed() throws IOException, DecoderException {
        String name = this.paramDecoder.readString(AttributeId.ATTRIB_NAME);
        long startId = this.paramDecoder.readUnsignedInteger(AttributeId.ATTRIB_FIRST);
        long stopId = this.paramDecoder.readUnsignedInteger(AttributeId.ATTRIB_LAST);
        boolean res = this.callback.isNameUsed(name, startId, stopId);
        this.write(query_response_start);
        this.write(string_start);
        this.write(res ? 116 : 102);
        this.write(string_end);
        this.write(query_response_end);
    }

    private void getExternalRef() throws IOException, DecoderException {
        this.resultEncoder.clear();
        Address addr = AddressXML.decode((Decoder)this.paramDecoder);
        this.callback.getExternalRef(addr, (Encoder)this.resultEncoder);
        this.write(query_response_start);
        if (!this.resultEncoder.isEmpty()) {
            this.writeString((Encoder)this.resultEncoder);
        }
        this.write(query_response_end);
    }

    private void getCodeLabel() throws IOException, DecoderException {
        Address addr = AddressXML.decode((Decoder)this.paramDecoder);
        String res = this.callback.getCodeLabel(addr);
        if (res == null) {
            res = "";
        }
        this.write(query_response_start);
        this.writeString(res);
        this.write(query_response_end);
    }

    private void getComments() throws IOException, DecoderException {
        this.resultEncoder.clear();
        int types = (int)this.paramDecoder.readUnsignedInteger(AttributeId.ATTRIB_TYPE);
        Address addr = AddressXML.decode((Decoder)this.paramDecoder);
        this.callback.getComments(addr, types, (Encoder)this.resultEncoder);
        this.write(query_response_start);
        this.writeString((Encoder)this.resultEncoder);
        this.write(query_response_end);
    }

    private void getDataType() throws IOException, DecoderException {
        this.resultEncoder.clear();
        String name = this.paramDecoder.readString(AttributeId.ATTRIB_NAME);
        long id = this.paramDecoder.readSignedInteger(AttributeId.ATTRIB_ID);
        this.callback.getDataType(name, id, (Encoder)this.resultEncoder);
        this.write(query_response_start);
        if (!this.resultEncoder.isEmpty()) {
            this.writeString((Encoder)this.resultEncoder);
        }
        this.write(query_response_end);
    }

    private void getBytes() throws IOException, DecoderException {
        int el = this.paramDecoder.openElement(ElementId.ELEM_ADDR);
        Address addr = AddressXML.decodeFromAttributes((Decoder)this.paramDecoder);
        int size = (int)this.paramDecoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
        this.paramDecoder.closeElement(el);
        byte[] res = this.callback.getBytes(addr, size);
        this.write(query_response_start);
        if (res != null && res.length > 0) {
            this.write(byte_start);
            byte[] dblres = new byte[res.length * 2];
            for (int i = 0; i < res.length; ++i) {
                dblres[i * 2] = (byte)((res[i] >> 4 & 0xF) + 65);
                dblres[i * 2 + 1] = (byte)((res[i] & 0xF) + 65);
            }
            this.write(dblres);
            this.write(byte_end);
        }
        this.write(query_response_end);
    }

    private void getStringData() throws IOException, DecoderException {
        int maxChars = (int)this.paramDecoder.readSignedInteger(AttributeId.ATTRIB_MAXSIZE);
        String dtName = this.paramDecoder.readString(AttributeId.ATTRIB_TYPE);
        long dtId = this.paramDecoder.readUnsignedInteger(AttributeId.ATTRIB_ID);
        Address addr = AddressXML.decode((Decoder)this.paramDecoder);
        DecompileCallback.StringData stringData = this.callback.getStringData(addr, maxChars, dtName, dtId);
        this.write(query_response_start);
        if (stringData != null) {
            byte[] res = stringData.byteData;
            int sz = res.length + 1;
            int sz1 = (sz & 0x3F) + 32;
            int sz2 = ((sz >>>= 6) & 0x3F) + 32;
            this.write(byte_start);
            this.write(sz1);
            this.write(sz2);
            this.write(stringData.isTruncated ? 1 : 0);
            byte[] dblres = new byte[res.length * 2 + 2];
            for (int i = 0; i < res.length; ++i) {
                dblres[i * 2] = (byte)((res[i] >> 4 & 0xF) + 65);
                dblres[i * 2 + 1] = (byte)((res[i] & 0xF) + 65);
            }
            dblres[res.length * 2] = 65;
            dblres[res.length * 2 + 1] = 65;
            this.write(dblres);
            this.write(byte_end);
        }
        this.write(query_response_end);
    }

    private void write(byte[] bytes) throws IOException {
        if (this.nativeOut == null) {
            return;
        }
        this.nativeOut.write(bytes);
    }

    private void write(int i) throws IOException {
        if (this.nativeOut == null) {
            return;
        }
        this.nativeOut.write(i);
    }

    public static enum DisposeState {
        NOT_DISPOSED,
        DISPOSED_ON_TIMEOUT,
        DISPOSED_ON_CANCEL,
        DISPOSED_ON_STARTUP_FAILURE;

    }
}

