/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.address;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileResults;
import ghidra.codecompare.graphanalysis.Pinning;
import ghidra.codecompare.graphanalysis.TokenBin;
import ghidra.feature.vt.api.correlator.address.DebugUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.BasicBlockModel;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.CodeUnitContainer;
import ghidra.program.util.CodeUnitLCS;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CodeCompareAddressCorrelation
implements AddressCorrelation {
    private static final int TIMEOUT_SECONDS = 60;
    private final Function sourceFunction;
    private final Function destinationFunction;
    private final Program sourceProgram;
    private final Program destinationProgram;
    private Map<Address, CorrelationContainer> cachedForwardAddressMap;
    private static final Comparator<CodeUnit> CUCOMPARATOR = new Comparator<CodeUnit>(){

        @Override
        public int compare(CodeUnit o1, CodeUnit o2) {
            return o1.getAddress().compareTo((Object)o2.getAddress());
        }
    };

    public CodeCompareAddressCorrelation(Function sourceFunction, Function destinationFunction) {
        this.sourceFunction = sourceFunction;
        this.destinationFunction = destinationFunction;
        this.sourceProgram = sourceFunction.getProgram();
        this.destinationProgram = destinationFunction.getProgram();
        DebugUtils.enable(false);
    }

    public AddressRange getCorrelatedDestinationRange(Address sourceAddress, TaskMonitor monitor) throws CancelledException {
        this.initialize(monitor);
        CorrelationContainer container = this.cachedForwardAddressMap.get(sourceAddress);
        if (container == null) {
            return null;
        }
        return container.range;
    }

    private void initialize(TaskMonitor monitor) throws CancelledException {
        if (this.cachedForwardAddressMap == null) {
            this.cachedForwardAddressMap = new HashMap<Address, CorrelationContainer>();
            HashMap<Address, Address> sourceToDestinationPairings = new HashMap<Address, Address>();
            HashMap<Address, Address> destinationToSourcePairings = new HashMap<Address, Address>();
            AddressSet sourceSet = new AddressSet();
            AddressSet destinationSet = new AddressSet();
            TreeMap<CodeUnit, TreeSet<AddressRange>> sourceMap = new TreeMap<CodeUnit, TreeSet<AddressRange>>(CUCOMPARATOR);
            TreeMap<CodeUnit, TreeSet<AddressRange>> destinationMap = new TreeMap<CodeUnit, TreeSet<AddressRange>>(CUCOMPARATOR);
            this.processCodeCompare(monitor, sourceToDestinationPairings, destinationToSourcePairings, sourceSet, destinationSet, sourceMap, destinationMap);
            if (this.sourceFunction.getProgram().getLanguage().getProcessor().equals((Object)this.destinationFunction.getProgram().getLanguage().getProcessor())) {
                this.processLCSBlocks(monitor, sourceToDestinationPairings, sourceSet, destinationSet, sourceMap, destinationMap);
            }
            DebugUtils.processMap(sourceMap, this.sourceProgram);
            DebugUtils.processMap(destinationMap, this.destinationProgram);
            DebugUtils.colorize(this.cachedForwardAddressMap, this.sourceProgram, this.destinationProgram);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCodeCompare(TaskMonitor monitor, HashMap<Address, Address> sourceToDestinationPairings, HashMap<Address, Address> destinationToSourcePairings, AddressSet sourceSet, AddressSet destinationSet, Map<CodeUnit, TreeSet<AddressRange>> sourceMap, Map<CodeUnit, TreeSet<AddressRange>> destinationMap) throws CancelledException {
        DecompInterface sourceDecompiler = null;
        DecompInterface destinationDecompiler = null;
        try {
            int destsize;
            sourceDecompiler = new DecompInterface();
            destinationDecompiler = new DecompInterface();
            sourceDecompiler.openProgram(this.sourceProgram);
            destinationDecompiler.openProgram(this.destinationProgram);
            DecompileResults sourceResults = sourceDecompiler.decompileFunction(this.sourceFunction, 60, monitor);
            DecompileResults destinationResults = destinationDecompiler.decompileFunction(this.destinationFunction, 60, monitor);
            ClangTokenGroup sourceMarkup = sourceResults.getCCodeMarkup();
            ClangTokenGroup destinationMarkup = destinationResults.getCCodeMarkup();
            HighFunction sourceHFunc = sourceResults.getHighFunction();
            HighFunction destinationHFunc = destinationResults.getHighFunction();
            Object errorMessage = "";
            if (sourceHFunc == null) {
                errorMessage = (String)errorMessage + " Source Decompiler failed to get function. " + sourceResults.getErrorMessage();
            }
            if (destinationHFunc == null) {
                errorMessage = (String)errorMessage + " Destination Decompiler failed to get function. " + destinationResults.getErrorMessage();
            }
            if (!((String)errorMessage).isEmpty()) {
                throw new RuntimeException((String)errorMessage);
            }
            boolean matchConstantsExactly = false;
            int srcsize = this.sourceProgram.getLanguage().getLanguageDescription().getSize();
            boolean sizeCollapse = srcsize != (destsize = this.destinationProgram.getLanguage().getLanguageDescription().getSize());
            Pinning pin = Pinning.makePinning(sourceHFunc, destinationHFunc, matchConstantsExactly, sizeCollapse, true, monitor);
            ArrayList<TokenBin> highBins = pin.buildTokenMap(sourceMarkup, destinationMarkup);
            for (TokenBin tokenBin : highBins) {
                if (tokenBin.getMatch() == null || tokenBin.getMatch().size() != tokenBin.size()) continue;
                boolean isSourceBin = tokenBin.getHighFunction().equals(sourceHFunc);
                for (int ii = 0; ii < tokenBin.size(); ++ii) {
                    ClangToken binToken = tokenBin.get(ii);
                    ClangToken sidekickToken = tokenBin.getMatch().get(ii);
                    ClangToken sourceToken = isSourceBin ? binToken : sidekickToken;
                    ClangToken destinationToken = isSourceBin ? sidekickToken : binToken;
                    Address srcStart = sourceToken.getMinAddress();
                    Address srcEnd = sourceToken.getMaxAddress();
                    Address destStart = destinationToken.getMinAddress();
                    Address destEnd = destinationToken.getMaxAddress();
                    if (destStart == null || destEnd == null || srcStart == null || srcEnd == null) continue;
                    AddressSet sourceIntersection = sourceSet.intersectRange(srcStart, srcEnd);
                    AddressSet destinationIntersection = destinationSet.intersectRange(destStart, destEnd);
                    if (!sourceIntersection.isEmpty() || !destinationIntersection.isEmpty()) continue;
                    DebugUtils.recordEOLComment(sourceMap, this.sourceProgram, srcStart, srcEnd, this.destinationProgram, destStart, destEnd);
                    DebugUtils.recordEOLComment(destinationMap, this.destinationProgram, destStart, destEnd, this.sourceProgram, srcStart, srcEnd);
                    sourceSet.addRange(srcStart, srcEnd);
                    destinationSet.addRange(destStart, destEnd);
                    sourceToDestinationPairings.put(srcStart, destStart);
                    destinationToSourcePairings.put(destStart, srcStart);
                    AddressRangeImpl range = new AddressRangeImpl(destStart, destEnd);
                    CorrelationContainer container = new CorrelationContainer(CorrelationKind.CODE_COMPARE, (AddressRange)range);
                    while (!srcStart.equals((Object)srcEnd)) {
                        this.cachedForwardAddressMap.put(srcStart, container);
                        srcStart = srcStart.addNoWrap(1L);
                    }
                    this.cachedForwardAddressMap.put(srcStart, container);
                }
            }
        }
        catch (AddressOverflowException e) {
            Msg.error((Object)this, (Object)"Unexpected address overflow; token's range didn't span continguous region", (Throwable)e);
        }
        finally {
            if (sourceDecompiler != null) {
                sourceDecompiler.dispose();
            }
            if (destinationDecompiler != null) {
                destinationDecompiler.dispose();
            }
        }
    }

    private void processLCSBlocks(TaskMonitor monitor, HashMap<Address, Address> sourceToDestinationPairings, AddressSet sourceSet, AddressSet destinationSet, Map<CodeUnit, TreeSet<AddressRange>> sourceMap, Map<CodeUnit, TreeSet<AddressRange>> destinationMap) throws CancelledException {
        BasicBlockModel sourceBlockModel = new BasicBlockModel(this.sourceProgram);
        BasicBlockModel destinationBlockModel = new BasicBlockModel(this.destinationProgram);
        Listing sourceListing = this.sourceProgram.getListing();
        Listing destinationListing = this.destinationProgram.getListing();
        Set<Map.Entry<Address, Address>> entrySet = sourceToDestinationPairings.entrySet();
        for (Map.Entry<Address, Address> entry : entrySet) {
            Address sourceAddress = entry.getKey();
            Address destinationAddress = entry.getValue();
            CodeBlock[] sourceBlocks = sourceBlockModel.getCodeBlocksContaining(sourceAddress, monitor);
            CodeBlock[] destinationBlocks = destinationBlockModel.getCodeBlocksContaining(destinationAddress, monitor);
            if (sourceBlocks == null || destinationBlocks == null || sourceBlocks.length != 1 || destinationBlocks.length != 1) continue;
            CodeUnitIterator sourceCodeUnitIterator = sourceListing.getCodeUnits(sourceAddress, false);
            CodeUnitIterator destinationCodeUnitIterator = destinationListing.getCodeUnits(destinationAddress, false);
            this.processLCSCodeUnits(monitor, sourceSet, destinationSet, sourceMap, destinationMap, sourceCodeUnitIterator, destinationCodeUnitIterator);
            sourceCodeUnitIterator = sourceListing.getCodeUnits(sourceAddress, true);
            destinationCodeUnitIterator = destinationListing.getCodeUnits(destinationAddress, true);
            this.processLCSCodeUnits(monitor, sourceSet, destinationSet, sourceMap, destinationMap, sourceCodeUnitIterator, destinationCodeUnitIterator);
        }
    }

    private void processLCSCodeUnits(TaskMonitor monitor, AddressSet sourceSet, AddressSet destinationSet, Map<CodeUnit, TreeSet<AddressRange>> sourceMap, Map<CodeUnit, TreeSet<AddressRange>> destinationMap, CodeUnitIterator sourceCodeUnitIterator, CodeUnitIterator destinationCodeUnitIterator) throws CancelledException {
        if (sourceCodeUnitIterator.hasNext()) {
            sourceCodeUnitIterator.next();
        }
        if (destinationCodeUnitIterator.hasNext()) {
            destinationCodeUnitIterator.next();
        }
        this.processLCS(sourceMap, destinationMap, sourceSet, destinationSet, sourceCodeUnitIterator, destinationCodeUnitIterator, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLCS(Map<CodeUnit, TreeSet<AddressRange>> sourceMap, Map<CodeUnit, TreeSet<AddressRange>> destinationMap, AddressSet sourceSet, AddressSet destinationSet, CodeUnitIterator sourceCodeUnitIterator, CodeUnitIterator destinationCodeUnitIterator, TaskMonitor monitor) throws CancelledException {
        ArrayList source = this.sourceFunction != null ? CodeCompareAddressCorrelation.getCodeUnits(this.sourceFunction, (AddressSetView)sourceSet, sourceCodeUnitIterator) : new ArrayList();
        ArrayList destination = this.destinationFunction != null ? CodeCompareAddressCorrelation.getCodeUnits(this.destinationFunction, (AddressSetView)destinationSet, destinationCodeUnitIterator) : new ArrayList();
        CodeUnitLCS culcs = new CodeUnitLCS(source, destination);
        List lcs = culcs.getLcs(monitor);
        int lcsSize = lcs.size();
        int sourceII = 0;
        int lcsII = 0;
        int destinationII = 0;
        monitor.setMessage("Defining address ranges...");
        monitor.initialize((long)lcsSize);
        int sourceTransactionID = -1;
        int destinationTransactionID = -1;
        try {
            sourceTransactionID = this.sourceFunction.getProgram().startTransaction("Colorize CodeCompare");
            destinationTransactionID = this.destinationFunction.getProgram().startTransaction("Colorize CodeCompare");
            while (lcsII < lcsSize) {
                monitor.checkCancelled();
                CodeUnitContainer sourceCodeUnit = (CodeUnitContainer)source.get(sourceII);
                CodeUnitContainer lcsCodeUnit = (CodeUnitContainer)lcs.get(lcsII);
                CodeUnitContainer destinationCodeUnit = (CodeUnitContainer)destination.get(destinationII);
                boolean sourceCompare = culcs.matches(sourceCodeUnit, lcsCodeUnit);
                boolean destinationCompare = culcs.matches(lcsCodeUnit, destinationCodeUnit);
                if (sourceCompare == destinationCompare) {
                    if (sourceCompare) {
                        this.defineRange(sourceMap, destinationMap, sourceCodeUnit, destinationCodeUnit);
                        ++lcsII;
                    }
                    ++sourceII;
                    ++destinationII;
                } else if (sourceCompare) {
                    ++destinationII;
                } else if (destinationCompare) {
                    ++sourceII;
                } else {
                    throw new RuntimeException("internal error");
                }
                monitor.incrementProgress(1L);
            }
        }
        finally {
            if (sourceTransactionID != -1) {
                this.sourceFunction.getProgram().endTransaction(sourceTransactionID, true);
            }
            if (destinationTransactionID != -1) {
                this.destinationFunction.getProgram().endTransaction(destinationTransactionID, true);
            }
        }
        this.computeParamCorrelation();
    }

    private void computeParamCorrelation() {
        Parameter[] destinationParameters;
        Parameter[] sourceParameters = this.sourceFunction.getParameters();
        if (sourceParameters.length != (destinationParameters = this.destinationFunction.getParameters()).length) {
            return;
        }
        HashMap<Address, CorrelationContainer> map = new HashMap<Address, CorrelationContainer>();
        for (int i = 0; i < sourceParameters.length; ++i) {
            VariableStorage destParamStorage;
            Parameter sourceParameter = sourceParameters[i];
            Parameter destinationParameter = destinationParameters[i];
            if (!sourceParameter.isValid() || !destinationParameter.isValid()) {
                return;
            }
            VariableStorage sourceParamStorage = sourceParameter.getVariableStorage();
            if (!sourceParamStorage.equals((Object)(destParamStorage = destinationParameter.getVariableStorage()))) {
                return;
            }
            Address dest = sourceParamStorage.getMinAddress();
            Address src = destParamStorage.getMinAddress();
            map.put(src, new CorrelationContainer(CorrelationKind.PARAMETERS, (AddressRange)new AddressRangeImpl(dest, dest)));
        }
        this.cachedForwardAddressMap.putAll(map);
    }

    private void defineRange(Map<CodeUnit, TreeSet<AddressRange>> sourceMap, Map<CodeUnit, TreeSet<AddressRange>> destinationMap, CodeUnitContainer sourceCodeUnit, CodeUnitContainer destinationCodeUnit) {
        Address minAddress = sourceCodeUnit.getCodeUnit().getMinAddress();
        Address maxAddress = sourceCodeUnit.getCodeUnit().getMaxAddress();
        AddressRangeImpl toRange = new AddressRangeImpl(destinationCodeUnit.getCodeUnit().getMinAddress(), destinationCodeUnit.getCodeUnit().getMaxAddress());
        CorrelationContainer container = new CorrelationContainer(CorrelationKind.LCS, (AddressRange)toRange);
        DebugUtils.recordEOLComment(sourceMap, this.sourceProgram, minAddress, maxAddress, this.destinationProgram, destinationCodeUnit.getCodeUnit().getMinAddress(), destinationCodeUnit.getCodeUnit().getMaxAddress());
        DebugUtils.recordEOLComment(destinationMap, this.destinationProgram, destinationCodeUnit.getCodeUnit().getMinAddress(), destinationCodeUnit.getCodeUnit().getMaxAddress(), this.sourceProgram, minAddress, maxAddress);
        while (!minAddress.equals((Object)maxAddress)) {
            this.cachedForwardAddressMap.put(minAddress, container);
            minAddress = minAddress.next();
        }
        this.cachedForwardAddressMap.put(maxAddress, container);
    }

    private static List<CodeUnitContainer> getCodeUnits(Function function, AddressSetView correlations, CodeUnitIterator codeUnits) {
        CodeUnit next;
        Address address;
        AddressSetView body = function.getBody();
        ArrayList<CodeUnitContainer> result = new ArrayList<CodeUnitContainer>();
        while (codeUnits.hasNext() && !correlations.contains(address = (next = codeUnits.next()).getAddress()) && body.contains(address)) {
            result.add(new CodeUnitContainer(next));
        }
        return result;
    }

    public String getName() {
        return "CodeCompareAddressCorrelator";
    }

    static class CorrelationContainer {
        public static boolean USE_RANDOM_CC_COLORS = false;
        public final CorrelationKind kind;
        public final AddressRange range;

        public CorrelationContainer(CorrelationKind kind, AddressRange range) {
            this.kind = kind;
            this.range = range;
        }
    }

    static enum CorrelationKind {
        CODE_COMPARE,
        LCS,
        PARAMETERS;

    }
}

