/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import db.LongField;
import db.Schema;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.util.Arrays;

public class DBRecord
implements Comparable<DBRecord> {
    final Schema schema;
    private Field key;
    private Field[] fieldValues;
    private int length = -1;
    boolean dirty = false;

    DBRecord(Schema schema, Field key) {
        this.schema = schema;
        this.key = key;
        if (!schema.getKeyFieldType().isSameType(key)) {
            throw new IllegalArgumentException("key differs from schema key type");
        }
        Field[] schemaFields = schema.getFields();
        this.fieldValues = new Field[schemaFields.length];
        for (int colIndex = 0; colIndex < schemaFields.length; ++colIndex) {
            try {
                this.fieldValues[colIndex] = schemaFields[colIndex].newField();
                if (!schema.isSparseColumn(colIndex)) continue;
                this.fieldValues[colIndex].setNull();
                continue;
            }
            catch (Exception e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    protected void invalidateLength() {
        this.length = -1;
    }

    public void setKey(long key) {
        if (!(this.key instanceof LongField)) {
            throw new AssertException();
        }
        this.key = new LongField(key);
    }

    public void setKey(Field key) {
        if (!this.key.getClass().equals(key.getClass())) {
            throw new AssertException();
        }
        this.key = key;
    }

    public long getKey() {
        return this.key.getLongValue();
    }

    public Field getKeyField() {
        return this.key;
    }

    public boolean hasSameSchema(DBRecord otherRec) {
        Field[] otherFieldValues = otherRec.fieldValues;
        if (this.fieldValues.length != otherFieldValues.length) {
            return false;
        }
        for (int i = 0; i < this.fieldValues.length; ++i) {
            if (this.fieldValues[i].getClass().equals(otherFieldValues[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public boolean hasSameSchema(Schema otherSchema) {
        if (otherSchema == this.schema) {
            return true;
        }
        if (this.fieldValues.length != otherSchema.getFieldCount()) {
            return false;
        }
        if (!this.key.isSameType(otherSchema.getKeyFieldType())) {
            return false;
        }
        Field[] otherFields = otherSchema.getFields();
        for (int i = 0; i < this.fieldValues.length; ++i) {
            if (this.fieldValues[i].isSameType(otherFields[i])) continue;
            return false;
        }
        return true;
    }

    public int getColumnCount() {
        return this.fieldValues.length;
    }

    public Field getFieldValue(int columnIndex) {
        Field f = this.fieldValues[columnIndex];
        return f.copyField();
    }

    public void setField(int colIndex, Field value) {
        if (this.fieldValues[colIndex].getFieldType() != value.getFieldType()) {
            throw new IllegalArgumentException();
        }
        this.invalidateLength();
        this.fieldValues[colIndex] = value;
    }

    Field getField(int columnIndex) {
        return this.fieldValues[columnIndex];
    }

    Field[] getFields() {
        return this.fieldValues;
    }

    public boolean fieldEquals(int columnIndex, Field field) {
        return this.fieldValues[columnIndex].equals(field);
    }

    public int compareFieldTo(int columnIndex, Field value) {
        return this.fieldValues[columnIndex].compareTo(value);
    }

    public DBRecord copy() {
        DBRecord r = this.schema.createRecord(this.key.copyField());
        for (int i = 0; i < this.fieldValues.length; ++i) {
            r.setField(i, this.fieldValues[i].copyField());
        }
        return r;
    }

    public final int length() {
        if (this.length < 0) {
            this.length = this.computeLength();
        }
        return this.length;
    }

    int computeLength() {
        int len = 0;
        for (Field fieldValue : this.fieldValues) {
            len += fieldValue.length();
        }
        return len;
    }

    public long getLongValue(int colIndex) {
        return this.fieldValues[colIndex].getLongValue();
    }

    public void setLongValue(int colIndex, long value) {
        this.dirty = true;
        this.fieldValues[colIndex].setLongValue(value);
    }

    public int getIntValue(int colIndex) {
        return this.fieldValues[colIndex].getIntValue();
    }

    public void setIntValue(int colIndex, int value) {
        this.dirty = true;
        this.fieldValues[colIndex].setIntValue(value);
    }

    public short getShortValue(int colIndex) {
        return this.fieldValues[colIndex].getShortValue();
    }

    public void setShortValue(int colIndex, short value) {
        this.dirty = true;
        this.fieldValues[colIndex].setShortValue(value);
    }

    public byte getByteValue(int colIndex) {
        return this.fieldValues[colIndex].getByteValue();
    }

    public void setByteValue(int colIndex, byte value) {
        this.dirty = true;
        this.fieldValues[colIndex].setByteValue(value);
    }

    public boolean getBooleanValue(int colIndex) {
        return this.fieldValues[colIndex].getBooleanValue();
    }

    public void setBooleanValue(int colIndex, boolean value) {
        this.dirty = true;
        this.fieldValues[colIndex].setBooleanValue(value);
    }

    public byte[] getBinaryData(int colIndex) {
        return this.fieldValues[colIndex].getBinaryData();
    }

    public void setBinaryData(int colIndex, byte[] bytes) {
        this.dirty = true;
        Field f = this.fieldValues[colIndex];
        if (f.isVariableLength()) {
            this.invalidateLength();
        }
        f.setBinaryData(bytes);
    }

    public void setNull(int colIndex) {
        this.dirty = true;
        Field f = this.fieldValues[colIndex];
        if (f.isVariableLength()) {
            this.invalidateLength();
        }
        f.setNull();
    }

    public String getString(int colIndex) {
        return this.fieldValues[colIndex].getString();
    }

    public void setString(int colIndex, String str) {
        this.dirty = true;
        this.invalidateLength();
        this.fieldValues[colIndex].setString(str);
    }

    public void write(Buffer buf, int offset) throws IndexOutOfBoundsException, IOException {
        for (Field fieldValue : this.fieldValues) {
            offset = fieldValue.write(buf, offset);
        }
        this.dirty = false;
    }

    public void read(Buffer buf, int offset) throws IndexOutOfBoundsException, IOException {
        for (Field fieldValue : this.fieldValues) {
            offset = fieldValue.read(buf, offset);
        }
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBRecord)) {
            return false;
        }
        DBRecord rec = (DBRecord)obj;
        return this.key.equals(rec.key) && Arrays.equals(this.fieldValues, rec.fieldValues);
    }

    @Override
    public int compareTo(DBRecord otherRec) {
        return this.key.compareTo(otherRec.key);
    }

    public String toString() {
        return "{key:" + this.key + "}";
    }
}

